/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.element;

import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Module;
import forge.com.gitlab.cdagaming.craftpresence.config.element.Button;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PresenceData
extends Module
implements Serializable {
    private static final long serialVersionUID = -7560029890988753870L;
    private static PresenceData DEFAULT;
    public boolean enabled = true;
    public boolean useAsMain = false;
    public String details = "";
    public String gameState = "";
    public String largeImageKey = "";
    public String largeImageText = "";
    public String smallImageKey = "";
    public String smallImageText = "";
    public String startTimestamp = "";
    public String endTimestamp = "";
    public Map<String, Button> buttons = new HashMap<String, Button>(){
        private static final long serialVersionUID = -1738414795267027009L;
        {
            this.put("default", new Button(ModUtils.TRANSLATOR.translate("craftpresence.defaults.display.button.label", new Object[0]), ModUtils.TRANSLATOR.translate("craftpresence.defaults.display.button.url", new Object[0])));
        }
    };

    public PresenceData(PresenceData other) {
        if (other != null) {
            this.enabled = other.enabled;
            this.useAsMain = other.useAsMain;
            this.setDetails(other.details);
            this.setGameState(other.gameState);
            this.setLargeImage(other.largeImageKey, other.largeImageText);
            this.setSmallImage(other.smallImageKey, other.smallImageText);
            this.setTimes(other.startTimestamp, other.endTimestamp);
            for (Map.Entry<String, Button> data : other.buttons.entrySet()) {
                this.addButton(data.getKey(), data.getValue());
            }
        }
    }

    public PresenceData() {
    }

    @Override
    public PresenceData getDefaults() {
        if (DEFAULT == null) {
            DEFAULT = new PresenceData();
        }
        return new PresenceData(DEFAULT);
    }

    public PresenceData setDetails(String details) {
        this.details = details;
        return this;
    }

    public PresenceData setGameState(String gameState) {
        this.gameState = gameState;
        return this;
    }

    public PresenceData setLargeImage(String imageKey, String imageText) {
        this.largeImageKey = imageKey;
        this.largeImageText = imageText;
        return this;
    }

    public PresenceData setSmallImage(String imageKey, String imageText) {
        this.smallImageKey = imageKey;
        this.smallImageText = imageText;
        return this;
    }

    public PresenceData setTimes(String startTimestamp, String endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        return this;
    }

    public PresenceData setStartTime(String timestamp) {
        return this.setTimes(timestamp, this.endTimestamp);
    }

    public PresenceData setEndTime(String timestamp) {
        return this.setTimes(this.startTimestamp, timestamp);
    }

    public PresenceData addButton(String name, Button button) {
        this.buttons.put(name, button);
        return this;
    }

    public PresenceData removeButton(String name) {
        this.buttons.remove(name);
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(PresenceData.class, (Object)this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(PresenceData.class, (Object)this, new Pair<String, Object>(name, value));
    }

    @Override
    public boolean equals(Object obj) {
        boolean areButtonsEqual;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PresenceData)) {
            return false;
        }
        PresenceData p = (PresenceData)obj;
        boolean bl = areButtonsEqual = this.buttons.size() == p.buttons.size();
        if (areButtonsEqual) {
            for (Map.Entry<String, Button> entry : this.buttons.entrySet()) {
                String key = entry.getKey();
                if (p.buttons.containsKey(key) && p.buttons.get(key).equals(entry.getValue())) continue;
                areButtonsEqual = false;
                break;
            }
        }
        return (p.details == null && this.details == null || p.details != null && p.details.equals(this.details)) && (p.gameState == null && this.gameState == null || p.gameState != null && p.gameState.equals(this.gameState)) && (p.largeImageKey == null && this.largeImageKey == null || p.largeImageKey != null && p.largeImageKey.equals(this.largeImageKey)) && (p.largeImageText == null && this.largeImageText == null || p.largeImageText != null && p.largeImageText.equals(this.largeImageText)) && (p.smallImageKey == null && this.smallImageKey == null || p.smallImageKey != null && p.smallImageKey.equals(this.smallImageKey)) && (p.startTimestamp == null && this.startTimestamp == null || p.startTimestamp != null && p.startTimestamp.equals(this.startTimestamp)) && (p.endTimestamp == null && this.endTimestamp == null || p.endTimestamp != null && p.endTimestamp.equals(this.endTimestamp)) && areButtonsEqual;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.gameState != null ? this.gameState.hashCode() : 0);
        result = 31 * result + (this.largeImageKey != null ? this.largeImageKey.hashCode() : 0);
        result = 31 * result + (this.largeImageText != null ? this.largeImageText.hashCode() : 0);
        result = 31 * result + (this.smallImageKey != null ? this.smallImageKey.hashCode() : 0);
        result = 31 * result + (this.startTimestamp != null ? this.startTimestamp.hashCode() : 0);
        result = 31 * result + (this.endTimestamp != null ? this.endTimestamp.hashCode() : 0);
        result = 31 * result + (this.buttons != null ? this.buttons.hashCode() : 0);
        return result;
    }
}

