/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Advanced;
import forge.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.client.gui.GuiScreen;

public class AdvancedSettingsGui
extends ExtendedScreen {
    private final Advanced CONFIG;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl guiMessagesButton;
    private ExtendedButtonControl itemMessagesButton;
    private ExtendedButtonControl entityTargetMessagesButton;
    private ExtendedButtonControl entityRidingMessagesButton;
    private CheckBoxControl enableCommandsButton;
    private CheckBoxControl enablePerGuiButton;
    private CheckBoxControl enablePerItemButton;
    private CheckBoxControl enablePerEntityButton;
    private CheckBoxControl renderTooltipsButton;
    private CheckBoxControl formatWordsButton;
    private CheckBoxControl debugModeButton;
    private CheckBoxControl verboseModeButton;
    private CheckBoxControl allowPlaceholderPreviewsButton;
    private CheckBoxControl allowEndpointIconsButton;
    private ExtendedTextControl refreshRate;

    AdvancedSettingsGui(GuiScreen parentScreen) {
        super(parentScreen);
        this.CONFIG = CraftPresence.CONFIG.advancedSettings;
    }

    @Override
    public void initializeUi() {
        int calc1 = this.getScreenWidth() / 2 - 160;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.allowEndpointIconsButton = this.addControl(new CheckBoxControl(calc1 + 2, CraftPresence.GUIS.getButtonY(1, 3), "gui.config.name.advanced.allow_endpoint_icons", this.CONFIG.allowEndpointIcons, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.allow_endpoint_icons", new Object[0])), this, true)));
        this.refreshRate = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 103, CraftPresence.GUIS.getButtonY(1), 45, 20));
        this.refreshRate.setControlMessage(Integer.toString(this.CONFIG.refreshRate));
        this.refreshRate.setControlMaxLength(3);
        this.guiMessagesButton = this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(2), 160, 20, "gui.config.name.advanced.gui_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.gui", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, true, true, ScrollableListControl.RenderType.None.setIdentifierType(ScrollableListControl.RenderType.IdentifierType.Gui), null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.guiSettings.guiData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.guiSettings.guiData.get("default");
            screenInstance.currentData = this.CONFIG.guiSettings.guiData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.gui.edit_specific_gui", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.guiSettings.guiData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.GUIS.GUI_NAMES.contains(attributeName)) {
                CraftPresence.GUIS.GUI_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.guiSettings.guiData.remove(attributeName);
            if (!screenInstance.isPreliminaryData) {
                CraftPresence.GUIS.GUI_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                CraftPresence.GUIS.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.CONFIG.guiSettings.fallbackGuiIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                CraftPresence.GUIS.openScreen(new SelectorGui((GuiScreen)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", CraftPresence.CLIENT.generateArgumentMessage("screen."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.guiMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.gui_messages", CraftPresence.CLIENT.generateArgumentMessage("screen."))), this, true);
            }
        }, new String[0]));
        this.itemMessagesButton = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(2), 160, 20, "gui.config.name.advanced.item_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.CONFIG.itemMessages.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", attributeName);
            screenInstance.originalPrimaryMessage = this.CONFIG.itemMessages.getOrDefault("default", "");
            screenInstance.primaryMessage = this.CONFIG.itemMessages.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.itemMessages.put((String)attributeName, (String)inputText);
            if (!CraftPresence.TILE_ENTITIES.ITEM_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.ITEM_NAMES.add((String)attributeName);
            }
            if (!CraftPresence.TILE_ENTITIES.BLOCK_NAMES.contains(attributeName)) {
                CraftPresence.TILE_ENTITIES.BLOCK_NAMES.add((String)attributeName);
            }
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.verifyEntities();
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.itemMessages.remove(attributeName);
            CraftPresence.TILE_ENTITIES.ITEM_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.BLOCK_NAMES.remove(attributeName);
            CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES.remove(attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", CraftPresence.CLIENT.generateArgumentMessage("item."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.itemMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.item_messages", CraftPresence.CLIENT.generateArgumentMessage("item."))), this, true);
            }
        }, new String[0]));
        this.entityTargetMessagesButton = this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(3), 160, 20, "gui.config.name.advanced.entity_target_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.EntityData, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.entitySettings.targetData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.entitySettings.targetData.get("default");
            screenInstance.currentData = this.CONFIG.entitySettings.targetData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.entitySettings.targetData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.entitySettings.targetData.remove(attributeName);
            if (!screenInstance.isPreliminaryData) {
                CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                CraftPresence.GUIS.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.CONFIG.entitySettings.fallbackEntityIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                CraftPresence.GUIS.openScreen(new SelectorGui((GuiScreen)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.target."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.entityTargetMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_target_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.target."))), this, true);
            }
        }, new String[0]));
        this.entityRidingMessagesButton = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(3), 160, 20, "gui.config.name.advanced.entity_riding_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, true, true, ScrollableListControl.RenderType.EntityData, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.entitySettings.ridingData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.entitySettings.ridingData.get("default");
            screenInstance.currentData = this.CONFIG.entitySettings.ridingData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.entity.edit_specific_entity", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.entitySettings.ridingData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.ENTITIES.ENTITY_NAMES.contains(attributeName)) {
                CraftPresence.ENTITIES.ENTITY_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.entitySettings.ridingData.remove(attributeName);
            if (!screenInstance.isPreliminaryData) {
                CraftPresence.ENTITIES.ENTITY_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                CraftPresence.GUIS.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.CONFIG.entitySettings.fallbackEntityIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                CraftPresence.GUIS.openScreen(new SelectorGui((GuiScreen)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.riding."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.entityRidingMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.entity_riding_messages", CraftPresence.CLIENT.generateArgumentMessage("entity.riding."))), this, true);
            }
        }, new String[0]));
        this.enableCommandsButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(4), "gui.config.name.advanced.enable_commands", this.CONFIG.enableCommands, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_commands", new Object[0])), this, true)));
        this.enablePerGuiButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(4), "gui.config.name.advanced.enable_per_gui", this.CONFIG.enablePerGui, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_gui", new Object[0])), this, true)));
        this.enablePerItemButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(5, -10), "gui.config.name.advanced.enable_per_item", this.CONFIG.enablePerItem, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_item", new Object[0])), this, true)));
        this.enablePerEntityButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(5, -10), "gui.config.name.advanced.enable_per_entity", this.CONFIG.enablePerEntity, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.enable_per_entity", new Object[0])), this, true)));
        this.renderTooltipsButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(6, -20), "gui.config.name.advanced.render_tooltips", this.CONFIG.renderTooltips, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.render_tooltips", new Object[0])), this, true)));
        this.formatWordsButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(6, -20), "gui.config.name.advanced.format_words", this.CONFIG.formatWords, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.format_words", new Object[0])), this, true)));
        this.debugModeButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(7, -30), "gui.config.name.advanced.debug_mode", this.CONFIG.debugMode, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.debug_mode", ModUtils.IS_DEV_FLAG)), this, true)));
        this.verboseModeButton = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(7, -30), "gui.config.name.advanced.verbose_mode", this.CONFIG.verboseMode, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.verbose_mode", ModUtils.IS_VERBOSE_FLAG)), this, true)));
        this.allowPlaceholderPreviewsButton = this.addControl(new CheckBoxControl(calc1, CraftPresence.GUIS.getButtonY(8, -40), "gui.config.name.advanced.allow_placeholder_previews", this.CONFIG.allowPlaceholderPreviews, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.allow_placeholder_previews", new Object[0])), this, true)));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (this.allowEndpointIconsButton.isChecked() != this.CONFIG.allowEndpointIcons) {
                CraftPresence.CONFIG.hasChanged = true;
                this.CONFIG.allowEndpointIcons = this.allowEndpointIconsButton.isChecked();
            }
            if (!this.refreshRate.getControlMessage().equals(Integer.toString(this.CONFIG.refreshRate))) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.refreshRate = StringUtils.getValidInteger(this.refreshRate.getControlMessage()).getSecond();
            }
            if (this.enableCommandsButton.isChecked() != this.CONFIG.enableCommands) {
                CraftPresence.CONFIG.hasChanged = true;
                this.CONFIG.enableCommands = this.enableCommandsButton.isChecked();
            }
            if (this.enablePerGuiButton.isChecked() != this.CONFIG.enablePerGui) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.enablePerGui = this.enablePerGuiButton.isChecked();
            }
            if (this.enablePerItemButton.isChecked() != this.CONFIG.enablePerItem) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.enablePerItem = this.enablePerItemButton.isChecked();
            }
            if (this.enablePerEntityButton.isChecked() != this.CONFIG.enablePerEntity) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.enablePerEntity = this.enablePerEntityButton.isChecked();
            }
            if (this.renderTooltipsButton.isChecked() != this.CONFIG.renderTooltips) {
                CraftPresence.CONFIG.hasChanged = true;
                this.CONFIG.renderTooltips = this.renderTooltipsButton.isChecked();
            }
            if (this.formatWordsButton.isChecked() != this.CONFIG.formatWords) {
                CraftPresence.CONFIG.hasChanged = true;
                this.CONFIG.formatWords = this.formatWordsButton.isChecked();
            }
            if (this.debugModeButton.isChecked() != this.CONFIG.debugMode) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.debugMode = this.debugModeButton.isChecked();
            }
            if (this.verboseModeButton.isChecked() != this.CONFIG.verboseMode) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.CONFIG.verboseMode = this.verboseModeButton.isChecked();
            }
            if (this.allowPlaceholderPreviewsButton.isChecked() != this.CONFIG.allowPlaceholderPreviews) {
                CraftPresence.CONFIG.hasChanged = true;
                this.CONFIG.allowPlaceholderPreviews = this.allowPlaceholderPreviewsButton.isChecked();
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), this, true);
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.advanced", new Object[0]);
        String refreshRateText = ModUtils.TRANSLATOR.translate("gui.config.name.advanced.refresh_rate", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        this.renderString(refreshRateText, (float)this.getScreenWidth() / 2.0f + 18.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        Pair<Boolean, Integer> refreshRateData = StringUtils.getValidInteger(this.refreshRate.getControlMessage());
        this.proceedButton.setControlEnabled(refreshRateData.getFirst() != false && refreshRateData.getSecond() >= 2);
        this.guiMessagesButton.setControlEnabled(CraftPresence.GUIS.enabled);
        this.itemMessagesButton.setControlEnabled(CraftPresence.TILE_ENTITIES.enabled);
        this.entityTargetMessagesButton.setControlEnabled(CraftPresence.ENTITIES.enabled);
        this.entityRidingMessagesButton.setControlEnabled(CraftPresence.ENTITIES.enabled);
    }

    @Override
    public void postRender() {
        String refreshRateText = ModUtils.TRANSLATOR.translate("gui.config.name.advanced.refresh_rate", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f + 18.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(refreshRateText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.advanced.refresh_rate", new Object[0])), this, true);
        }
    }
}

