/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Dimension;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.client.gui.GuiScreen;

public class DimensionSettingsGui
extends ExtendedScreen {
    private final Dimension CONFIG;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl dimensionMessagesButton;
    private ExtendedTextControl defaultMessage;

    DimensionSettingsGui(GuiScreen parentScreen) {
        super(parentScreen);
        this.CONFIG = CraftPresence.CONFIG.dimensionSettings;
    }

    @Override
    public void initializeUi() {
        ModuleData defaultData = this.CONFIG.dimensionData.get("default");
        String defaultDimensionMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = this.addControl(new ExtendedTextControl(this.getFontRenderer(), this.getScreenWidth() / 2 + 3, CraftPresence.GUIS.getButtonY(1), 180, 20));
        this.defaultMessage.setControlMessage(defaultDimensionMessage);
        this.dimensionMessagesButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(2), 180, 20, "gui.config.name.dimension_messages.dimension_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.dimension", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultDimensionData = this.CONFIG.dimensionData.get("default");
            ModuleData currentDimensionData = this.CONFIG.dimensionData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultDimensionData, "textOverride") != null ? defaultDimensionData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentDimensionData, "textOverride") != null ? currentDimensionData.getTextOverride() : "";
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.CONFIG.dimensionData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.dimensionData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.CONFIG.dimensionData.get("default");
            screenInstance.currentData = this.CONFIG.dimensionData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.dimension.edit_specific_dimension", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.dimensionData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.DIMENSIONS.DIMENSION_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.CONFIG.dimensionData.remove(attributeName);
            if (!screenInstance.isPreliminaryData) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                CraftPresence.GUIS.openScreen(new PresenceSettingsGui((GuiScreen)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.CONFIG.fallbackDimensionIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                CraftPresence.GUIS.openScreen(new SelectorGui((GuiScreen)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> {
            if (!this.dimensionMessagesButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))), this, true);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(3), 180, 20, "gui.config.name.dimension_messages.dimension_icon", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), this.CONFIG.fallbackDimensionIcon, null, true, false, ScrollableListControl.RenderType.DiscordAsset, (attributeName, currentValue) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            this.CONFIG.fallbackDimensionIcon = currentValue;
        }, null)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_icon", new Object[0])), this, true), new String[0]));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (!this.defaultMessage.getControlMessage().equals(defaultDimensionMessage)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                ModuleData defaultDimensionData = this.CONFIG.dimensionData.getOrDefault("default", new ModuleData());
                defaultDimensionData.setTextOverride(this.defaultMessage.getControlMessage());
                this.CONFIG.dimensionData.put("default", defaultDimensionData);
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        }, () -> {
            if (!this.proceedButton.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])), this, true);
            }
        }, new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.dimension_messages", new Object[0]);
        String defaultMessageText = ModUtils.TRANSLATOR.translate("gui.config.message.default.dimension", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        this.renderString(defaultMessageText, (float)this.getScreenWidth() / 2.0f - 140.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()));
        this.dimensionMessagesButton.setControlEnabled(CraftPresence.DIMENSIONS.enabled);
    }

    @Override
    public void postRender() {
        String defaultMessageText = ModUtils.TRANSLATOR.translate("gui.config.message.default.dimension", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 140.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(defaultMessageText), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))), this, true);
        }
    }
}

