/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Display;
import forge.com.gitlab.cdagaming.craftpresence.config.element.Button;
import forge.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.CheckBoxControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.PaginatedScreen;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;

public class PresenceSettingsGui
extends PaginatedScreen {
    private final Display CONFIG;
    private final PresenceData PRESENCE;
    private final Button DEFAULT_BUTTON;
    private final boolean isDefaultModule;
    private final Consumer<PresenceData> onChangedCallback;
    private ExtendedTextControl detailsFormat;
    private ExtendedTextControl gameStateFormat;
    private ExtendedTextControl largeImageFormat;
    private ExtendedTextControl smallImageFormat;
    private ExtendedTextControl smallImageKeyFormat;
    private ExtendedTextControl largeImageKeyFormat;
    private ExtendedTextControl startTimeFormat;
    private ExtendedTextControl endTimeFormat;
    private CheckBoxControl useAsMainCheckbox;
    private CheckBoxControl enabledCheckbox;

    PresenceSettingsGui(GuiScreen parentScreen, PresenceData moduleData, Consumer<PresenceData> changedCallback) {
        super(parentScreen);
        this.CONFIG = CraftPresence.CONFIG.displaySettings;
        PresenceData presenceData = this.PRESENCE = moduleData != null ? moduleData : this.CONFIG.presenceData;
        if (this.PRESENCE.buttons.isEmpty()) {
            this.PRESENCE.buttons.put("default", new Button(this.CONFIG.presenceData.buttons.get("default")));
        }
        this.DEFAULT_BUTTON = this.PRESENCE.buttons.get("default");
        this.isDefaultModule = moduleData != null && moduleData.equals(this.CONFIG.presenceData);
        this.onChangedCallback = changedCallback;
    }

    PresenceSettingsGui(GuiScreen parentScreen) {
        this(parentScreen, CraftPresence.CONFIG.displaySettings.presenceData, output -> {
            CraftPresence.CONFIG.displaySettings.presenceData = output;
        });
    }

    @Override
    public void initializeUi() {
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        int checkboxCalc1 = this.getScreenWidth() / 2 - 160;
        this.detailsFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20), this.startPage);
        this.gameStateFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(2), 180, 20), this.startPage);
        this.largeImageFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(3), 180, 20), this.startPage);
        this.smallImageFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(4), 180, 20), this.startPage);
        this.detailsFormat.setControlMessage(this.PRESENCE.details);
        this.gameStateFormat.setControlMessage(this.PRESENCE.gameState);
        this.largeImageFormat.setControlMessage(this.PRESENCE.largeImageText);
        this.smallImageFormat.setControlMessage(this.PRESENCE.smallImageText);
        if (!this.isDefaultModule) {
            this.enabledCheckbox = this.addControl(new CheckBoxControl(checkboxCalc1, CraftPresence.GUIS.getButtonY(5), "gui.config.name.display.enabled", this.PRESENCE.enabled, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.enabled", new Object[0])), this, true)), this.startPage);
            this.useAsMainCheckbox = this.addControl(new CheckBoxControl(calc2, CraftPresence.GUIS.getButtonY(5), "gui.config.name.display.use_as_main", this.PRESENCE.useAsMain, null, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.use_as_main", new Object[0])), this, true)), this.startPage);
        }
        this.smallImageKeyFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20), this.startPage + 1);
        this.largeImageKeyFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(2), 180, 20), this.startPage + 1);
        this.smallImageKeyFormat.setControlMessage(this.PRESENCE.smallImageKey);
        this.largeImageKeyFormat.setControlMessage(this.PRESENCE.largeImageKey);
        this.startTimeFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(3), 180, 20), this.startPage + 1);
        this.endTimeFormat = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(4), 180, 20), this.startPage + 1);
        this.startTimeFormat.setControlMessage(this.PRESENCE.startTimestamp);
        this.endTimeFormat.setControlMessage(this.PRESENCE.endTimestamp);
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(5), 180, 20, "gui.config.name.display.button_messages", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.button", new Object[0]), CraftPresence.CLIENT.createButtonsList(this.PRESENCE.buttons), null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.attributeName = "button_" + CraftPresence.CLIENT.createButtonsList(this.PRESENCE.buttons).size();
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.add.new.prefilled", screenInstance.attributeName);
            screenInstance.primaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            Button defaultData = this.DEFAULT_BUTTON;
            screenInstance.originalPrimaryMessage = Config.getProperty(defaultData, "label") != null ? defaultData.label : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
            screenInstance.originalSecondaryMessage = Config.getProperty(defaultData, "url") != null ? defaultData.url : "";
            screenInstance.secondaryMessage = screenInstance.originalSecondaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.secondaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.overrideSecondaryRender = true;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.display.edit_specific_button", attributeName);
            Button defaultData = this.DEFAULT_BUTTON;
            Button currentData = this.PRESENCE.buttons.get(attributeName);
            screenInstance.isPreliminaryData = currentData == null;
            screenInstance.originalPrimaryMessage = Config.getProperty(defaultData, "label") != null ? defaultData.label : "";
            screenInstance.originalSecondaryMessage = Config.getProperty(defaultData, "url") != null ? defaultData.url : "";
            screenInstance.primaryMessage = Config.getProperty(currentData, "label") != null ? currentData.label : screenInstance.originalPrimaryMessage;
            screenInstance.secondaryMessage = Config.getProperty(currentData, "url") != null ? currentData.url : screenInstance.originalSecondaryMessage;
        }, (screenInstance, secondaryText, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.buttons.put(screenInstance.attributeName, new Button((String)inputText, (String)secondaryText));
        }, (screenInstance, secondaryText, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.PRESENCE.buttons.remove(screenInstance.attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.button_messages", new Object[0])), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true), (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.button_messages", new Object[0])), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.button_messages", new Object[0])), this, true), new String[0]), this.startPage + 1);
        this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(5), 180, 20, "gui.config.name.display.dynamic_icons", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, true, true, ScrollableListControl.RenderType.CustomDiscordAsset, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.primaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.CONFIG.dynamicIcons.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.primaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]);
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.secondaryText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.label", new Object[0]);
            screenInstance.maxSecondaryLength = 32;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.display.edit_specific_icon", attributeName);
            screenInstance.originalPrimaryMessage = this.CONFIG.dynamicIcons.getOrDefault("default", "");
            screenInstance.primaryMessage = this.CONFIG.dynamicIcons.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            CraftPresence.CONFIG.flushClientProperties = true;
            this.CONFIG.dynamicIcons.put((String)attributeName, (String)inputText);
            DiscordAsset asset = new DiscordAsset().setName((String)attributeName).setUrl((String)inputText).setType(DiscordAsset.AssetType.CUSTOM);
            if (!DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.put(asset.getName(), asset);
            }
            if (!asset.getName().equalsIgnoreCase("default")) {
                DiscordAssetUtils.ASSET_LIST.put(asset.getName(), asset);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            CraftPresence.CONFIG.flushClientProperties = true;
            this.CONFIG.dynamicIcons.remove(attributeName);
            if (DiscordAssetUtils.CUSTOM_ASSET_LIST.containsKey(attributeName)) {
                DiscordAssetUtils.CUSTOM_ASSET_LIST.remove(attributeName);
                if (!attributeName.equalsIgnoreCase("default")) {
                    DiscordAssetUtils.ASSET_LIST.remove(attributeName);
                }
            }
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0])), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true), (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0])), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.dynamic_icons", new Object[0])), this, true), new String[0]), this.startPage + 1);
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, CraftPresence.GUIS.getButtonY(6), 180, 20, "gui.config.name.display.dynamic_variables", () -> CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.item", new Object[0]), this.CONFIG.dynamicVariables.keySet(), null, null, true, true, ScrollableListControl.RenderType.None, null, (currentValue, parentScreen) -> CraftPresence.GUIS.openScreen(new DynamicEditorGui((GuiScreen)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage = this.CONFIG.dynamicVariables.getOrDefault("default", "");
        }, (attributeName, screenInstance) -> {
            screenInstance.maxPrimaryLength = Short.MAX_VALUE;
            screenInstance.maxSecondaryLength = 32;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.item.edit_specific_item", attributeName);
            screenInstance.originalPrimaryMessage = this.CONFIG.dynamicVariables.getOrDefault("default", "");
            screenInstance.primaryMessage = this.CONFIG.dynamicVariables.getOrDefault(attributeName, screenInstance.originalPrimaryMessage);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            CraftPresence.CONFIG.flushClientProperties = true;
            this.CONFIG.dynamicVariables.put((String)attributeName, (String)inputText);
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            CraftPresence.CONFIG.flushClientProperties = true;
            this.CONFIG.dynamicVariables.remove(attributeName);
        }, null, (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0])), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true), (attributeName, screenInstance) -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0])), (ExtendedScreen)((Object)((Object)((Object)screenInstance))), true))))), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.display.dynamic_variables", new Object[0])), this, true), new String[0]), this.startPage + 1);
        super.initializeUi();
        this.backButton.setOnClick(() -> {
            if (!this.detailsFormat.getControlMessage().equals(this.PRESENCE.details)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.details = this.detailsFormat.getControlMessage();
            }
            if (!this.gameStateFormat.getControlMessage().equals(this.PRESENCE.gameState)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.gameState = this.gameStateFormat.getControlMessage();
            }
            if (!this.largeImageFormat.getControlMessage().equals(this.PRESENCE.largeImageText)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.largeImageText = this.largeImageFormat.getControlMessage();
            }
            if (!this.smallImageFormat.getControlMessage().equals(this.PRESENCE.smallImageText)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.smallImageText = this.smallImageFormat.getControlMessage();
            }
            if (!this.isDefaultModule) {
                if (this.enabledCheckbox.isChecked() != this.PRESENCE.enabled) {
                    CraftPresence.CONFIG.hasChanged = true;
                    CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                    this.PRESENCE.enabled = this.enabledCheckbox.isChecked();
                }
                if (this.useAsMainCheckbox.isChecked() != this.PRESENCE.useAsMain) {
                    CraftPresence.CONFIG.hasChanged = true;
                    CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                    this.PRESENCE.useAsMain = this.useAsMainCheckbox.isChecked();
                }
            }
            if (!this.largeImageKeyFormat.getControlMessage().equals(this.PRESENCE.largeImageKey)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.largeImageKey = this.largeImageKeyFormat.getControlMessage();
            }
            if (!this.smallImageKeyFormat.getControlMessage().equals(this.PRESENCE.smallImageKey)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.smallImageKey = this.smallImageKeyFormat.getControlMessage();
            }
            if (!this.startTimeFormat.getControlMessage().equals(this.PRESENCE.startTimestamp)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.startTimestamp = this.startTimeFormat.getControlMessage();
            }
            if (!this.endTimeFormat.getControlMessage().equals(this.PRESENCE.endTimestamp)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                this.PRESENCE.endTimestamp = this.endTimeFormat.getControlMessage();
            }
            if (this.onChangedCallback != null) {
                this.onChangedCallback.accept(this.PRESENCE);
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        });
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.presence_settings", new Object[0]);
        String detailsFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.details_message", new Object[0]);
        String gameStateFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.game_state_message", new Object[0]);
        String largeImageFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.large_image_message", new Object[0]);
        String smallImageFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.small_image_message", new Object[0]);
        String smallImageKeyFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.small_image_key", new Object[0]);
        String largeImageKeyFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.large_image_key", new Object[0]);
        String startTimeFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.start_timestamp", new Object[0]);
        String endTimeFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.end_timestamp", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(subTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0f, 0xFFFFFF);
        this.renderString(detailsFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF, this.startPage);
        this.renderString(gameStateFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(2, 5), 0xFFFFFF, this.startPage);
        this.renderString(largeImageFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(3, 5), 0xFFFFFF, this.startPage);
        this.renderString(smallImageFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(4, 5), 0xFFFFFF, this.startPage);
        this.renderString(smallImageKeyFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF, this.startPage + 1);
        this.renderString(largeImageKeyFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(2, 5), 0xFFFFFF, this.startPage + 1);
        this.renderString(startTimeFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(3, 5), 0xFFFFFF, this.startPage + 1);
        this.renderString(endTimeFormatTitle, (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(4, 5), 0xFFFFFF, this.startPage + 1);
        super.preRender();
    }

    @Override
    public void postRender() {
        String detailsFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.details_message", new Object[0]);
        String gameStateFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.game_state_message", new Object[0]);
        String largeImageFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.large_image_message", new Object[0]);
        String smallImageFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.small_image_message", new Object[0]);
        String smallImageKeyFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.small_image_key", new Object[0]);
        String largeImageKeyFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.large_image_key", new Object[0]);
        String startTimeFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.start_timestamp", new Object[0]);
        String endTimeFormatTitle = ModUtils.TRANSLATOR.translate("gui.config.name.display.end_timestamp", new Object[0]);
        if (this.currentPage == this.startPage) {
            boolean hoveringOverDetails = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(detailsFormatTitle), this.getFontHeight());
            boolean hoveringOverGameState = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(2, 5), this.getStringWidth(gameStateFormatTitle), this.getFontHeight());
            boolean hoveringOverLargeImageFormat = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(3, 5), this.getStringWidth(largeImageFormatTitle), this.getFontHeight());
            boolean hoveringOverSmallImageFormat = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(4, 5), this.getStringWidth(smallImageFormatTitle), this.getFontHeight());
            if (this.isDefaultModule && (hoveringOverDetails || hoveringOverGameState || hoveringOverLargeImageFormat || hoveringOverSmallImageFormat)) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.presence.generalArgs", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))), this, true);
            }
        }
        if (this.currentPage == this.startPage + 1) {
            boolean hoveringOverSmallImageFormat = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(1, 5), this.getStringWidth(smallImageKeyFormatTitle), this.getFontHeight());
            boolean hoveringOverLargeImageFormat = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(2, 5), this.getStringWidth(largeImageKeyFormatTitle), this.getFontHeight());
            boolean hoveringOverStartTimeFormat = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(3, 5), this.getStringWidth(startTimeFormatTitle), this.getFontHeight());
            boolean hoveringOverEndTimeFormat = CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - 160.0f, CraftPresence.GUIS.getButtonY(4, 5), this.getStringWidth(endTimeFormatTitle), this.getFontHeight());
            if (this.isDefaultModule) {
                if (hoveringOverSmallImageFormat || hoveringOverLargeImageFormat) {
                    CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.presence.iconArgs", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))), this, true);
                } else if (hoveringOverStartTimeFormat || hoveringOverEndTimeFormat) {
                    CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.presence.generalArgs", CraftPresence.CLIENT.generateArgumentMessage("general.", "custom."))), this, true);
                }
            }
        }
    }
}

