/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

public class TranslationUtils
implements IResourceManagerReloadListener {
    public final String defaultLanguageId = ModUtils.MCProtocolID >= 315 ? "en_us" : "en_US";
    private final Map<String, Map<String, String>> requestMap = Maps.newHashMap();
    private String languageId = this.defaultLanguageId;
    private String modId;
    private String encoding;
    private boolean usingJson = false;
    private boolean needsSync;
    private boolean needsInit;

    public TranslationUtils() {
        this(false);
    }

    public TranslationUtils(boolean useJson) {
        this("", useJson);
    }

    public TranslationUtils(String modId) {
        this(modId, false);
    }

    public TranslationUtils(String modId, boolean useJson) {
        this(modId, useJson, "UTF-8");
    }

    public TranslationUtils(String modId, boolean useJson, String encoding) {
        this.setUsingJson(useJson);
        this.setModId(modId);
        this.setEncoding(encoding);
        this.syncTranslations(this.getDefaultLanguage());
        this.needsSync = true;
        this.needsInit = true;
    }

    public static String convertId(String originalId, ConversionMode mode) {
        String resultId = originalId;
        if (originalId.length() == 5 && originalId.contains("_")) {
            if (mode == ConversionMode.PackFormat2 || mode == ConversionMode.None && ModUtils.MCProtocolID < 315) {
                resultId = resultId.substring(0, 3).toLowerCase() + resultId.substring(3).toUpperCase();
            } else if (mode == ConversionMode.PackFormat3 || mode == ConversionMode.None) {
                resultId = resultId.toLowerCase();
            }
        }
        if (resultId.equals(originalId) && mode != ConversionMode.None) {
            ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", resultId, mode.name()), new Object[0]);
        }
        return resultId.trim();
    }

    void onTick() {
        boolean hasLanguageChanged;
        String currentLanguageId = this.getCurrentLanguage();
        boolean bl = hasLanguageChanged = !this.languageId.equals(currentLanguageId) && (!this.hasTranslationsFrom(currentLanguageId) || !this.requestMap.get(currentLanguageId).isEmpty());
        if (CraftPresence.SYSTEM.HAS_GAME_LOADED) {
            if (this.needsInit || this.needsSync) {
                if (this.needsInit && CraftPresence.instance.func_110442_L() != null) {
                    ((SimpleReloadableResourceManager)CraftPresence.instance.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
                }
                ArrayList requestedKeys = Lists.newArrayList(this.requestMap.keySet());
                for (String key : requestedKeys) {
                    this.syncTranslations(key, false);
                }
                this.needsSync = false;
                this.needsInit = false;
            } else if (hasLanguageChanged) {
                this.syncTranslations(currentLanguageId);
            }
        }
    }

    public void syncTranslations(String languageId, boolean setLanguage) {
        if (setLanguage) {
            this.setLanguage(languageId);
        }
        this.getTranslationMapFrom(languageId, this.encoding);
    }

    public void syncTranslations(String languageId) {
        this.syncTranslations(languageId, true);
    }

    public void syncTranslations() {
        this.needsSync = true;
    }

    private String getCurrentLanguage() {
        String result = CraftPresence.instance.field_71474_y != null ? CraftPresence.instance.field_71474_y.field_74363_ab : (CraftPresence.CONFIG != null ? CraftPresence.CONFIG.accessibilitySettings.languageId : this.defaultLanguageId);
        return this.usingJson ? result.toLowerCase() : result;
    }

    public String getDefaultLanguage() {
        return this.usingJson ? this.defaultLanguageId.toLowerCase() : this.defaultLanguageId;
    }

    private void setUsingJson(boolean usingJson) {
        this.usingJson = usingJson;
    }

    private void setLanguage(String languageId) {
        String result = StringUtils.getOrDefault(languageId, this.defaultLanguageId);
        this.languageId = this.usingJson ? result.toLowerCase() : result;
    }

    private void setEncoding(String encoding) {
        this.encoding = StringUtils.getOrDefault(encoding, "UTF-8");
    }

    private void setModId(String modId) {
        this.modId = StringUtils.getOrDefault(modId);
    }

    private List<InputStream> getLocaleStreamsFrom(String languageId, IResourceManager resourceManager, String ext) {
        String assetsPath = String.format("/assets/%s/", this.modId);
        String langPath = String.format("lang/%s.%s", languageId, ext);
        ArrayList results = Lists.newArrayList((Object[])new InputStream[]{FileUtils.getResourceAsStream(TranslationUtils.class, assetsPath + langPath)});
        try {
            List resources = resourceManager.func_135056_b(new ResourceLocation(this.modId, langPath));
            for (IResource resource : resources) {
                results.add(resource.func_110527_b());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    private List<InputStream> getLocaleStreamsFrom(String languageId, IResourceManager resourceManager) {
        return this.getLocaleStreamsFrom(languageId, resourceManager, this.usingJson ? "json" : "lang");
    }

    private List<InputStream> getLocaleStreams(IResourceManager resourceManager, String ext) {
        return this.getLocaleStreamsFrom(this.languageId, resourceManager, ext);
    }

    private List<InputStream> getLocaleStreams(IResourceManager resourceManager) {
        return this.getLocaleStreamsFrom(this.languageId, resourceManager);
    }

    private Map<String, String> getTranslationMapFrom(String languageId, String encoding, List<InputStream> data) {
        boolean hasError = false;
        boolean hadBefore = this.hasTranslationsFrom(languageId);
        this.requestMap.remove(languageId);
        HashMap translationMap = Maps.newHashMap();
        if (data != null && !data.isEmpty()) {
            for (InputStream in : data) {
                if (in != null) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName(encoding)));
                        try {
                            String currentString;
                            while ((currentString = reader.readLine()) != null) {
                                String[] splitTranslation;
                                if ((currentString = currentString.trim()).startsWith("#") || currentString.startsWith("[{}]") || !(this.usingJson ? currentString.contains(":") : currentString.contains("="))) continue;
                                String[] stringArray = splitTranslation = this.usingJson ? currentString.split(":", 2) : currentString.split("=", 2);
                                if (this.usingJson) {
                                    String str1 = splitTranslation[0].substring(1, splitTranslation[0].length() - 1).trim();
                                    String str2 = splitTranslation[1].substring(2, splitTranslation[1].length() - (splitTranslation[1].endsWith(",") ? 2 : 1)).trim();
                                    translationMap.put(str1.replaceAll("(?s)\\\\(.)", "$1"), str2.replaceAll("(?s)\\\\(.)", "$1"));
                                    continue;
                                }
                                translationMap.put(splitTranslation[0].trim(), splitTranslation[1].trim());
                            }
                            in.close();
                            continue;
                        }
                        finally {
                            reader.close();
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        ModUtils.LOG.error("An exception has occurred while loading Translation Mappings, aborting scan to prevent issues...", new Object[0]);
                        if (CommandUtils.isVerboseMode()) {
                            ex.printStackTrace();
                        }
                        hasError = true;
                    }
                } else {
                    hasError = true;
                }
                break;
            }
        } else {
            hasError = true;
        }
        if (hasError) {
            ModUtils.LOG.error("Translations for " + this.modId + " do not exist for " + languageId, new Object[0]);
            translationMap.clear();
            this.requestMap.put(languageId, translationMap);
            this.setLanguage(this.defaultLanguageId);
        } else {
            ModUtils.LOG.debugInfo((hadBefore ? "Refreshed" : "Added") + " translations for " + this.modId + " for " + languageId, new Object[0]);
            this.requestMap.put(languageId, translationMap);
        }
        return translationMap;
    }

    private Map<String, String> getTranslationMapFrom(String languageId, String encoding) {
        return this.getTranslationMapFrom(languageId, encoding, this.getLocaleStreamsFrom(languageId, CraftPresence.instance.func_110442_L()));
    }

    private Map<String, String> getTranslationMapFrom(String languageId) {
        return this.getTranslationMapFrom(languageId, "UTF-8");
    }

    private Map<String, String> getTranslationMap() {
        return this.getTranslationMapFrom(this.languageId);
    }

    public String translateFrom(String languageId, boolean stripColors, String translationKey, Object ... parameters) {
        boolean hasError = false;
        String translatedString = translationKey;
        try {
            if (this.hasTranslationFrom(languageId, translationKey)) {
                String rawString = this.getTranslationFrom(languageId, translationKey);
                translatedString = parameters.length > 0 ? String.format(rawString, parameters) : rawString;
            } else {
                hasError = true;
            }
        }
        catch (Exception ex) {
            ModUtils.LOG.error("Exception parsing " + translationKey + " from " + languageId, new Object[0]);
            if (CommandUtils.isVerboseMode()) {
                ex.printStackTrace();
            }
            hasError = true;
        }
        if (hasError) {
            boolean showErrors;
            boolean bl = showErrors = CraftPresence.SYSTEM.HAS_GAME_LOADED || languageId.equals(this.getDefaultLanguage());
            if (showErrors) {
                ModUtils.LOG.error("Unable to retrieve a translation for " + translationKey + " from " + languageId, new Object[0]);
            }
            if (!languageId.equals(this.getDefaultLanguage())) {
                if (showErrors) {
                    ModUtils.LOG.error("Attempting to retrieve default translation for " + translationKey, new Object[0]);
                }
                return this.translateFrom(this.getDefaultLanguage(), stripColors, translationKey, parameters);
            }
        }
        return stripColors ? StringUtils.stripColors(translatedString) : translatedString;
    }

    public String translateFrom(boolean stripColors, String translationKey, Object ... parameters) {
        return this.translateFrom(this.getDefaultLanguage(), stripColors, translationKey, parameters);
    }

    public String translate(boolean stripColors, String translationKey, Object ... parameters) {
        return this.translateFrom(this.languageId, stripColors, translationKey, parameters);
    }

    public String translateFrom(String languageId, String translationKey, Object ... parameters) {
        return this.translateFrom(languageId, CraftPresence.CONFIG != null && CraftPresence.CONFIG.accessibilitySettings.stripTranslationColors, translationKey, parameters);
    }

    public String translateFrom(String translationKey, Object ... parameters) {
        return this.translateFrom(this.getDefaultLanguage(), translationKey, parameters);
    }

    public String translate(String translationKey, Object ... parameters) {
        return this.translateFrom(this.languageId, translationKey, parameters);
    }

    public boolean hasTranslationsFrom(String languageId) {
        return this.requestMap.containsKey(languageId);
    }

    public boolean hasTranslationFrom(String languageId, String translationKey) {
        if (this.hasTranslationsFrom(languageId)) {
            return this.requestMap.get(languageId).containsKey(translationKey);
        }
        return this.getTranslationMapFrom(languageId).containsKey(translationKey);
    }

    public boolean hasTranslation(String translationKey) {
        return this.hasTranslationFrom(this.languageId, translationKey);
    }

    public String getTranslationFrom(String languageId, String translationKey) {
        if (this.hasTranslationFrom(languageId, translationKey)) {
            return this.requestMap.get(languageId).get(translationKey);
        }
        return null;
    }

    public String getTranslation(String translationKey) {
        return this.getTranslationFrom(this.languageId, translationKey);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.syncTranslations();
    }

    public static enum ConversionMode {
        PackFormat2,
        PackFormat3,
        None,
        Unknown;

    }
}

