/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets;

import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.SystemUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import java.util.Map;

public class DiscordAssetUtils {
    public static final Map<String, DiscordAsset> ASSET_LIST = Maps.newHashMap();
    public static final Map<String, DiscordAsset> CUSTOM_ASSET_LIST = Maps.newHashMap();
    private static final String applicationEndpoint = "https://discord.com/api/oauth2/applications/";
    private static final String assetsEndpoint = "https://cdn.discordapp.com/app-assets/";

    public static boolean isValidId(String clientId) {
        return !StringUtils.isNullOrEmpty(clientId) && clientId.length() >= 18 && StringUtils.getValidLong(clientId).getFirst() != false;
    }

    public static boolean contains(Map<String, DiscordAsset> list, String key) {
        return !StringUtils.isNullOrEmpty(key) && list.containsKey(key);
    }

    public static boolean contains(String key) {
        return DiscordAssetUtils.contains(ASSET_LIST, key);
    }

    public static boolean isCustom(String key) {
        return DiscordAssetUtils.contains(CUSTOM_ASSET_LIST, key);
    }

    public static DiscordAsset get(Map<String, DiscordAsset> list, String key) {
        String formattedKey = key;
        if (!StringUtils.isNullOrEmpty(formattedKey)) {
            if (!list.equals(CUSTOM_ASSET_LIST) && !DiscordAssetUtils.isCustom(formattedKey)) {
                formattedKey = StringUtils.formatAsIcon(formattedKey, "_");
            }
            if (DiscordAssetUtils.contains(list, formattedKey)) {
                return list.get(formattedKey);
            }
        }
        return null;
    }

    public static DiscordAsset get(String key) {
        return DiscordAssetUtils.get(ASSET_LIST, key);
    }

    public static String getKey(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getName() : "";
    }

    public static String getKey(String key) {
        return DiscordAssetUtils.getKey(ASSET_LIST, key);
    }

    public static String getId(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getId() : "";
    }

    public static String getId(String key) {
        return DiscordAssetUtils.getId(ASSET_LIST, key);
    }

    public static DiscordAsset.AssetType getType(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getType() : DiscordAsset.AssetType.LARGE;
    }

    public static DiscordAsset.AssetType getType(String key) {
        return DiscordAssetUtils.getType(ASSET_LIST, key);
    }

    public static String getUrl(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        if (asset != null) {
            if (!StringUtils.isNullOrEmpty(asset.getId())) {
                return DiscordAssetUtils.getDiscordAssetUrl(asset.getName());
            }
            return CraftPresence.CLIENT.getResult(asset.getUrl());
        }
        return "";
    }

    public static String getUrl(String key) {
        return DiscordAssetUtils.getUrl(ASSET_LIST, key);
    }

    public static void emptyData() {
        ASSET_LIST.clear();
        CUSTOM_ASSET_LIST.clear();
    }

    public static DiscordAsset getRandomAsset() {
        try {
            DiscordAsset[] values = ASSET_LIST.values().toArray(new DiscordAsset[0]);
            return values[SystemUtils.RANDOM.nextInt(values.length)];
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.invalid.icon.empty", new Object[0]), new Object[0]);
            if (CommandUtils.isVerboseMode()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static String getRandomAssetName() {
        DiscordAsset randAsset = DiscordAssetUtils.getRandomAsset();
        return randAsset != null ? randAsset.getName() : "";
    }

    public static String getDiscordAssetUrl(String clientId, String keyId, boolean isLocalName) {
        return !StringUtils.isNullOrEmpty(keyId) ? assetsEndpoint + clientId + "/" + (isLocalName ? DiscordAssetUtils.getId(keyId) : keyId) + ".png" : "";
    }

    public static String getDiscordAssetUrl(String clientId, String keyId) {
        return DiscordAssetUtils.getDiscordAssetUrl(clientId, keyId, clientId.equals(CraftPresence.CONFIG.generalSettings.clientId));
    }

    public static String getDiscordAssetUrl(String keyId) {
        return DiscordAssetUtils.getDiscordAssetUrl(CraftPresence.CONFIG.generalSettings.clientId, keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscordAsset[] loadAssets(String clientId, boolean filterToMain) {
        DiscordAsset[] discordAssetArray;
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load", clientId), new Object[0]);
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load.credits", new Object[0]), new Object[0]);
        try {
            String url = applicationEndpoint + clientId + "/assets";
            DiscordAsset[] assets = UrlUtils.getJSONFromURL(url, DiscordAsset[].class);
            if (filterToMain) {
                ASSET_LIST.clear();
                if (assets != null) {
                    for (DiscordAsset asset : assets) {
                        if (!StringUtils.isNullOrEmpty(asset.getUrl()) && asset.getType() != DiscordAsset.AssetType.CUSTOM) {
                            asset.setUrl(DiscordAssetUtils.getDiscordAssetUrl(clientId, asset.getId(), false));
                        }
                        if (ASSET_LIST.containsKey(asset.getName())) continue;
                        ASSET_LIST.put(asset.getName(), asset);
                    }
                }
                DiscordAssetUtils.syncCustomAssets();
            }
            discordAssetArray = assets;
        }
        catch (Exception ex) {
            DiscordAsset[] discordAssetArray2;
            try {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.load", new Object[0]), new Object[0]);
                if (CommandUtils.isVerboseMode()) {
                    ex.printStackTrace();
                }
                discordAssetArray2 = null;
            }
            catch (Throwable throwable) {
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
                throw throwable;
            }
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
            return discordAssetArray2;
        }
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
        return discordAssetArray;
    }

    public static void syncCustomAssets() {
        CUSTOM_ASSET_LIST.clear();
        for (Map.Entry<String, String> iconData : CraftPresence.CONFIG.displaySettings.dynamicIcons.entrySet()) {
            if (StringUtils.isNullOrEmpty(iconData.getKey()) || StringUtils.isNullOrEmpty(iconData.getValue())) continue;
            DiscordAsset asset = new DiscordAsset().setName(iconData.getKey()).setUrl(iconData.getValue()).setType(DiscordAsset.AssetType.CUSTOM);
            if (!CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                CUSTOM_ASSET_LIST.put(asset.getName(), asset);
            }
            if (asset.getName().equalsIgnoreCase("default")) continue;
            ASSET_LIST.put(asset.getName(), asset);
        }
    }
}

