/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import external.org.meteordev.starscript.value.Value;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public class ScrollableListControl
extends GuiSlot {
    public final Map<String, String> entryAliases = Maps.newHashMap();
    public String currentValue;
    public List<String> currentHoverText = Lists.newArrayList();
    public List<String> itemList;
    public RenderType renderType;
    public ExtendedScreen currentScreen;

    public ScrollableListControl(Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.setList(itemList);
        this.currentScreen = currentScreen;
        this.currentValue = currentValue;
        this.renderType = renderType;
        if (renderType == RenderType.ItemData) {
            CraftPresence.TILE_ENTITIES.getAllData();
        }
    }

    public ScrollableListControl(Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue, RenderType renderType) {
        this(mc, currentScreen, width, height, topIn, bottomIn, renderType.canRenderImage() ? 45 : 18, itemList, currentValue, renderType);
    }

    public boolean isWithinBounds(int mouseX, int mouseY) {
        return CraftPresence.GUIS.isMouseWithin(mouseX, mouseY, this.field_148153_b, this.field_148154_c, this.field_148152_e, this.field_148151_d);
    }

    protected int func_148127_b() {
        return this.itemList.size();
    }

    public void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        this.currentValue = this.getSelectedItem(slotIndex);
    }

    public boolean func_148131_a(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void func_148123_a() {
    }

    protected void func_148126_a(int slotIndex, int xPos, int yPos, int heightIn, Tessellator tessellatorIn, int mouseXIn, int mouseYIn) {
        this.renderSlotItem(this.getSelectedItem(slotIndex), xPos, yPos, this.func_148139_c(), heightIn, mouseXIn, mouseYIn);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public FontRenderer getFontRenderer() {
        return GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_78288_b;
    }

    public void setList(List<String> itemList) {
        if (itemList == null) {
            itemList = Lists.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.func_148145_f(Integer.MIN_VALUE);
        }
        this.setupAliasData();
    }

    public void setupAliasData() {
        this.entryAliases.clear();
        Iterator iterator = Lists.newArrayList(this.itemList).iterator();
        while (iterator.hasNext()) {
            String originalName;
            String displayName = originalName = (String)iterator.next();
            if (this.renderType == RenderType.EntityData && StringUtils.isValidUuid(originalName)) {
                String fullUuid = StringUtils.getFromUuid(originalName, false);
                String trimmedUuid = StringUtils.getFromUuid(originalName, true);
                displayName = CraftPresence.ENTITIES.PLAYER_BINDINGS.getOrDefault(fullUuid, trimmedUuid);
            }
            if (originalName.equals(displayName)) continue;
            this.entryAliases.put(originalName, displayName);
        }
    }

    public void renderSlotItem(String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn) {
        String identifierName;
        ArrayList hoverText = Lists.newArrayList();
        String displayName = this.entryAliases.getOrDefault(originalName, originalName);
        int xOffset = xPos;
        ResourceLocation texture = new ResourceLocation("");
        if (this.renderType == RenderType.ServerData) {
            ServerData data = CraftPresence.SERVER.getDataFromName(originalName);
            if (data != null) {
                String assetUrl = "data:image/unknown;base64," + data.func_147409_e();
                texture = ImageUtils.getTextureFromUrl(originalName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
            } else if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint)) {
                String formattedIP = originalName.contains(":") ? StringUtils.formatAddress(originalName, false) : originalName;
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, originalName), new Pair<String, Supplier<String>>("server.address.short", () -> formattedIP), new Pair<String, Supplier<String>>("server.address.full", () -> originalName)).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode()) {
                    hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
            String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, originalName);
            if (this.currentScreen.isDebugMode()) {
                hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + assetUrl);
            }
            texture = ImageUtils.getTextureFromUrl(originalName, assetUrl);
        } else if (this.renderType == RenderType.EntityData) {
            boolean isPlayer = CraftPresence.ENTITIES.PLAYER_BINDINGS.containsKey(originalName);
            boolean isValidUuid = StringUtils.isValidUuid(originalName);
            if (isPlayer && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair<String, Supplier<String>>("player.name", () -> originalName), new Pair<String, Supplier<String>>("player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid(originalName, false) : ""), new Pair<String, Supplier<String>>("player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid(originalName, true) : "")).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode()) {
                    hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.ItemData) {
            texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(originalName, texture);
        } else if (this.renderType == RenderType.Placeholder) {
            Supplier<Value> suppliedInfo;
            String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", originalName);
            String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", originalName);
            if (ModUtils.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                hoverText.add(String.format("%s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.description", new Object[0]), ModUtils.TRANSLATOR.translate(placeholderTranslation, new Object[0])));
            }
            if (ModUtils.TRANSLATOR.hasTranslation(placeholderUsage)) {
                hoverText.add(String.format("%s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), ModUtils.TRANSLATOR.translate(placeholderUsage, new Object[0])));
            }
            if (CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews && (suppliedInfo = CraftPresence.CLIENT.getArgument(originalName)) != null) {
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (!(rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue))) {
                    hoverText.add(String.format("%s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                }
            }
        }
        if (this.renderType.canRenderImage() && !ImageUtils.isTextureNull(texture)) {
            CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0, 32.0, 0.0, texture);
            if (this.currentScreen.isDebugMode()) {
                hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]) + " " + texture);
            }
            xOffset += 35;
        }
        if (!(identifierName = this.renderType.getIdentifier(originalName)).equals(displayName)) {
            hoverText.add(ModUtils.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]) + " " + identifierName);
        }
        this.getFontRenderer().func_78261_a(displayName, xOffset, yPos + (heightIn / 2 - this.getFontHeight() / 2), 0xFFFFFF);
        boolean isOverEntry = CraftPresence.GUIS.isMouseOver(mouseXIn, mouseYIn, xPos, yPos, widthIn, heightIn);
        if (this.isWithinBounds(mouseXIn, mouseYIn) && isOverEntry) {
            this.currentHoverText = hoverText;
        }
    }

    @SuppressFBWarnings(value={"ME_ENUM_FIELD_SETTER"})
    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        Placeholder,
        None;

        private IdentifierType identifierType = IdentifierType.None;
        private boolean canRenderImage;

        private RenderType() {
            this.canRenderImage = !CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements;
        }

        public boolean canRenderImage() {
            return this != None && this.canRenderImage;
        }

        public RenderType setCanRenderImage(boolean canRenderImage) {
            this.canRenderImage = canRenderImage;
            return this;
        }

        public RenderType setIdentifierType(IdentifierType type) {
            this.identifierType = type;
            return this;
        }

        public String getIdentifier(String originalName) {
            String identifierName;
            switch (this.identifierType) {
                case Gui: {
                    Class<?> target = CraftPresence.GUIS.GUI_CLASSES.get(originalName);
                    identifierName = target != null ? MappingUtils.getCanonicalName(target) : originalName;
                    break;
                }
                default: {
                    identifierName = originalName;
                }
            }
            return identifierName;
        }

        public static enum IdentifierType {
            Gui,
            None;

        }
    }
}

