/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.google.common.collect.Lists;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.MessageGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiScreen;

public class SelectorGui
extends ExtendedScreen {
    private final String mainTitle;
    private final String attributeName;
    private final String originalValue;
    private final List<String> originalList;
    private final boolean allowContinuing;
    private final boolean allowDynamicEditing;
    private final BiConsumer<String, String> onUpdatedCallback;
    private final ScrollableListControl.RenderType renderType;
    private final BiConsumer<String, GuiScreen> onAdjustDynamicEntry;
    private ExtendedButtonControl proceedButton;
    private ScrollableListControl scrollList;
    private ExtendedTextControl searchBox;
    private String searchTerm;
    private List<String> itemList;

    public SelectorGui(GuiScreen parentScreen, String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, String> onUpdatedCallback, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        super(parentScreen);
        this.itemList = this.originalList = Lists.newArrayList(list);
        this.originalValue = currentValue;
        this.mainTitle = mainTitle;
        this.attributeName = attributeName;
        this.allowContinuing = allowContinuing;
        this.allowDynamicEditing = allowDynamicEditing;
        this.renderType = renderType;
        this.onUpdatedCallback = onUpdatedCallback;
        this.onAdjustDynamicEntry = onAdjustDynamicEntry;
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, String> onUpdatedCallback, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, Lists.newArrayList(list), currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, onUpdatedCallback, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, null, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, ScrollableListControl.RenderType renderType, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, renderType, null, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, List<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, ScrollableListControl.RenderType.None, onAdjustDynamicEntry);
    }

    public SelectorGui(GuiScreen parentScreen, String mainTitle, Set<String> list, String currentValue, String attributeName, boolean allowContinuing, boolean allowDynamicEditing, BiConsumer<String, GuiScreen> onAdjustDynamicEntry) {
        this(parentScreen, mainTitle, list, currentValue, attributeName, allowContinuing, allowDynamicEditing, ScrollableListControl.RenderType.None, onAdjustDynamicEntry);
    }

    @Override
    public void initializeUi() {
        if (this.itemList != null && !this.itemList.isEmpty()) {
            this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 100, this.getScreenHeight() - 30, 90, 20, "gui.config.message.button.back", () -> {
                if (this.allowContinuing && this.scrollList.currentValue != null) {
                    if (this.originalValue != null) {
                        if (!this.scrollList.currentValue.equals(this.originalValue)) {
                            if (this.onUpdatedCallback != null) {
                                this.onUpdatedCallback.accept(this.attributeName, this.scrollList.currentValue);
                                CraftPresence.GUIS.openScreen(this.parentScreen);
                            } else {
                                CraftPresence.GUIS.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.null", new Object[0]))));
                            }
                        } else {
                            CraftPresence.GUIS.openScreen(this.parentScreen);
                        }
                    } else if (this.allowDynamicEditing && this.onAdjustDynamicEntry != null) {
                        this.onAdjustDynamicEntry.accept(this.scrollList.currentValue, this.parentScreen);
                    } else {
                        CraftPresence.GUIS.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.null", new Object[0]))));
                    }
                } else {
                    CraftPresence.GUIS.openScreen(this.parentScreen);
                }
            }, new String[0]));
            this.scrollList = this.addList(new ScrollableListControl(this.field_146297_k, (ExtendedScreen)this, this.getScreenWidth(), this.getScreenHeight(), 32, this.getScreenHeight() - 45, this.itemList, this.originalValue, this.renderType));
            this.searchBox = this.addControl(new ExtendedTextControl(this.getFontRenderer(), 60, this.getScreenHeight() - 30, 120, 20));
            if (this.allowDynamicEditing && this.onAdjustDynamicEntry != null) {
                this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 195, this.getScreenHeight() - 30, 90, 20, "gui.config.message.button.add.new", () -> this.onAdjustDynamicEntry.accept(null, this.parentScreen), new String[0]));
            }
            super.initializeUi();
        } else {
            CraftPresence.GUIS.openScreen(new MessageGui(this.parentScreen, StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.empty.list", new Object[0]))));
        }
    }

    @Override
    public void preRender() {
        ArrayList originalItems = Lists.newArrayList(this.originalList);
        ArrayList modifiedList = Lists.newArrayList();
        if (!this.searchBox.getControlMessage().isEmpty()) {
            if (!this.searchBox.getControlMessage().equals(this.searchTerm)) {
                this.searchTerm = this.searchBox.getControlMessage();
                block0: for (String item : originalItems) {
                    if (modifiedList.contains(item)) continue;
                    ArrayList entriesToCheck = Lists.newArrayList((Object[])new String[]{item});
                    if (this.scrollList.entryAliases.containsKey(item)) {
                        entriesToCheck.add(this.scrollList.entryAliases.get(item));
                    }
                    for (String entry : entriesToCheck) {
                        if (!entry.toLowerCase().contains(this.searchTerm.toLowerCase())) continue;
                        modifiedList.add(item);
                        continue block0;
                    }
                }
                this.itemList = modifiedList;
            }
        } else {
            this.itemList = originalItems;
        }
        if (!this.itemList.equals(originalItems) && !this.itemList.contains(this.scrollList.currentValue)) {
            this.scrollList.currentValue = this.originalValue != null && this.itemList.contains(this.originalValue) ? this.originalValue : null;
        } else if (this.scrollList.currentValue == null && this.originalValue != null) {
            this.scrollList.currentValue = this.originalValue;
        }
        this.scrollList.setList(this.itemList);
        this.scrollList.currentHoverText.clear();
        this.proceedButton.setControlMessage(this.allowContinuing && this.scrollList.currentValue != null && (this.originalValue != null && !this.scrollList.currentValue.equals(this.originalValue) || StringUtils.isNullOrEmpty(this.originalValue)) ? "gui.config.message.button.continue" : "gui.config.message.button.back");
    }

    @Override
    public void postRender() {
        String searchText = ModUtils.TRANSLATOR.translate("gui.config.message.editor.search", new Object[0]);
        String extraText = this.isVerboseMode() ? ModUtils.TRANSLATOR.translate("gui.config.title.selector.extra", this.itemList.size(), this.originalList.size()) : "";
        String displayText = this.mainTitle + " " + extraText;
        this.renderString(searchText, 30.0f - (float)this.getStringWidth(searchText) / 2.0f, this.getScreenHeight() - 25, 0xFFFFFF);
        this.renderString(displayText, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(displayText) / 2.0f, 15.0f, 0xFFFFFF);
        if (this.scrollList.currentHoverText != null && !this.scrollList.currentHoverText.isEmpty()) {
            CraftPresence.GUIS.drawMultiLineString(this.scrollList.currentHoverText, this, true);
        }
    }
}

