/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.world;

import com.google.common.collect.Lists;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.impl.Module;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.WorldProvider;

public class DimensionUtils
implements Module {
    private final List<WorldProvider> DIMENSION_TYPES = Lists.newArrayList();
    public boolean isInUse = false;
    public boolean enabled = false;
    public boolean hasScanned = false;
    public List<String> DIMENSION_NAMES = Lists.newArrayList();
    private String CURRENT_DIMENSION_NAME;
    private String CURRENT_DIMENSION_IDENTIFIER;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DIMENSION_NAMES.clear();
        this.DIMENSION_TYPES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_DIMENSION_NAME = null;
        this.CURRENT_DIMENSION_IDENTIFIER = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("dimension");
        CraftPresence.CLIENT.clearOverride("dimension.message", "dimension.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectDimensionData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned;
        if (needsUpdate) {
            new Thread(this::getAllData, "CraftPresence-Dimension-Lookup").start();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        WorldProvider newProvider = CraftPresence.player.field_70170_p.field_73011_w;
        String newDimensionName = StringUtils.formatIdentifier(newProvider.func_80007_l(), false, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newDimension_primaryIdentifier = StringUtils.formatIdentifier(newProvider.func_80007_l(), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newDimension_alternativeIdentifier = StringUtils.formatIdentifier(MappingUtils.getClassName(newProvider), true, !CraftPresence.CONFIG.advancedSettings.formatWords);
        String newDimension_Identifier = StringUtils.getOrDefault(newDimension_primaryIdentifier, newDimension_alternativeIdentifier);
        if (!newDimensionName.equals(this.CURRENT_DIMENSION_NAME) || !newDimension_Identifier.equals(this.CURRENT_DIMENSION_IDENTIFIER)) {
            this.CURRENT_DIMENSION_NAME = StringUtils.getOrDefault(newDimensionName, newDimension_Identifier);
            this.CURRENT_DIMENSION_IDENTIFIER = newDimension_Identifier;
            if (!this.DIMENSION_NAMES.contains(newDimension_Identifier)) {
                this.DIMENSION_NAMES.add(newDimension_Identifier);
            }
            if (!this.DIMENSION_TYPES.contains(newProvider)) {
                this.DIMENSION_TYPES.add(newProvider);
            }
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.dimensionSettings.dimensionData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.dimensionSettings.dimensionData.get(this.CURRENT_DIMENSION_IDENTIFIER);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_DIMENSION_IDENTIFIER;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("dimension.icon", true, currentIcon, CraftPresence.CONFIG.dimensionSettings.fallbackDimensionIcon);
        CraftPresence.CLIENT.syncArgument("dimension.default.icon", CraftPresence.CONFIG.dimensionSettings.fallbackDimensionIcon);
        CraftPresence.CLIENT.syncArgument("dimension.name", this.CURRENT_DIMENSION_NAME);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "dimension.message", "dimension.icon");
        CraftPresence.CLIENT.syncArgument("dimension.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("dimension.icon", formattedIcon);
        CraftPresence.CLIENT.syncTimestamp("data.dimension.time");
    }

    private List<WorldProvider> getDimensionTypes() {
        ArrayList dimensionTypes;
        block8: {
            dimensionTypes = Lists.newArrayList();
            Map reflectedDimensionTypes = (Map)StringUtils.getField("net.minecraftforge.common.DimensionManager", null, "providers");
            if (!dimensionTypes.isEmpty()) break block8;
            if (reflectedDimensionTypes != null) {
                for (Object objectType : reflectedDimensionTypes.values()) {
                    try {
                        WorldProvider type = objectType instanceof Class ? (WorldProvider)((Class)objectType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
                        if (type == null || dimensionTypes.contains(type)) continue;
                        dimensionTypes.add(type);
                    }
                    catch (Throwable ex) {
                        if (!CommandUtils.isVerboseMode()) continue;
                        ex.printStackTrace();
                    }
                }
            } else {
                for (Class<?> classObj : FileUtils.getClassNamesMatchingSuperType(WorldProvider.class, CraftPresence.CONFIG.advancedSettings.includeExtraGuiClasses, new String[0])) {
                    if (classObj == null) continue;
                    try {
                        WorldProvider providerObj = (WorldProvider)classObj.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (dimensionTypes.contains(providerObj)) continue;
                        dimensionTypes.add(providerObj);
                    }
                    catch (Throwable ex) {
                        if (!CommandUtils.isVerboseMode()) continue;
                        ex.printStackTrace();
                    }
                }
            }
        }
        return dimensionTypes;
    }

    @Override
    public void getAllData() {
        for (WorldProvider TYPE : this.getDimensionTypes()) {
            if (TYPE == null) continue;
            String dimensionName = StringUtils.getOrDefault(TYPE.func_80007_l(), MappingUtils.getClassName(TYPE));
            String name = StringUtils.formatIdentifier(dimensionName, true, !CraftPresence.CONFIG.advancedSettings.formatWords);
            if (!this.DIMENSION_NAMES.contains(name)) {
                this.DIMENSION_NAMES.add(name);
            }
            if (this.DIMENSION_TYPES.contains(TYPE)) continue;
            this.DIMENSION_TYPES.add(TYPE);
        }
        for (String dimensionEntry : CraftPresence.CONFIG.dimensionSettings.dimensionData.keySet()) {
            String name;
            if (StringUtils.isNullOrEmpty(dimensionEntry) || this.DIMENSION_NAMES.contains(name = StringUtils.formatIdentifier(dimensionEntry, true, !CraftPresence.CONFIG.advancedSettings.formatWords))) continue;
            this.DIMENSION_NAMES.add(name);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

