/*
 * Decompiled with CFR 0.152.
 */
package external.net.lenni0451.reflect;

import external.net.lenni0451.reflect.Fields;
import external.net.lenni0451.reflect.JVMConstants;
import external.net.lenni0451.reflect.JavaBypass;
import java.lang.reflect.Array;

public class Objects {
    private static final String INVALID_OOP_SIZE = "OOP size is not 4 or 8";
    private static final ThreadLocal<Object[]> OBJECT_ARRAY_CACHE = ThreadLocal.withInitial(() -> new Object[1]);
    public static final long ARRAY_BASE_OFFSET = JavaBypass.UNSAFE.arrayBaseOffset(Object[].class);
    public static final int ARRAY_INDEX_SCALE = JavaBypass.UNSAFE.arrayIndexScale(Object[].class);
    public static final int ADDRESS_SIZE = JavaBypass.UNSAFE.addressSize();
    public static final int OOP_SIZE = CompressedOopsClass.access$000();
    public static final int OBJECT_HEADER_SIZE = BooleanHeaderClass.access$100();
    public static final int ARRAY_HEADER_SIZE = OBJECT_HEADER_SIZE + 4;
    public static final boolean COMPRESSED_OOPS = ADDRESS_SIZE != OOP_SIZE;
    public static final long KLASS_OFFSET = OBJECT_HEADER_SIZE - OOP_SIZE;

    public static long toAddress(Object o) {
        long address;
        Object[] array = OBJECT_ARRAY_CACHE.get();
        array[0] = o;
        if (OOP_SIZE == 4) {
            address = (long)JavaBypass.UNSAFE.getInt(array, ARRAY_BASE_OFFSET) & 0xFFFFFFFFL;
        } else if (OOP_SIZE == 8) {
            address = JavaBypass.UNSAFE.getLong(array, ARRAY_BASE_OFFSET);
        } else {
            throw new IllegalStateException(INVALID_OOP_SIZE);
        }
        array[0] = null;
        return address;
    }

    public static <T> T fromAddress(long address) {
        Object[] array = OBJECT_ARRAY_CACHE.get();
        if (OOP_SIZE == 4) {
            JavaBypass.UNSAFE.putInt(array, ARRAY_BASE_OFFSET, (int)address);
        } else if (OOP_SIZE == 8) {
            JavaBypass.UNSAFE.putLong(array, ARRAY_BASE_OFFSET, address);
        } else {
            throw new IllegalStateException(INVALID_OOP_SIZE);
        }
        Object o = array[0];
        array[0] = null;
        return (T)o;
    }

    public static void copyMemory(Object from, Object to, long size) {
        Objects.copyMemory(from, 0L, to, 0L, size);
    }

    public static void copyMemory(Object from, long fromOffset, Object to, long toOffset, long size) {
        JavaBypass.UNSAFE.copyMemory(Objects.toAddress(from) + fromOffset, Objects.toAddress(to) + toOffset, size);
    }

    public static long getKlass(Class<?> clazz) {
        try {
            if (clazz.isArray()) {
                return Objects.getKlass(Array.newInstance(clazz.getComponentType(), 0));
            }
            return Objects.getKlass(JavaBypass.UNSAFE.allocateInstance(clazz));
        }
        catch (Throwable t) {
            JavaBypass.UNSAFE.throwException(t);
            return 0L;
        }
    }

    public static long getKlass(Object o) {
        if (OOP_SIZE == 4) {
            return (long)JavaBypass.UNSAFE.getInt(o, KLASS_OFFSET) & 0xFFFFFFFFL;
        }
        if (OOP_SIZE == 8) {
            return JavaBypass.UNSAFE.getLong(o, KLASS_OFFSET);
        }
        throw new IllegalStateException(INVALID_OOP_SIZE);
    }

    public static <T> T cast(Object o, Class<T> target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, Object target) {
        return Objects.cast(o, Objects.getKlass(target));
    }

    public static <T> T cast(Object o, long klass) {
        if (JVMConstants.OPENJ9_RUNTIME) {
            throw new UnsupportedOperationException("OpenJ9 is not supported");
        }
        if (OOP_SIZE == 4) {
            JavaBypass.UNSAFE.putInt(o, KLASS_OFFSET, (int)klass);
        } else if (OOP_SIZE == 8) {
            JavaBypass.UNSAFE.putLong(o, KLASS_OFFSET, klass);
        } else {
            throw new IllegalStateException(INVALID_OOP_SIZE);
        }
        return (T)o;
    }

    private static class BooleanHeaderClass {
        public boolean b;

        private BooleanHeaderClass() {
        }

        private static int getHeaderSize() {
            try {
                long b = JavaBypass.UNSAFE.objectFieldOffset(Fields.getDeclaredField(BooleanHeaderClass.class, "b"));
                return (int)b;
            }
            catch (Throwable t) {
                JavaBypass.UNSAFE.throwException(t);
                return 0;
            }
        }

        static /* synthetic */ int access$100() {
            return BooleanHeaderClass.getHeaderSize();
        }
    }

    private static class CompressedOopsClass {
        public Object o1;
        public Object o2;

        private CompressedOopsClass() {
        }

        private static int getOopSize() {
            try {
                long o1 = JavaBypass.UNSAFE.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o1"));
                long o2 = JavaBypass.UNSAFE.objectFieldOffset(Fields.getDeclaredField(CompressedOopsClass.class, "o2"));
                return (int)Math.abs(o2 - o1);
            }
            catch (Throwable t) {
                JavaBypass.UNSAFE.throwException(t);
                return 0;
            }
        }

        static /* synthetic */ int access$000() {
            return CompressedOopsClass.getOopSize();
        }
    }
}

