/*
 * Decompiled with CFR 0.152.
 */
package external.net.lenni0451.reflect.stream.field;

import external.net.lenni0451.reflect.Fields;
import external.net.lenni0451.reflect.stream.field.FieldStream;
import external.net.lenni0451.reflect.stream.general.ModifierWrapper;
import java.lang.reflect.Field;

public class FieldWrapper {
    private final FieldStream parent;
    private final Field field;
    private final ModifierWrapper modifier;

    public FieldWrapper(FieldStream parent, Field field) {
        this.parent = parent;
        this.field = field;
        this.modifier = new ModifierWrapper(this.field.getModifiers());
    }

    public FieldStream parent() {
        return this.parent;
    }

    public Field raw() {
        return this.field;
    }

    public String name() {
        return this.field.getName();
    }

    public Class<?> type() {
        return this.field.getType();
    }

    public Class<?> owner() {
        return this.field.getDeclaringClass();
    }

    public ModifierWrapper modifier() {
        return this.modifier;
    }

    public <T> T get() {
        if (!this.modifier.isStatic() && this.parent.parent().instance() == null) {
            throw new IllegalStateException("Can not get non static field if no instance is provided");
        }
        return Fields.get(this.parent.parent().instance(), this.field);
    }

    public <T> T get(Object instance) {
        return Fields.get(instance, this.field);
    }

    public void set(Object value) {
        if (!this.modifier.isStatic() && this.parent.parent().instance() == null) {
            throw new IllegalStateException("Can not set non-static field if no instance is provided");
        }
        Fields.set(this.parent.parent().instance(), this.field, value);
    }

    public void set(Object instance, Object value) {
        Fields.set(instance, this.field, value);
    }

    public void copy(Object target) {
        if (this.modifier.isStatic()) {
            throw new IllegalStateException("Can not copy static field");
        }
        if (this.parent.parent().instance() == null) {
            throw new IllegalStateException("Can not copy field if no instance is provided");
        }
        Fields.copy(this.parent.parent().instance(), target, this.field);
    }

    public void copy(Object instance, Object target) {
        if (this.modifier.isStatic()) {
            throw new IllegalStateException("Can not copy static field");
        }
        Fields.copy(instance, target, this.field);
    }
}

