/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import java.util.List;

public class ScrollableTextWidget
extends TextDisplayWidget {
    public ScrollableTextWidget(ExtendedScreen parent, boolean centered, int startX, int startY, int width, String message) {
        super(parent, centered, startX, startY, width, message);
    }

    public ScrollableTextWidget(ExtendedScreen parent, int startX, int startY, int width, String message) {
        super(parent, startX, startY, width, message);
    }

    public ScrollableTextWidget(ExtendedScreen parent, boolean centered, int startX, int startY, int width) {
        super(parent, centered, startX, startY, width);
    }

    public ScrollableTextWidget(ExtendedScreen parent, int startX, int startY, int width) {
        super(parent, startX, startY, width);
    }

    public ScrollableTextWidget(ExtendedScreen parent, boolean centered, int width, String message) {
        super(parent, centered, width, message);
    }

    public ScrollableTextWidget(ExtendedScreen parent, int width, String message) {
        super(parent, width, message);
    }

    public ScrollableTextWidget(ExtendedScreen parent, boolean centered, int width) {
        super(parent, centered, width);
    }

    public ScrollableTextWidget(ExtendedScreen parent, int width) {
        super(parent, width);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        int padding = 0;
        int barWidth = 0;
        if (screen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)screen;
            padding = pane.getPadding();
            barWidth = pane.getScrollBarWidth();
        }
        int minX = this.getControlPosX() + padding;
        int maxX = this.getRight() - padding - barWidth;
        int centerX = this.isCentered() ? maxX - (maxX - minX) / 2 : minX + screen.getStringWidth(this.getMessage()) / 2;
        screen.renderScrollingString(this.getMessage(), centerX, minX, this.getControlPosY() + padding, maxX, this.getBottom() - padding, 0xFFFFFF);
    }

    @Override
    public List<String> refreshContent() {
        return null;
    }

    @Override
    public List<String> getRenderLines() {
        return null;
    }

    @Override
    public int getControlHeight() {
        return 20;
    }
}

