/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentClass;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionJavaMethodStatic;
import stanhebben.zenscript.expression.partial.ExpressionJavaStaticField;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.expression.partial.PartialStaticGenerated;
import stanhebben.zenscript.expression.partial.PartialStaticGetter;
import stanhebben.zenscript.expression.partial.PartialStaticMethod;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolCaptured;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class EnvironmentMethodLambda
extends EnvironmentMethod {
    private static final List<Class<? extends IPartialExpression>> nonCapturedExpressions = Arrays.asList(PartialStaticGetter.class, PartialStaticGenerated.class, PartialStaticMethod.class, ExpressionJavaStaticField.class, ExpressionJavaMethodStatic.class, ExpressionCallStatic.class);
    private final List<SymbolCaptured> capturedVariables;
    private final String clsName;

    public EnvironmentMethodLambda(MethodOutput output, IEnvironmentClass environment, String clsName) {
        super(output, environment);
        this.clsName = clsName;
        this.capturedVariables = new ArrayList<SymbolCaptured>(0);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.local.containsKey(name)) {
            return ((IZenSymbol)this.local.get(name)).instance(position);
        }
        IPartialExpression value = this.environment.getValue(name, position);
        if (value != null) {
            if (nonCapturedExpressions.stream().anyMatch(c -> c.isInstance(value))) {
                return value;
            }
            SymbolCaptured capture = new SymbolCaptured(value.eval(this.environment), name, this.clsName);
            this.capturedVariables.add(capture);
            this.local.put(name, capture);
            return capture.instance(position);
        }
        return null;
    }

    public List<SymbolCaptured> getCapturedVariables() {
        return this.capturedVariables;
    }
}

