/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.impl;

import java.io.PrintStream;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.util.ZenPosition;

public class GenericErrorLogger
implements IZenErrorLogger {
    private final PrintStream output;

    public GenericErrorLogger(PrintStream output) {
        this.output = output;
    }

    @Override
    public void error(ZenPosition position, String message) {
        if (position == null) {
            this.output.println("System> " + message);
        } else {
            this.output.println(position + "> " + message);
        }
    }

    @Override
    public void warning(ZenPosition position, String message) {
        if (position == null) {
            this.output.println("system> " + message);
        } else {
            this.output.println(position + "> " + message);
        }
    }

    @Override
    public void info(ZenPosition position, String message) {
        if (position == null) {
            this.output.println("system> " + message);
        } else {
            this.output.println(position + "> " + message);
        }
    }

    @Override
    public void error(String message) {
        this.error(null, message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.error(null, message);
        e.printStackTrace(this.output);
    }

    @Override
    public void warning(String message) {
        this.warning(null, message);
    }

    @Override
    public void info(String message) {
        this.info(null, message);
    }
}

