/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import net.minecraft.item.ItemStack;

public class SpacePlantCrop
extends BasicCrop {
    public int tier() {
        return 13;
    }

    public String name() {
        return "Space Plant";
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 8;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String[] attributes() {
        return new String[]{"Alien", "Space", "Radiation", "Transform"};
    }

    public int maxSize() {
        return 4;
    }

    public int growthDuration(ICropTile crop) {
        return ConfigValues.debug ? 1 : 5000;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= this.maxSize();
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (crop.getSize() >= this.maxSize()) {
            return false;
        }
        if (ConfigValues.debug) {
            return true;
        }
        if (crop.getSize() >= this.maxSize() - 1) {
            if (ConfigValues.isGalacticCraftLoaded) {
                return crop.isBlockBelow(GCBlocks.blockMoon);
            }
            return true;
        }
        return true;
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(CppItems.Modifier, 1, 0);
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block from the moon below to fully mature.");
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(CppItems.Modifier, 1, 0);
    }
}

