/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.abstracts;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;

public abstract class BasicBerryCrop
extends BasicCrop {
    public int tier() {
        return 2;
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 3;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Has increased Nutrient requirements (x1.2)", "Has decreased humidity and air requirements (x0.9)");
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 1.2 + (double)nutrients * 0.9 + (double)air * 0.9);
    }

    public int growthDuration(ICropTile crop) {
        int r = ConfigValues.debug ? 1 : (crop.getSize() == 2 ? 200 : 700);
        return r;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    public int maxSize() {
        return 3;
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek";
    }
}

