/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.abstracts;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BasicTinkerBerryCrop
extends BasicCrop {
    public static String OBname() {
        return "Oreberry";
    }

    public int tier() {
        return 5;
    }

    @Override
    public float dropGainChance() {
        return (float)(Math.pow(0.95, this.tier()) * (double)ConfigValues.TConstructBerryGain);
    }

    protected abstract String hasBlock();

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public boolean canGrow(ICropTile crop) {
        boolean r = ConfigValues.debug ? crop.getSize() < 4 : crop.getSize() < 1 || crop.getSize() == 3 && crop.isBlockBelow(this.hasBlock()) || crop.getLightLevel() <= 10 && crop.getSize() < 3;
        return r;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= 3;
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 0.5 + (double)nutrients * 1.5 + (double)air * 1.0);
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek";
    }

    public int maxSize() {
        return 4;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    @Override
    public List<String> getCropInformation() {
        return Arrays.asList("Needs a block of " + ((ItemStack)OreDictionary.getOres((String)this.hasBlock()).get(0)).func_82833_r() + " Below to fully mature.", "Needs a light level below or equal to 10 to fully mature.", "Has increased Nutrient requirements (x1.5) and decreased humidity requirements (x0.5)", "Hurt Player on collision");
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!(entity instanceof EntityItem)) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        if (entity instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_70051_ag();
        }
        return false;
    }
}

