/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.croploadcore.MyRandom;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicDecorationCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GoldfishCrop
extends BasicDecorationCrop {
    @Override
    public int tier() {
        return 4;
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(CppItems.Goldfisch);
    }

    public String name() {
        return "Goldfish Plant";
    }

    public String[] attributes() {
        return new String[]{"Nether", "Fish", "Food", "Bad", "Water"};
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return 225;
    }

    public boolean rightclick(ICropTile crop, EntityPlayer player) {
        boolean ret;
        if (!ConfigValues.ILoveScreaming) {
            return crop.harvest(true);
        }
        if (crop.getSize() != this.maxSize()) {
            player.func_85030_a("mob.ghast.scream", (float)crop.getSize(), (float)(this.maxSize() + 1 + -1 * crop.getSize()));
            ret = crop.harvest(true);
        } else if (crop.getSize() == this.maxSize()) {
            player.func_85030_a("mob.ghast.scream", 5.0f, 0.5f);
            ret = crop.harvest(true);
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean leftclick(ICropTile crop, EntityPlayer player) {
        boolean ret;
        if (!ConfigValues.ILoveScreaming) {
            return crop.pick(true);
        }
        if (crop.getSize() != this.maxSize()) {
            player.func_85030_a("mob.ghast.scream", (float)crop.getSize(), (float)(this.maxSize() + 1 + -1 * crop.getSize()));
            ret = crop.pick(true);
        } else if (crop.getSize() == this.maxSize()) {
            player.func_85030_a("mob.ghast.scream", 5.0f, 0.5f);
            ret = crop.pick(true);
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!ConfigValues.ILoveScreaming) {
            return super.onEntityCollision(crop, entity);
        }
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer) {
                if (crop.getSize() != this.maxSize()) {
                    entity.func_85030_a("mob.ghast.scream", (float)crop.getSize(), (float)(this.maxSize() + 1 + -1 * crop.getSize()));
                } else if (crop.getSize() == this.maxSize()) {
                    entity.func_85030_a("mob.ghast.scream", 5.0f, 0.5f);
                }
            }
            return ((EntityLivingBase)entity).func_70051_ag();
        }
        return false;
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(CppItems.Goldfisch);
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Screams.");
    }

    public void tick(ICropTile crop) {
        if (ConfigValues.ILoveScreaming && MyRandom.intrandom((int)512, (int)0) == 42) {
            if (crop.getSize() != this.maxSize()) {
                crop.getWorld().func_72908_a((double)crop.getLocation().field_71574_a, (double)crop.getLocation().field_71572_b, (double)crop.getLocation().field_71573_c, "mob.ghast.scream", (float)crop.getSize(), (float)(this.maxSize() + 1 + -1 * crop.getSize()));
            } else if (crop.getSize() == this.maxSize()) {
                crop.getWorld().func_72908_a((double)crop.getLocation().field_71574_a, (double)crop.getLocation().field_71572_b, (double)crop.getLocation().field_71573_c, "mob.ghast.scream", (float)crop.getSize(), (float)(this.maxSize() + 1 + -1 * crop.getSize()));
            }
        }
    }
}

