/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler.machines;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class CropSynthesiser
extends GT_MetaTileEntity_BasicMachine {
    public CropSynthesiser(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 16, new String[]{"It can make Crops from DataOrbs", "It needs a crop's tier/2*1000L of UUM per Crop", "Takes in 16A", "Needs crop's (tier+2)/2 as Voltage level, round down (Tier 5 crop needs 7/2=~3=HV)"}, 4, 1, "Crop_Synthesizer.png", "", new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER)});
    }

    public CropSynthesiser(String mName, byte mTier, String[] mDescriptionArray, ITexture[][][] mTextures, String mGUIName, String mNEIName) {
        super(mName, (int)mTier, 16, mDescriptionArray, mTextures, 4, 1, mGUIName, mNEIName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new CropSynthesiser(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public int checkRecipe(boolean skipOC) {
        ItemStack[] aStacks = new ItemStack[]{this.getInputAt(0), this.getInputAt(1), this.getInputAt(2), this.getInputAt(3)};
        if (ItemList.Tool_DataOrb.isStackEqual((Object)aStacks[0], true, true) && ItemList.Tool_DataOrb.isStackEqual((Object)aStacks[1], true, true) && ItemList.Tool_DataOrb.isStackEqual((Object)aStacks[2], true, true) && ItemList.Tool_DataOrb.isStackEqual((Object)aStacks[3], true, true)) {
            if (!this.mFluid.getFluid().getName().equals("ic2uumatter")) {
                return 0;
            }
            if (this.getOutputAt(0) != null) {
                return 0;
            }
            HashMap<String, String> CropStats = new HashMap<String, String>();
            for (int i = 0; i <= 3; i = (int)((byte)(i + 1))) {
                CropStats.put(Behaviour_DataOrb.getDataTitle((ItemStack)aStacks[i]), Behaviour_DataOrb.getDataName((ItemStack)aStacks[i]));
            }
            String owner = (String)CropStats.get("Crop-Specimen-Scan");
            String name = owner.split(":")[1];
            owner = owner.split(":")[0];
            if (((String)CropStats.get("Crop-Growth-Scan")).isEmpty() || ((String)CropStats.get("Crop-Gain-Scan")).isEmpty() || ((String)CropStats.get("Crop-Resistance-Scan")).isEmpty() || ((String)CropStats.get("Crop-Specimen-Scan")).isEmpty()) {
                return 0;
            }
            CropCard card = Crops.instance.getCropCard(owner, name);
            if (card == null) {
                return 0;
            }
            long neededUUM = (long)((float)card.tier() / 2.0f * 1000.0f);
            if ((long)this.mFluid.amount < neededUUM) {
                return 1;
            }
            NBTTagCompound tNBT = new NBTTagCompound();
            ItemStack op = ItemList.IC2_Crop_Seeds.get(1L, new Object[0]);
            tNBT.func_74774_a("growth", Byte.parseByte((String)CropStats.get("Crop-Growth-Scan")));
            tNBT.func_74774_a("gain", Byte.parseByte((String)CropStats.get("Crop-Gain-Scan")));
            tNBT.func_74774_a("resistance", Byte.parseByte((String)CropStats.get("Crop-Resistance-Scan")));
            tNBT.func_74778_a("owner", owner);
            tNBT.func_74778_a("name", name);
            tNBT.func_74774_a("scan", (byte)4);
            op.func_77982_d(tNBT);
            this.mOutputItems[0] = op;
            this.mFluid.amount = (int)((long)this.mFluid.amount - neededUUM);
            this.calculateOverclockedNess((int)(GT_Values.V[Math.round((card.tier() + 2) / 2)] - GT_Values.V[Math.round((card.tier() + 2) / 2)] / 10L), 12000);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(212)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid().getName().equals("ic2uumatter") || super.isFluidInputAllowed(aFluid);
    }

    public int getCapacity() {
        return 3000 * this.mTier;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        if (ItemList.Tool_DataOrb.isStackEqual((Object)aStack, true, true)) {
            return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
        }
        return false;
    }
}

