/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import ic2.api.crops.ICropTile;
import ic2.core.Ic2Items;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;

public class CCropUtility {
    public static boolean isRainingOn(ICropTile crop) {
        ChunkCoordinates cord = crop.getLocation();
        World world = crop.getWorld();
        if (cord == null || world == null) {
            return false;
        }
        if (world.func_72896_J()) {
            BiomeGenBase biomegenbase = world.func_72807_a(cord.field_71574_a, cord.field_71573_c);
            if (biomegenbase == null) {
                return false;
            }
            if (!biomegenbase.func_76738_d()) {
                return false;
            }
            if (world.func_72937_j(cord.field_71574_a, cord.field_71572_b + 1, cord.field_71573_c)) {
                return true;
            }
        }
        return false;
    }

    public static void damageEntity(Entity ent, float damage) {
        EntityLivingBase elTarget;
        ItemStack boots;
        if (!(ent instanceof EntityLivingBase)) {
            return;
        }
        if (!ConfigValues.BootsProtect) {
            ent.func_70097_a(DamageSource.field_76367_g, damage);
            return;
        }
        if (ent instanceof EntityPlayer) {
            EntityPlayer pl = (EntityPlayer)ent;
            if (pl.field_71075_bZ.field_75102_a) {
                return;
            }
        }
        if ((boots = (elTarget = (EntityLivingBase)ent).func_71124_b(1)) != null) {
            Item item = boots.func_77973_b();
            if (item == Ic2Items.nanoBoots.func_77973_b() || item == Ic2Items.quantumBoots.func_77973_b()) {
                return;
            }
            if (item == Ic2Items.hazmatBoots.func_77973_b()) {
                if (elTarget.func_70093_af()) {
                    return;
                }
                if (elTarget.field_70169_q == elTarget.field_70165_t && elTarget.field_70166_s == elTarget.field_70161_v) {
                    return;
                }
                if (!elTarget.field_70170_p.field_72995_K) {
                    if (CCropUtility.getRandom(elTarget.func_70681_au(), ConfigValues.BootsDamageChance)) {
                        CCropUtility.makeParticles(elTarget, boots);
                        boots.func_77972_a(1, elTarget);
                    }
                    if (boots.field_77994_a == 0) {
                        ent.field_70170_p.func_72956_a(ent, "random.break", 0.8f, 0.8f + elTarget.func_70681_au().nextFloat() * 0.4f);
                        elTarget.func_70062_b(1, null);
                    }
                }
                return;
            }
        }
        elTarget.func_70097_a(DamageSource.field_76367_g, damage);
    }

    public static void makeParticles(EntityLivingBase ent, ItemStack itemStack) {
        WorldServer s = (WorldServer)ent.field_70170_p;
        Vec3 vec31 = Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + 1.0 - (double)ent.func_70047_e() / 2.0), (double)ent.field_70161_v);
        s.func_147487_a("iconcrack_" + Item.func_150891_b((Item)itemStack.func_77973_b()), vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, 3, 0.0, 0.0, 0.0, 0.1);
    }

    public static boolean getRandom(Random r, double chanceMul) {
        return r.nextDouble() * 100.0 < chanceMul;
    }
}

