/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;

public class GenericParticlePacket
implements IMessage {
    public static final byte ENERGY_BALL_KILL = 0;
    public static final byte CHAOS_BALL_KILL = 1;
    public static final byte CHAOS_IMPLOSION = 3;
    public static final byte ARROW_SHOCK_WAVE = 4;
    private byte particleId = 0;
    private double posX;
    private double posY;
    private double posZ;
    private int additionalData;

    public GenericParticlePacket() {
    }

    public GenericParticlePacket(byte particleId, double posX, double posY, double posZ) {
        this.particleId = particleId;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public GenericParticlePacket(byte particleId, double posX, double posY, double posZ, int aditionalData) {
        this.particleId = particleId;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.additionalData = aditionalData;
    }

    public void fromBytes(ByteBuf bytes) {
        this.particleId = bytes.readByte();
        this.posX = bytes.readFloat();
        this.posY = bytes.readFloat();
        this.posZ = bytes.readFloat();
        if (this.particleId == 4) {
            this.additionalData = bytes.readInt();
        }
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeByte((int)this.particleId);
        bytes.writeFloat((float)this.posX);
        bytes.writeFloat((float)this.posY);
        bytes.writeFloat((float)this.posZ);
        if (this.particleId == 4) {
            bytes.writeInt(this.additionalData);
        }
    }

    public static class Handler
    implements IMessageHandler<GenericParticlePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GenericParticlePacket message, MessageContext ctx) {
            switch (message.particleId) {
                case 0: {
                    for (int i = 0; i < 100; ++i) {
                        Particles.DragonProjectileParticle particle = new Particles.DragonProjectileParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, 65535);
                        double m = 0.5;
                        particle.field_70159_w = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70181_x = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70179_y = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        ParticleHandler.spawnCustomParticle(particle);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < 100; ++i) {
                        Particles.DragonProjectileParticle particle = new Particles.DragonProjectileParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, 0x440000);
                        double m = 0.5;
                        particle.field_70159_w = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70181_x = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        particle.field_70179_y = (particle.field_70170_p.field_73012_v.nextDouble() - 0.5) * m;
                        ParticleHandler.spawnCustomParticle(particle);
                    }
                    break;
                }
                case 3: {
                    ParticleHandler.spawnCustomParticle(new Particles.ChaosImplosionParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, 200.0), 512.0);
                    break;
                }
                case 4: {
                    ParticleHandler.spawnCustomParticle(new Particles.ArrowShockParticle(BrandonsCore.proxy.getClientWorld(), message.posX, message.posY, message.posZ, message.additionalData), 256.0);
                    for (int i = 0; i < 100; ++i) {
                        Particles.ArrowParticle particle = new Particles.ArrowParticle(BrandonsCore.proxy.getClientWorld(), message.posX - 0.25 + BrandonsCore.proxy.getClientWorld().field_73012_v.nextDouble() * 0.5, message.posY + BrandonsCore.proxy.getClientWorld().field_73012_v.nextDouble() * 0.5, message.posZ - 0.25 + BrandonsCore.proxy.getClientWorld().field_73012_v.nextDouble() * 0.5, 0xFF6000, 0.2f + BrandonsCore.proxy.getClientWorld().field_73012_v.nextFloat() * 10.0f);
                        double mm = 2.0;
                        particle.field_70159_w = (BrandonsCore.proxy.getClientWorld().field_73012_v.nextDouble() - 0.5) * mm;
                        particle.field_70181_x = (BrandonsCore.proxy.getClientWorld().field_73012_v.nextDouble() - 0.5) * mm;
                        particle.field_70179_y = (BrandonsCore.proxy.getClientWorld().field_73012_v.nextDouble() - 0.5) * mm;
                        ParticleHandler.spawnCustomParticle(particle, 64.0);
                    }
                    break;
                }
            }
            return null;
        }
    }
}

