/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import com.brandon3055.brandonscore.common.handlers.IProcess;
import com.brandon3055.brandonscore.common.handlers.ProcessHandler;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.ReactorExplosionTrace;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ReactorExplosion
implements IProcess {
    public static final DamageSource FUSION_EXPLOSION = new DamageSource("damage.de.fusionExplode").func_94540_d().func_76348_h().func_151518_m().func_76359_i();
    private final World world;
    private final int xCoord;
    private final int yCoord;
    private final int zCoord;
    private final float power;
    private boolean isDead;
    private double expansion = 0.0;

    public ReactorExplosion(World world, int x, int y, int z, float power) {
        this.world = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.power = power;
        this.isDead = world.field_72995_K;
    }

    public void updateProcess() {
        int size = (int)this.expansion;
        for (int x = this.xCoord - size; x < this.xCoord + size; ++x) {
            for (int z = this.zCoord - size; z < this.zCoord + size; ++z) {
                double distance = Utills.getDistanceAtoB((double)x, (double)z, (double)this.xCoord, (double)this.zCoord);
                if (!(distance < this.expansion) || !(distance >= (double)(size - 1))) continue;
                float tracePower = this.power - (float)(this.expansion / 10.0);
                tracePower = (float)((double)tracePower * (1.0 + (double)(this.world.field_73012_v.nextFloat() - 0.5f) * 0.2));
                ProcessHandler.addProcess((IProcess)new ReactorExplosionTrace(this.world, x, this.yCoord, z, tracePower));
            }
        }
        this.isDead = this.expansion >= (double)(this.power * 10.0f);
        this.expansion += 1.0;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

