/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.world;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.world.ChaosWorldGenHandler;
import com.brandon3055.draconicevolution.common.world.WorldGenEnderComet;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class DraconicWorldGenerator
implements IWorldGenerator {
    public static boolean chaosIslandsEnabled = true;
    public static boolean cometsEnabled = true;
    public static boolean oreEnabledInEnd = true;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateSurface(random, chunkX * 16, chunkZ * 16, world);
                break;
            }
            case 1: {
                this.generateEnd(random, chunkX * 16, chunkZ * 16, world);
                break;
            }
            case -1: {
                this.generateNether(random, chunkX * 16, chunkZ * 16, world);
                break;
            }
            default: {
                int n;
                if (ConfigHandler.oreGenDimensionWhitelist.length > 0) {
                    boolean isWhitelisted = false;
                    int[] nArray = ConfigHandler.oreGenDimensionWhitelist;
                    n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        Integer dim = nArray[i];
                        if (dim != world.field_73011_w.field_76574_g) continue;
                        isWhitelisted = true;
                        break;
                    }
                    if (!isWhitelisted) {
                        return;
                    }
                }
                int[] nArray = ConfigHandler.oreGenDimentionBlacklist;
                int n2 = nArray.length;
                for (n = 0; n < n2; ++n) {
                    Integer dim = nArray[n];
                    if (dim != world.field_73011_w.field_76574_g) continue;
                    return;
                }
                this.addOreSpawn(ModBlocks.draconiumOre, world, random, chunkX * 16, chunkZ * 16, 3, 4, ConfigHandler.oreWeightDefault, 2, 8);
            }
        }
    }

    public void generateSurface(Random random, int x, int z, World world) {
        if (!ConfigHandler.disableOreSpawnOverworld) {
            this.addOreSpawn(ModBlocks.draconiumOre, world, random, x, z, 3, 4, ConfigHandler.oreWeightOverworld, 2, 8);
        }
    }

    public void generateEnd(Random random, int x, int z, World world) {
        int x1 = x + random.nextInt(16);
        int y = 20 + random.nextInt(170);
        int z1 = z + random.nextInt(16);
        if (cometsEnabled && ConfigHandler.generateEnderComets && Math.sqrt(x * x + z * z) > 200.0 && random.nextInt(Math.max(1, ConfigHandler.cometRarity)) == 0) {
            new WorldGenEnderComet().func_76484_a(world, random, x1, y, z1);
        }
        if (chaosIslandsEnabled && ConfigHandler.generateChaosIslands) {
            ChaosWorldGenHandler.generateChunk(world, x / 16, z / 16, null, random);
        }
        if (oreEnabledInEnd && !ConfigHandler.disableOreSpawnEnd) {
            this.addOreSpawn(ModBlocks.draconiumOre, world, random, x, z, 4, 5, ConfigHandler.oreWeightEnd, 1, 70);
        }
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        if (!ConfigHandler.disableOreSpawnNether) {
            this.addOreSpawn(ModBlocks.draconiumOre, world, random, chunkX, chunkZ, 3, 4, ConfigHandler.oreWeightNether, 1, 125);
        }
    }

    public void addOreSpawn(Block block, World world, Random random, int chunkXPos, int chunkZPos, int minVainSize, int maxVainSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = chunkXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = chunkZPos + random.nextInt(16);
            new WorldGenMinable(block, 0, minVainSize + random.nextInt(maxVainSize - minVainSize), Blocks.field_150377_bs).func_76484_a(world, random, posX, posY, posZ);
            new WorldGenMinable(block, 0, 3, Blocks.field_150348_b).func_76484_a(world, random, posX, posY, posZ);
            new WorldGenMinable(block, 0, minVainSize + random.nextInt(maxVainSize - minVainSize), Blocks.field_150424_aL).func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

