/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.container.ContainerDislocatorInhibitor;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TileDislocatorInhibitor
extends TileEntity
implements IInventory {
    public static final int MAXIMUM_RANGE = 16;
    public static final int MINIMUM_RANGE = 1;
    public static final int FILTER_SLOTS = 8;
    public static final HashMap<World, HashSet<TileDislocatorInhibitor>> inhibitors = new HashMap();
    private boolean redstoneActive = false;
    private ActivityControlType activityControlType = ActivityControlType.ALWAYS_ACTIVE;
    private boolean registered = false;
    private int range = 5;
    private boolean whitelist = false;
    private final ItemStack[] filter = new ItemStack[8];

    public static boolean isBlockedByInhibitor(World world, EntityItem item) {
        HashSet<TileDislocatorInhibitor> list = inhibitors.get(world);
        if (list == null) {
            return false;
        }
        for (TileDislocatorInhibitor inhibitor : list) {
            if (!inhibitor.shouldBeActive() || !inhibitor.isBlockingItem(item.func_92059_d()) || !inhibitor.isInRange(item.field_70165_t, item.field_70163_u, item.field_70161_v)) continue;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.registered) {
            HashSet map = inhibitors.computeIfAbsent(this.field_145850_b, k -> new HashSet());
            map.add(this);
            this.registered = true;
        }
    }

    public void unregister() {
        if (inhibitors.containsKey(this.field_145850_b)) {
            HashSet<TileDislocatorInhibitor> list = inhibitors.get(this.field_145850_b);
            list.remove((Object)this);
            if (list.isEmpty()) {
                inhibitors.remove(this.field_145850_b);
            }
        }
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int value) {
        if (value > 16) {
            value = 1;
        }
        if (value < 1) {
            value = 16;
        }
        this.range = value;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isBlockingItem(ItemStack item) {
        boolean blocked = false;
        for (ItemStack itemStack : this.filter) {
            if (itemStack == null || !itemStack.func_77969_a(item)) continue;
            blocked = true;
            break;
        }
        if (this.whitelist) {
            return blocked;
        }
        return !blocked;
    }

    public boolean shouldBeActive() {
        switch (this.activityControlType) {
            case NEVER_ACTIVE: {
                return false;
            }
            case WITH_REDSTONE: {
                return this.redstoneActive;
            }
            case WITHOUT_REDSTONE: {
                return !this.redstoneActive;
            }
        }
        return true;
    }

    public boolean isInRange(double x, double y, double z) {
        return x >= (double)(this.field_145851_c - this.range) && x <= (double)(this.field_145851_c + this.range + 1) && y >= (double)(this.field_145848_d - this.range) && y <= (double)(this.field_145848_d + this.range + 1) && z >= (double)(this.field_145849_e - this.range) && z <= (double)(this.field_145849_e + this.range + 1);
    }

    public void setActivityControl(int index) {
        if (index < 0 || index >= ActivityControlType.values().length) {
            return;
        }
        this.activityControlType = ActivityControlType.values()[index];
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ActivityControlType getActivityControlType() {
        return this.activityControlType;
    }

    public boolean isRedstoneActive() {
        return this.redstoneActive;
    }

    public void setRedstoneActive(boolean redstoneActive) {
        this.redstoneActive = redstoneActive;
    }

    public void setFilterItem(int slot, ItemStack item) {
        if (slot < 0 || slot >= 8) {
            return;
        }
        this.func_70299_a(slot, item);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void addItemFilter(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.filter[i] != null) continue;
            this.func_70299_a(i, itemStack);
            return;
        }
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(boolean value) {
        this.whitelist = value;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return StatCollector.func_74838_a((String)(ModBlocks.dislocatorInhibitor.func_149739_a() + ".name"));
    }

    public int func_70302_i_() {
        return 8;
    }

    public ItemStack func_70301_a(int slotIn) {
        if (slotIn < 0 || slotIn >= 8) {
            return null;
        }
        return this.filter[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack item = this.filter[index];
        this.filter[index] = null;
        if (item == null) {
            return null;
        }
        item.field_77994_a = 0;
        return item;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack != null) {
            this.filter[index] = stack.func_77946_l();
            this.filter[index].field_77994_a = 0;
        } else {
            this.filter[index] = null;
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public Container getGuiContainer(InventoryPlayer playerInventory) {
        return new ContainerDislocatorInhibitor(playerInventory, this);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound compound) {
        compound.func_74768_a("Range", this.range);
        compound.func_74757_a("RedstoneAcitve", this.redstoneActive);
        compound.func_74778_a("ActivityControl", this.activityControlType.name());
        compound.func_74757_a("Whitelist", this.whitelist);
        int i = 0;
        for (ItemStack item : this.filter) {
            NBTTagCompound itemTag = new NBTTagCompound();
            if (item != null) {
                item.func_77955_b(itemTag);
                compound.func_74782_a("Item" + i, (NBTBase)itemTag);
            }
            ++i;
        }
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.range = compound.func_74762_e("Range");
        this.redstoneActive = compound.func_74767_n("RedstoneAcitve");
        this.activityControlType = ActivityControlType.valueOf(compound.func_74779_i("ActivityControl"));
        this.whitelist = compound.func_74767_n("Whitelist");
        for (int i = 0; i < 8; ++i) {
            NBTBase tag = compound.func_74781_a("Item" + i);
            this.filter[i] = tag instanceof NBTTagCompound ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag)) : null;
        }
        super.func_145839_a(compound);
    }

    public static enum ActivityControlType {
        ALWAYS_ACTIVE,
        WITH_REDSTONE,
        WITHOUT_REDSTONE,
        NEVER_ACTIVE;


        public ActivityControlType getNext() {
            ActivityControlType activityControlType;
            switch (this) {
                case ALWAYS_ACTIVE: {
                    activityControlType = WITH_REDSTONE;
                    break;
                }
                case WITH_REDSTONE: {
                    activityControlType = WITHOUT_REDSTONE;
                    break;
                }
                case WITHOUT_REDSTONE: {
                    activityControlType = NEVER_ACTIVE;
                    break;
                }
                default: {
                    activityControlType = ALWAYS_ACTIVE;
                }
            }
            return activityControlType;
        }
    }
}

