/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.ParticleReactorBeam;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IReactorPart;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.container.ContainerReactor;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.common.utills.OreDictionaryHelper;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReactorStabilizer
extends TileEntity
implements IReactorPart,
IEnergyProvider,
IDEPeripheral,
ISidedInventory {
    public float coreRotation = 0.0f;
    public float ringRotation = 0.0f;
    public float coreSpeed = 1.0f;
    public float ringSpeed = 1.0f;
    public float modelIllumination = 0.0f;
    public ForgeDirection facing = ForgeDirection.UP;
    public MultiblockHelper.TileLocation masterLocation = new MultiblockHelper.TileLocation();
    public boolean isValid = false;
    public int tick = 0;
    private IReactorPart.ComparatorMode comparatorMode = IReactorPart.ComparatorMode.TEMPERATURE;
    private int comparatorOutputCache = -1;
    @SideOnly(value=Side.CLIENT)
    private ParticleReactorBeam beam;

    public void func_145845_h() {
        ++this.tick;
        if (this.field_145850_b.field_72995_K) {
            this.updateBeam();
            return;
        }
        TileReactorCore core = this.getMaster();
        if (core != null) {
            int comparatorOutput;
            if (core.reactorState == TileReactorCore.ReactorState.ONLINE) {
                ForgeDirection back = this.facing.getOpposite();
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + back.offsetX, this.field_145848_d + back.offsetY, this.field_145849_e + back.offsetZ);
                if (tile instanceof IEnergyReceiver) {
                    IEnergyReceiver receiver = (IEnergyReceiver)tile;
                    int energyToReceive = Math.min(core.energySaturation, core.maxEnergySaturation / 100);
                    int energyReceived = receiver.receiveEnergy(this.facing, energyToReceive, false);
                    core.energySaturation -= energyReceived;
                }
            }
            if ((comparatorOutput = core.getComparatorOutput(this.comparatorMode)) != this.comparatorOutputCache) {
                this.comparatorOutputCache = comparatorOutput;
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateBeam() {
        TileReactorCore core = this.getMaster();
        if (core == null) {
            this.coreSpeed = 0.0f;
            this.ringSpeed = 0.0f;
            this.modelIllumination = 0.0f;
            return;
        }
        this.coreRotation += this.coreSpeed;
        this.ringRotation += this.ringSpeed;
        this.coreSpeed = 30.0f * core.renderSpeed;
        this.ringSpeed = 5.0f * core.renderSpeed;
        this.modelIllumination = core.renderSpeed;
        if (this.tick % 100 == 0) {
            this.beam = null;
        }
        if (this.isValid) {
            this.beam = DraconicEvolution.proxy.reactorBeam(this, this.beam, true);
        }
    }

    public void onPlaced() {
        for (int distance = 1; distance <= 10; ++distance) {
            MultiblockHelper.TileLocation location = new MultiblockHelper.TileLocation(this.field_145851_c + this.facing.offsetX * distance, this.field_145848_d + this.facing.offsetY * distance, this.field_145849_e + this.facing.offsetZ * distance);
            TileEntity tile = location.getTileEntity(this.field_145850_b);
            if (!(tile instanceof TileReactorCore)) continue;
            TileReactorCore core = (TileReactorCore)tile;
            this.setUp(location);
            core.updateReactorParts(false);
            core.validateStructure();
            return;
        }
        this.shutDown();
    }

    @Override
    public MultiblockHelper.TileLocation getMasterLocation() {
        return this.masterLocation;
    }

    @Override
    public TileReactorCore getMaster() {
        TileReactorCore core;
        TileEntity tile = this.masterLocation.getTileEntity(this.field_145850_b);
        return tile instanceof TileReactorCore ? (core = (TileReactorCore)tile) : null;
    }

    @Override
    public void setUp(MultiblockHelper.TileLocation masterLocation) {
        this.masterLocation = masterLocation;
        this.isValid = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void shutDown() {
        this.isValid = false;
        this.masterLocation = new MultiblockHelper.TileLocation();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean isActive() {
        return this.isValid;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public IReactorPart.ComparatorMode getComparatorMode() {
        return this.comparatorMode;
    }

    @Override
    public void changeComparatorMode() {
        this.comparatorMode = this.comparatorMode.next();
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facing.ordinal());
        compound.func_74757_a("IsValid", this.isValid);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.masterLocation.readFromNBT(compound, "Master");
        this.facing = ForgeDirection.getOrientation((int)compound.func_74762_e("Facing"));
        this.isValid = compound.func_74767_n("IsValid");
        super.onDataPacket(net, pkt);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facing.ordinal());
        compound.func_74757_a("IsValid", this.isValid);
        compound.func_74768_a("RedstoneMode", this.comparatorMode.ordinal());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.masterLocation.readFromNBT(compound, "Master");
        this.facing = ForgeDirection.getOrientation((int)compound.func_74762_e("Facing"));
        this.isValid = compound.func_74767_n("IsValid");
        this.comparatorMode = IReactorPart.ComparatorMode.getMode(compound.func_74762_e("RedstoneMode"));
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.facing.getOpposite();
    }

    public double func_145833_n() {
        return 40960.0;
    }

    @Override
    public String getName() {
        return "draconic_reactor";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getReactorInfo", "chargeReactor", "activateReactor", "stopReactor"};
    }

    @Override
    public Object[] callMethod(String methodName, Object ... args) {
        TileReactorCore core = this.getMaster();
        return core != null ? core.callMethod(methodName, args) : null;
    }

    public int[] func_94128_d(int p_94128_1_) {
        int[] i = new int[this.func_70302_i_()];
        for (int i1 = 0; i1 < i.length; ++i1) {
            i[i1] = i1;
        }
        return i;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        TileReactorCore core = this.getMaster();
        if (core != null) {
            return ConfigHandler.enableAutomation && core.reactorFuel + core.convertedFuel < ContainerReactor.maximumFuelStorage;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        TileReactorCore core = this.getMaster();
        if (core != null) {
            return ConfigHandler.enableAutomation && core.convertedFuel > ContainerReactor.fullChaosAmount;
        }
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slotIn) {
        TileReactorCore core = this.getMaster();
        if (core != null) {
            return core.func_70301_a(slotIn);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int count) {
        TileReactorCore core = this.getMaster();
        return core.func_70298_a(i, count);
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        TileReactorCore core = this.getMaster();
        core.func_70299_a(i, stack);
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        TileReactorCore core = this.getMaster();
        return core.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return this.validInputItems(stack);
    }

    public boolean validInputItems(ItemStack item) {
        Set<String> oreNames = OreDictionaryHelper.getOreNames(item);
        return oreNames.contains("nuggetDraconiumAwakened") || oreNames.contains("ingotDraconiumAwakened") || oreNames.contains("blockDraconiumAwakened");
    }
}

