/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.multiblock;

import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyPylon;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileInvisibleMultiblock;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayBlock;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class InvisibleMultiblock
extends BlockDE
implements IHudDisplayBlock {
    public InvisibleMultiblock() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.func_149752_b(2000.0f);
        this.func_149663_c("invisibleMultiblock");
        ModBlocks.register(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconium_block_0");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 0 || metadata == 1;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0 || metadata == 1) {
            return new TileInvisibleMultiblock();
        }
        return null;
    }

    public Item func_149650_a(int meta, Random p_149650_2_, int var2) {
        if (meta == 0) {
            return Item.func_150898_a((Block)BalanceConfigHandler.energyStorageStructureOuterBlock);
        }
        if (meta == 1) {
            return Item.func_150898_a((Block)BalanceConfigHandler.energyStorageStructureBlock);
        }
        return null;
    }

    public int func_149692_a(int metadata) {
        if (metadata == 0) {
            return BalanceConfigHandler.energyStorageStructureOuterBlockMetadata;
        }
        if (metadata == 1) {
            return BalanceConfigHandler.energyStorageStructureBlockMetadata;
        }
        return super.func_149692_a(metadata);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 1) {
            TileInvisibleMultiblock thisTile;
            TileInvisibleMultiblock tileInvisibleMultiblock = thisTile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)world.func_147438_o(x, y, z) : null;
            if (thisTile == null) {
                LogHelper.error("Missing Tile Entity (TileInvisibleMultiblock)");
                return false;
            }
            TileEnergyStorageCore master = thisTile.getMaster();
            if (master == null) {
                this.func_149695_a(world, x, y, z, this);
                return false;
            }
            if (!world.field_72995_K) {
                world.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
                player.func_146105_b((IChatComponent)new ChatComponentText("Tier:" + (master.getTier() + 1)));
                String BN = String.valueOf(master.getEnergyStored());
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"info.de.charge.txt") + ": " + Utills.formatNumber((long)master.getEnergyStored()) + " / " + Utills.formatNumber((long)master.getMaxEnergyStored()) + " [" + BN + " RF]"));
            }
            return true;
        }
        if (meta == 2) {
            TileEnergyPylon pylon;
            TileEnergyPylon tileEnergyPylon = world.func_147438_o(x, y + 1, z) != null && world.func_147438_o(x, y + 1, z) instanceof TileEnergyPylon ? (TileEnergyPylon)world.func_147438_o(x, y + 1, z) : (pylon = world.func_147438_o(x, y - 1, z) != null && world.func_147438_o(x, y - 1, z) instanceof TileEnergyPylon ? (TileEnergyPylon)world.func_147438_o(x, y - 1, z) : null);
            if (pylon == null) {
                return false;
            }
            pylon.reciveEnergy = !pylon.reciveEnergy;
            world.func_147471_g(pylon.field_145851_c, pylon.field_145848_d, pylon.field_145849_e);
            pylon.onActivated();
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block p_149695_5_) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 1) {
            TileInvisibleMultiblock thisTile;
            TileInvisibleMultiblock tileInvisibleMultiblock = thisTile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)world.func_147438_o(x, y, z) : null;
            if (thisTile == null) {
                LogHelper.error("Missing Tile Entity (TileInvisibleMultiblock)");
                this.revert(world, x, y, z);
                return;
            }
            TileEnergyStorageCore master = thisTile.getMaster();
            if (master == null) {
                LogHelper.error("Master = null reverting!");
                this.revert(world, x, y, z);
                return;
            }
            if (master.isOnline()) {
                master.isStructureStillValid(thisTile.getMaster().getTier() == 1);
            }
            if (!master.isOnline()) {
                this.revert(world, x, y, z);
            }
        } else if (meta == 2 && world.func_147439_a(x, y + 1, z) != ModBlocks.energyPylon && world.func_147439_a(x, y - 1, z) != ModBlocks.energyPylon) {
            world.func_147449_b(x, y, z, Blocks.field_150359_w);
        }
    }

    private void revert(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            world.func_147465_d(x, y, z, BalanceConfigHandler.energyStorageStructureOuterBlock, BalanceConfigHandler.energyStorageStructureOuterBlockMetadata, 3);
        } else if (meta == 1) {
            world.func_147465_d(x, y, z, BalanceConfigHandler.energyStorageStructureBlock, BalanceConfigHandler.energyStorageStructureBlockMetadata, 3);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block p_149749_5_, int meta) {
        TileInvisibleMultiblock thisTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        TileInvisibleMultiblock tileInvisibleMultiblock = thisTile = tile != null && tile instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)tile : null;
        if (thisTile != null && thisTile.getMaster() != null && thisTile.getMaster().isOnline()) {
            world.func_72921_c(x, y, z, 0, 2);
            thisTile.getMaster().isStructureStillValid(thisTile.getMaster().getTier() == 1);
        }
        super.func_149749_a(world, x, y, z, p_149749_5_, meta);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 1) {
            TileInvisibleMultiblock thisTile;
            TileInvisibleMultiblock tileInvisibleMultiblock = thisTile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)world.func_147438_o(x, y, z) : null;
            if (thisTile != null && thisTile.getMaster() != null) {
                return AxisAlignedBB.func_72330_a((double)thisTile.getMaster().field_145851_c, (double)thisTile.getMaster().field_145848_d, (double)thisTile.getMaster().field_145849_e, (double)((double)thisTile.getMaster().field_145851_c + 0.5), (double)((double)thisTile.getMaster().field_145848_d + 0.5), (double)((double)thisTile.getMaster().field_145849_e + 0.5));
            }
            return super.func_149633_g(world, x, y, z);
        }
        if (meta == 2) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.49), (double)((double)y + 0.49), (double)((double)z + 0.49), (double)((double)x + 0.51), (double)((double)y + 0.51), (double)((double)z + 0.51));
        }
        return super.func_149633_g(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
        }
        return super.func_149668_a(world, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 0) {
            return new ItemStack(BalanceConfigHandler.energyStorageStructureOuterBlock, 1, BalanceConfigHandler.energyStorageStructureOuterBlockMetadata);
        }
        if (metadata == 1) {
            return new ItemStack(BalanceConfigHandler.energyStorageStructureBlock, 1, BalanceConfigHandler.energyStorageStructureBlockMetadata);
        }
        return new ItemStack(Blocks.field_150359_w);
    }

    @Override
    public List<String> getDisplayData(World world, int x, int y, int z) {
        ArrayList<String> list = new ArrayList<String>();
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 || meta == 1) {
            TileInvisibleMultiblock thisTile;
            TileInvisibleMultiblock tileInvisibleMultiblock = thisTile = world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)world.func_147438_o(x, y, z) : null;
            if (thisTile == null) {
                LogHelper.error("Missing Tile Entity (TileInvisibleMultiblock getDisplayData)");
                return list;
            }
            TileEnergyStorageCore master = thisTile.getMaster();
            if (master == null) {
                return list;
            }
            list.add(InfoHelper.HITC() + ModBlocks.energyStorageCore.func_149732_F());
            list.add("Tier: " + InfoHelper.ITC() + (master.getTier() + 1));
            String BN = String.valueOf(master.getEnergyStored());
            list.add(StatCollector.func_74838_a((String)"info.de.charge.txt") + ": " + InfoHelper.ITC() + Utills.formatNumber((long)master.getEnergyStored()) + " / " + Utills.formatNumber((long)master.getMaxEnergyStored()) + " [" + Utills.addCommas((long)master.getEnergyStored()) + " RF]");
            return list;
        }
        return list;
    }

    @Override
    public String func_149739_a() {
        return super.func_149739_a();
    }
}

