/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.client.utills.GuiHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Teleporter;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.gui.GuiButtonAHeight;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.network.TeleporterPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUITeleporter
extends GuiScreen {
    private final int xSize = 182;
    private final int ySize = 141;
    private ResourceLocation guiTexture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/gui/TeleporterMKII.png");
    private ItemStack teleporterItem;
    protected List<Teleporter.TeleportLocation> locations = new ArrayList<Teleporter.TeleportLocation>(0);
    private int selected = 0;
    private int selectionOffset = 0;
    private int maxOffset = 0;
    private int fuel = 0;
    private boolean editingExisting = false;
    private boolean editingNew = false;
    private boolean showFuelLight = true;
    private int tick = 0;
    private GuiTextField textBeingEdited;
    private EntityPlayer player;

    public GUITeleporter(EntityPlayer player) {
        this.player = player;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII))) {
            this.teleporterItem = player.func_71045_bC();
            this.readDataFromItem(this.teleporterItem);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.guiTexture);
        int posX = (this.field_146294_l - 182) / 2;
        int posY = (this.field_146295_m - 141) / 2;
        this.func_73729_b(posX, posY, 0, 0, 182, 141);
        if (this.fuel <= 5) {
            this.func_73729_b(posX + 169, posY + 86, 40, 150, 7, 7);
        }
        if (this.fuel <= 5 && this.showFuelLight || this.fuel > 5 && this.fuel < 10) {
            this.func_73729_b(posX + 169, posY + 86, 40, 143, 7, 7);
        }
        this.drawArrows(x - posX, y - posY);
        this.drawLocations(x - posX, y - posY);
        this.drawSelectionInfo();
        this.textBeingEdited.func_146194_f();
        String colour = EnumChatFormatting.GREEN + "";
        if (this.fuel < 10) {
            colour = EnumChatFormatting.YELLOW + "";
        }
        if (this.fuel == 0) {
            colour = EnumChatFormatting.DARK_RED + "";
        }
        this.field_146289_q.func_78276_b(colour + StatCollector.func_74838_a((String)"info.teleporterInfFuel.txt") + " " + this.fuel, posX + 115, posY + 87, 0);
        super.func_73863_a(x, y, f);
        for (int i = 0; i < Math.min(12, this.locations.size()); ++i) {
            if (!GuiHelper.isInRect((int)17, (int)(6 + i * 11), (int)80, (int)10, (int)(x - posX), (int)(y - posY))) continue;
            ArrayList<String> l = new ArrayList<String>();
            l.add(StatCollector.func_74838_a((String)"info.de.rightClickToTeleport.txt"));
            this.drawHoveringText(l, x, y, this.field_146289_q);
        }
    }

    private void drawLocations(int x, int y) {
        int posX = (this.field_146294_l - 182) / 2;
        int posY = (this.field_146295_m - 141) / 2;
        for (int i = 0; i < Math.min(12, this.locations.size()); ++i) {
            if (GuiHelper.isInRect((int)17, (int)(6 + i * 11), (int)80, (int)10, (int)x, (int)y)) {
                this.func_73729_b(posX + 19, posY + 5 + i * 11, 0, 188, 80, 10);
            }
            if (this.getLocationSafely(i + this.selectionOffset).getWriteProtected()) {
                if (GuiHelper.isInRect((int)102, (int)(7 + i * 11), (int)6, (int)6, (int)x, (int)y)) {
                    this.func_73729_b(posX + 102, posY + 7 + i * 11, 26, 149, 6, 6);
                    continue;
                }
                this.func_73729_b(posX + 102, posY + 7 + i * 11, 26, 143, 6, 6);
                continue;
            }
            if (GuiHelper.isInRect((int)101, (int)(7 + i * 11), (int)8, (int)7, (int)x, (int)y)) {
                this.func_73729_b(posX + 101, posY + 7 + i * 11, 32, 150, 8, 7);
                continue;
            }
            this.func_73729_b(posX + 101, posY + 7 + i * 11, 32, 143, 8, 7);
        }
        this.func_73729_b(posX + 19, posY + 5 + this.selected * 11, 0, 188, 80, 10);
        int yl = 0;
        for (int i = this.selectionOffset; i < this.locations.size() && i < this.selectionOffset + 12; ++i) {
            String s = this.getLocationSafely(i).getName();
            if (this.field_146289_q.func_78256_a(s) > 80) {
                int safety = 0;
                while (this.field_146289_q.func_78256_a(s) > 70) {
                    s = s.substring(0, s.length() - 1);
                    if (++safety <= 200) continue;
                }
                s = s + "...";
            }
            this.field_146289_q.func_78276_b(s, posX + 21, posY + 7 + yl * 11, 0);
            ++yl;
        }
    }

    private void drawArrows(int x, int y) {
        boolean highLighted;
        int posX = (this.field_146294_l - 182) / 2;
        int posY = (this.field_146295_m - 141) / 2;
        if (this.selectionOffset > 0) {
            highLighted = GuiHelper.isInRect((int)4, (int)4, (int)13, (int)15, (int)x, (int)y);
            if (highLighted) {
                this.func_73729_b(posX + 4, posY + 4, 0, 158, 13, 15);
            } else {
                this.func_73729_b(posX + 4, posY + 4, 0, 143, 13, 15);
            }
        } else {
            this.func_73729_b(posX + 4, posY + 4, 0, 173, 13, 15);
        }
        if (this.selectionOffset < this.maxOffset) {
            highLighted = GuiHelper.isInRect((int)4, (int)122, (int)13, (int)15, (int)x, (int)y);
            if (highLighted) {
                this.func_73729_b(posX + 4, posY + 122, 13, 158, 13, 15);
            } else {
                this.func_73729_b(posX + 4, posY + 122, 13, 143, 13, 15);
            }
        } else {
            this.func_73729_b(posX + 4, posY + 122, 13, 173, 13, 15);
        }
        float percent = this.locations.size() <= 12 ? 1.0f : 12.0f / (float)this.locations.size();
        int drawSize = (int)(percent * 99.0f);
        int space = 99 - drawSize;
        float location = (float)this.selectionOffset / (float)(this.locations.size() - 12);
        int yOffset = (int)(location * (float)space);
        this.func_73729_b(posX + 5, posY + 21 + yOffset, 182, 0, 11, drawSize);
        this.func_73729_b(posX + 5, posY + 21 + drawSize - 1 + yOffset, 182, 98, 11, 1);
    }

    private void drawSelectionInfo() {
        int posX = (this.field_146294_l - 182) / 2;
        int posY = (this.field_146295_m - 141) / 2;
        if (this.locations.size() <= 0) {
            return;
        }
        this.field_146289_q.func_78276_b(EnumChatFormatting.GOLD + "X: " + (int)this.getLocationSafely(this.selected + this.selectionOffset).getXCoord(), posX + 114, posY + 7, 0);
        this.field_146289_q.func_78276_b(EnumChatFormatting.GOLD + "Y: " + (int)this.getLocationSafely(this.selected + this.selectionOffset).getYCoord(), posX + 114, posY + 16, 0);
        this.field_146289_q.func_78276_b(EnumChatFormatting.GOLD + "Z: " + (int)this.getLocationSafely(this.selected + this.selectionOffset).getZCoord(), posX + 114, posY + 25, 0);
        this.field_146289_q.func_78276_b(EnumChatFormatting.GOLD + "" + this.getLocationSafely(this.selected + this.selectionOffset).getDimensionName(), posX + 114, posY + 34, 0);
    }

    protected void func_73864_a(int x, int y, int button) {
        int posX = (this.field_146294_l - 182) / 2;
        int posY = (this.field_146295_m - 141) / 2;
        boolean offsetChanged = false;
        boolean selectionChanged = false;
        if (this.textBeingEdited.func_146176_q()) {
            this.textBeingEdited.func_146192_a(x, y, button);
        }
        if (this.selectionOffset > 0 && GuiHelper.isInRect((int)3, (int)5, (int)13, (int)15, (int)(x - posX), (int)(y - posY))) {
            --this.selectionOffset;
            offsetChanged = true;
            if (this.selected < 11) {
                ++this.selected;
                selectionChanged = true;
            }
        }
        if (this.selectionOffset < this.maxOffset && GuiHelper.isInRect((int)3, (int)123, (int)13, (int)15, (int)(x - posX), (int)(y - posY))) {
            ++this.selectionOffset;
            offsetChanged = true;
            if (this.selected > 0) {
                --this.selected;
                selectionChanged = true;
            }
        }
        for (int i = 0; i < Math.min(12, this.locations.size()); ++i) {
            if (GuiHelper.isInRect((int)17, (int)(6 + i * 11), (int)80, (int)10, (int)(x - posX), (int)(y - posY))) {
                if (!(this.getLocationSafely(i + this.selectionOffset).getWriteProtected() && this.editingExisting || button != 0)) {
                    this.selected = i;
                    selectionChanged = true;
                }
                if (!(this.getLocationSafely(i + this.selectionOffset).getWriteProtected() && this.editingExisting || button != 1)) {
                    if (this.locations.isEmpty()) {
                        return;
                    }
                    if (!this.player.field_71075_bZ.field_75098_d && this.fuel <= 0) {
                        this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.teleporterOutOfFuel.txt", new Object[0]));
                    }
                    if (this.player.field_71075_bZ.field_75098_d || this.fuel > 0) {
                        if (!this.player.field_71075_bZ.field_75098_d) {
                            --this.fuel;
                        }
                        DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(8, i + this.selectionOffset, false));
                    }
                }
            }
            if (!GuiHelper.isInRect((int)99, (int)(8 + i * 11), (int)8, (int)7, (int)(x - posX), (int)(y - posY))) continue;
            this.getLocationSafely(i + this.selectionOffset).setWriteProtected(!this.getLocationSafely(i + this.selectionOffset).getWriteProtected());
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(3, i + this.selectionOffset, this.getLocationSafely(i + this.selectionOffset).getWriteProtected()));
        }
        if (selectionChanged) {
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(4, this.selected, false));
        }
        if (offsetChanged) {
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(5, this.selectionOffset, false));
        }
        this.updateButtons();
        super.func_73864_a(x, y, button);
    }

    protected void func_146286_b(int p_146286_1_, int p_146286_2_, int p_146286_3_) {
        super.func_146286_b(p_146286_1_, p_146286_2_, p_146286_3_);
    }

    public void func_146274_d() {
        int i = Mouse.getEventDWheel();
        boolean offsetChanged = false;
        boolean selectionChanged = false;
        if (i < 0 && this.selectionOffset < this.maxOffset) {
            ++this.selectionOffset;
            offsetChanged = true;
            if (this.selected > 0) {
                --this.selected;
                selectionChanged = true;
            }
            this.updateButtons();
        }
        if (i > 0 && this.selectionOffset > 0) {
            --this.selectionOffset;
            offsetChanged = true;
            if (this.selected < 11) {
                ++this.selected;
                selectionChanged = true;
            }
            this.updateButtons();
        }
        if (selectionChanged) {
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(4, this.selected, false));
        }
        if (offsetChanged) {
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(5, this.selectionOffset, false));
        }
        super.func_146274_d();
    }

    private void updateButtons() {
        this.maxOffset = this.locations.size() > 12 ? this.locations.size() - 12 : 0;
        if (this.selectionOffset > this.maxOffset) {
            this.selectionOffset = this.maxOffset;
        }
        if (this.selected > this.locations.size() || this.selected < 0) {
            this.selected = Math.max(this.locations.size() - 1, 0);
        }
        if (this.selected + this.selectionOffset + 1 > this.locations.size()) {
            this.selected = 0;
            this.selectionOffset = 0;
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(4, this.selected, false));
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(5, this.selectionOffset, false));
        }
        if (this.locations.size() == 0 || this.getLocationSafely(this.selected + this.selectionOffset).getWriteProtected()) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
        } else {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = true;
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = true;
            ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = true;
        }
        if (this.editingNew) {
            ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = !this.textBeingEdited.func_146179_b().isEmpty();
            ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = StatCollector.func_74838_a((String)"button.de.commit.txt");
        }
        if (this.editingExisting) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !this.textBeingEdited.func_146179_b().isEmpty();
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = StatCollector.func_74838_a((String)"button.de.commit.txt");
        }
        if (this.locations.size() >= 100) {
            ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = false;
        } else if (!this.editingNew) {
            ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = true;
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int posX = (this.field_146294_l - 182) / 2;
        int posY = (this.field_146295_m - 141) / 2;
        this.field_146292_n.add(new GuiButtonAHeight(0, posX + 112, posY + 45, 66, 12, StatCollector.func_74838_a((String)"button.de.rename.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(1, posX + 112, posY + 58, 66, 12, StatCollector.func_74838_a((String)"button.de.setHere.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(2, posX + 112, posY + 71, 66, 12, StatCollector.func_74838_a((String)"button.de.remove.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(3, posX + 112, posY + 99, 33, 12, StatCollector.func_74838_a((String)"button.de.UP.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(4, posX + 112, posY + 112, 66, 12, StatCollector.func_74838_a((String)"button.de.addNew.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(5, posX + 112, posY + 125, 66, 12, StatCollector.func_74838_a((String)"button.de.addFuel.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(6, posX + 182 - 63, posY - 15, 60, 15, StatCollector.func_74838_a((String)"button.de.cancel.txt")));
        this.field_146292_n.add(new GuiButtonAHeight(7, posX + 112 + 34, posY + 99, 33, 12, StatCollector.func_74838_a((String)"button.de.DOWN.txt")));
        ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = false;
        this.textBeingEdited = new GuiTextField(this.field_146289_q, posX + 3, posY - 14, 115, 12);
        this.textBeingEdited.func_146193_g(-1);
        this.textBeingEdited.func_146204_h(-1);
        this.textBeingEdited.func_146185_a(true);
        this.textBeingEdited.func_146203_f(40);
        this.textBeingEdited.func_146189_e(false);
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) {
        Teleporter.TeleportLocation location;
        if (button.field_146127_k == 0 || button.field_146127_k == 6 && !this.editingNew) {
            if (button.field_146127_k == 6) {
                this.editingExisting = false;
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = StatCollector.func_74838_a((String)"button.de.rename.txt");
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = false;
                this.textBeingEdited.func_146189_e(false);
                ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = true;
                return;
            }
            if (!this.editingExisting) {
                this.editingExisting = true;
                this.textBeingEdited.func_146189_e(true);
                this.textBeingEdited.func_146180_a(this.getLocationSafely(this.selected + this.selectionOffset).getName());
                this.textBeingEdited.func_146199_i(0);
                this.textBeingEdited.func_146195_b(true);
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = true;
            } else if (!this.textBeingEdited.func_146179_b().isEmpty()) {
                this.getLocationSafely(this.selected + this.selectionOffset).setName(this.textBeingEdited.func_146179_b());
                location = new Teleporter.TeleportLocation();
                location.setName(this.textBeingEdited.func_146179_b());
                DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(location, 2, this.selected + this.selectionOffset));
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = StatCollector.func_74838_a((String)"button.de.rename.txt");
                this.editingExisting = false;
                this.textBeingEdited.func_146189_e(false);
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = false;
            }
        }
        if (button.field_146127_k == 1) {
            location = new Teleporter.TeleportLocation(this.player.field_70165_t, this.player.field_70163_u - 1.62, this.player.field_70161_v, this.player.field_71093_bK, this.player.field_70125_A, this.player.field_70177_z, this.getLocationSafely(this.selected + this.selectionOffset).getName());
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(location, 7, this.selected + this.selectionOffset));
            this.locations.set(this.selected + this.selectionOffset, location);
        }
        if (button.field_146127_k == 2) {
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(1, this.selected + this.selectionOffset, false));
            this.locations.remove(this.selected + this.selectionOffset);
            if (this.selectionOffset > 0) {
                --this.selectionOffset;
            }
            if (this.selected >= this.locations.size()) {
                --this.selected;
            }
        }
        if (button.field_146127_k == 3 || button.field_146127_k == 7) {
            Teleporter.TeleportLocation temp;
            if (button.field_146127_k == 3) {
                if (this.selected > 0) {
                    temp = this.getLocationSafely(this.selected + this.selectionOffset);
                    this.locations.set(this.selected + this.selectionOffset, this.getLocationSafely(this.selected + this.selectionOffset - 1));
                    this.locations.set(this.selected + this.selectionOffset - 1, temp);
                    --this.selected;
                }
            } else if (this.selected < Math.min(11, this.locations.size() - 1)) {
                temp = this.getLocationSafely(this.selected + this.selectionOffset);
                this.locations.set(this.selected + this.selectionOffset, this.getLocationSafely(this.selected + this.selectionOffset + 1));
                this.locations.set(this.selected + this.selectionOffset + 1, temp);
                ++this.selected;
            }
            DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(10, this.selected + this.selectionOffset, button.field_146127_k == 3));
        }
        if (button.field_146127_k == 4 || button.field_146127_k == 6 && !this.editingExisting) {
            if (button.field_146127_k == 6) {
                this.editingNew = false;
                ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = StatCollector.func_74838_a((String)"button.de.addNew.txt");
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = true;
                this.textBeingEdited.func_146189_e(false);
                return;
            }
            if (!this.editingNew) {
                this.editingNew = true;
                this.textBeingEdited.func_146189_e(true);
                this.textBeingEdited.func_146180_a("" + (int)this.player.field_70165_t + " " + (int)this.player.field_70163_u + " " + (int)this.player.field_70161_v);
                this.textBeingEdited.func_146199_i(0);
                this.textBeingEdited.func_146195_b(true);
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = true;
            } else if (!this.textBeingEdited.func_146179_b().isEmpty()) {
                this.addCurrentLocationToList(this.textBeingEdited.func_146179_b());
                ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = StatCollector.func_74838_a((String)"button.de.addNew.txt");
                this.editingNew = false;
                this.textBeingEdited.func_146189_e(false);
                ((GuiButton)this.field_146292_n.get((int)6)).field_146125_m = false;
            }
        }
        if (button.field_146127_k == 5) {
            if (this.player.field_71071_by.func_146028_b(Items.field_151079_bi)) {
                if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                    DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(6, 1, false));
                    this.fuel += ConfigHandler.teleporterUsesPerPearl;
                } else if (this.hasPearls(16)) {
                    DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(6, 16, false));
                    this.fuel += ConfigHandler.teleporterUsesPerPearl * 16;
                } else {
                    this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.teleporterOutOfPearls.txt", new Object[0]));
                }
            } else {
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.teleporterOutOfPearls.txt", new Object[0]));
            }
        }
        this.updateButtons();
    }

    public boolean hasPearls(int number) {
        int found = 0;
        for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = this.player.field_71071_by.func_70301_a(i);
            if (stack != null && stack.func_77969_a(new ItemStack(Items.field_151079_bi))) {
                found += stack.field_77994_a;
            }
            if (found < number) continue;
            return true;
        }
        return false;
    }

    public void func_73869_a(char key, int keyN) {
        if (this.textBeingEdited.func_146201_a(key, keyN)) {
            if (this.editingNew) {
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = !this.textBeingEdited.func_146179_b().isEmpty();
                ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = StatCollector.func_74838_a((String)"button.de.commit.txt");
            }
            if (this.editingExisting) {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !this.textBeingEdited.func_146179_b().isEmpty();
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = StatCollector.func_74838_a((String)"button.de.commit.txt");
            }
            return;
        }
        if (keyN == 28 && this.editingNew) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(4));
        }
        if (keyN == 28 && this.editingExisting) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        if (key == 'e' && (!this.editingExisting || !this.editingNew) || key == '\u001b') {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_73876_c() {
        if (this.player.func_71045_bC() == null || !this.player.func_71045_bC().func_77969_a(new ItemStack((Item)ModItems.teleporterMKII)) || this.player.field_70128_L) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
        if (this.tick % 5 == 0 && this.locations.size() > 0 && this.getLocationSafely(this.selected + this.selectionOffset).getDimensionName().equals("") && this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77973_b() == ModItems.teleporterMKII) {
            this.readDataFromItem(this.player.func_70694_bm());
        }
        ++this.tick;
        if (this.tick >= 10) {
            this.tick = 0;
            this.showFuelLight = !this.showFuelLight;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void readDataFromItem(ItemStack teleporter) {
        this.selected = ItemNBTHelper.getShort((ItemStack)teleporter, (String)"Selection", (short)0);
        this.selectionOffset = ItemNBTHelper.getInteger((ItemStack)teleporter, (String)"SelectionOffset", (int)0);
        this.fuel = ItemNBTHelper.getInteger((ItemStack)teleporter, (String)"Fuel", (int)0);
        this.locations.clear();
        NBTTagCompound compound = teleporter.func_77978_p();
        if (compound == null || compound.func_150295_c("Locations", 0) == null) {
            return;
        }
        NBTTagList list = (NBTTagList)compound.func_74781_a("Locations");
        if (list == null) {
            list = new NBTTagList();
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tagLocation = list.func_150305_b(i);
            Teleporter.TeleportLocation location = new Teleporter.TeleportLocation();
            location.readFromNBT(tagLocation);
            location.setWriteProtected(tagLocation.func_74767_n("WP"));
            this.locations.add(location);
        }
    }

    private void addCurrentLocationToList(String name) {
        Teleporter.TeleportLocation currentLocation = new Teleporter.TeleportLocation(this.player.field_70165_t, this.player.field_70163_u - 1.62, this.player.field_70161_v, this.player.field_71093_bK, this.player.field_70125_A, this.player.field_70177_z, name);
        DraconicEvolution.network.sendToServer((IMessage)new TeleporterPacket(currentLocation, 0));
        this.locations.add(currentLocation);
    }

    private Teleporter.TeleportLocation getLocationSafely(int index) {
        if (index < this.locations.size() && index >= 0) {
            return this.locations.get(index);
        }
        return new Teleporter.TeleportLocation(0.0, 0.0, 0.0, 0, 0.0f, 0.0f, EnumChatFormatting.DARK_RED + "[Index Error]");
    }
}

