/*
 * Decompiled with CFR 0.152.
 */
package emt.tile.solar;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.FMLCommonHandler;
import emt.client.gui.EMT_UITextures;
import emt.init.EMTBlocks;
import emt.tile.DefinitelyNotAIC2Source;
import emt.tile.TileEntityEMT;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_Block_Event;
import ic2.api.tile.IWrenchable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.VisNetHandler;

public class TileEntitySolarBase
extends TileEntityEMT
implements IInventory,
IWrenchable,
IHasWorldObjectAndCoords,
IEnergyConnected,
IBasicEnergyContainer,
ITileWithModularUI {
    private static final byte NOTHING = 0;
    private static final byte ORDO = 1;
    private static final byte PERDITIO = 2;
    private static final byte AER = 3;
    private static final byte TERRA = 4;
    private static final byte AQUA = 5;
    private static final byte IGNIS = 6;
    public String guiname;
    public boolean initialized;
    public boolean theSunIsVisible;
    public int tick = 10;
    public double output = 0.0;
    public long timer = 0L;
    public boolean dead = true;
    public double generating;
    public long mp_storage = 0L;
    public byte color = (byte)-1;
    public long storage;
    public long maxstorage = 0L;
    public boolean isActive = false;
    public DefinitelyNotAIC2Source energySource;
    public byte aspect = 0;
    protected boolean side;
    private int instance;
    private int meta;
    protected static NumberFormatMUI numberFormat = new NumberFormatMUI();

    public TileEntitySolarBase(double output, Aspect aspect, String guiname, int instance, int meta) {
        this.storage = 0L;
        long capacity = (long)(output * 1000.0);
        this.output = output;
        this.energySource = new DefinitelyNotAIC2Source(this, capacity, this.getTierFromCapacity(capacity));
        this.maxstorage = this.getEUCapacity();
        this.aspect = TileEntitySolarBase.getByteFromAspect(aspect);
        this.guiname = guiname;
        this.instance = instance;
        this.meta = meta;
    }

    public TileEntitySolarBase() {
    }

    private static byte getByteFromAspect(Aspect aspect) {
        if (aspect == null) {
            return 0;
        }
        if (aspect.equals(Aspect.ORDER)) {
            return 1;
        }
        if (aspect.equals(Aspect.ENTROPY)) {
            return 2;
        }
        if (aspect.equals(Aspect.AIR)) {
            return 3;
        }
        if (aspect.equals(Aspect.EARTH)) {
            return 4;
        }
        if (aspect.equals(Aspect.WATER)) {
            return 5;
        }
        if (aspect.equals(Aspect.FIRE)) {
            return 6;
        }
        return 0;
    }

    private int getTierFromCapacity(long capacity) {
        for (int i = 0; i < GT_Values.V.length; ++i) {
            if (capacity / 1000L >= GT_Values.V[i]) continue;
            return i;
        }
        return GT_Values.V.length - 1;
    }

    public void func_145845_h() {
        boolean bl = this.side = !this.field_145850_b.field_72995_K ? FMLCommonHandler.instance().getEffectiveSide().isServer() : FMLCommonHandler.instance().getSide().isServer();
        if (!this.side) {
            return;
        }
        this.dead = false;
        this.timer = 1L;
        this.inputintoGTnet();
        this.checkConditions();
        this.storage = this.energySource.getEnergyStored();
    }

    private float getMaxMulti() {
        switch (this.aspect) {
            case 1: 
            case 2: {
                return 2.0f;
            }
            case 3: 
            case 4: {
                return 3.0f;
            }
            case 5: 
            case 6: {
                return 6.0f;
            }
        }
        return 1.0f;
    }

    public float calc_multi() {
        switch (this.aspect) {
            case 1: {
                if (this.field_145850_b.func_72935_r()) {
                    return 2.0f;
                }
                return 0.75f;
            }
            case 2: {
                if (this.field_145850_b.func_72935_r()) {
                    return 0.75f;
                }
                return 2.0f;
            }
            case 3: {
                if (this.field_145848_d < 5) {
                    return 1.0f;
                }
                if (this.field_145848_d > 220) {
                    return 3.0f;
                }
                return (float)(0.9534883720930233 + 0.009302325581395349 * (double)this.field_145848_d);
            }
            case 4: {
                if (this.field_145848_d < 5) {
                    return 3.0f;
                }
                if (this.field_145848_d > 220) {
                    return 1.0f;
                }
                return (float)(-0.009302325581395349 * (double)this.field_145848_d + 3.046511627906977);
            }
            case 5: {
                if (this.field_145850_b.func_72911_I()) {
                    return 6.0f;
                }
                if (this.field_145850_b.func_72896_J()) {
                    return 3.0f;
                }
                if (!this.field_145850_b.func_72911_I() && !this.field_145850_b.func_72896_J() && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e).equals(Blocks.field_150355_j)) {
                    return 2.0f;
                }
                return 1.0f;
            }
            case 6: {
                float mult = 1.0f;
                if (VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Aspect)Aspect.FIRE, (int)10) >= 10) {
                    mult *= 3.0f;
                }
                if (this.field_145850_b.field_73011_w.field_76574_g == -1) {
                    mult *= 2.0f;
                }
                return mult;
            }
        }
        return 1.0f;
    }

    public double getSourceStored() {
        return this.energySource.getEnergyStored();
    }

    public void checkConditions() {
        switch (this.aspect) {
            case 6: {
                boolean ignis;
                this.initialized = true;
                boolean bl = ignis = this.field_145850_b.field_73011_w.field_76574_g == -1 || this.theSunIsVisible;
                if (ignis) {
                    this.isActive = true;
                    if (this.side) {
                        this.generating = this.output * (double)this.calc_multi();
                        this.energySource.addEnergy(this.output * (double)this.calc_multi());
                    }
                } else {
                    this.isActive = false;
                    this.generating = 0.0;
                }
                if (--this.tick != 0) break;
                this.updateSunState();
                this.tick = 64;
                break;
            }
            default: {
                this.initialized = true;
                if (--this.tick == 0) {
                    this.updateSunState();
                    this.tick = 64;
                }
                this.createEnergy();
            }
        }
    }

    public void createEnergy() {
        switch (this.aspect) {
            case 1: 
            case 2: {
                if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I()) {
                    this.isActive = true;
                    if (!this.side) break;
                    this.energySource.addEnergy(this.output * (double)this.calc_multi());
                    this.generating = this.output * (double)this.calc_multi();
                    break;
                }
                this.isActive = false;
                this.generating = 0.0;
                break;
            }
            case 5: {
                if (this.theSunIsVisible || this.calc_multi() > 1.0f && this.field_145850_b.func_72935_r() || this.calc_multi() == 6.0f) {
                    this.isActive = true;
                    if (!this.side) break;
                    this.generating = this.output * (double)this.calc_multi();
                    this.energySource.addEnergy(this.output * (double)this.calc_multi());
                    break;
                }
                this.isActive = false;
                this.generating = 0.0;
                break;
            }
            default: {
                if (this.theSunIsVisible) {
                    this.isActive = true;
                    if (!this.side) break;
                    this.energySource.addEnergy(this.output * (double)this.calc_multi());
                    this.generating = this.output * (double)this.calc_multi();
                    break;
                }
                this.isActive = false;
                this.generating = 0.0;
            }
        }
    }

    public void updateSunState() {
        boolean isRaining = this.aspect != 5 && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.theSunIsVisible = this.field_145850_b.func_72935_r() && !isRaining && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74772_a("storage", this.energySource.getEnergyStored());
        NBTTagCompound subtag = new NBTTagCompound();
        subtag.func_74768_a("instance", this.instance);
        subtag.func_74768_a("meta", this.meta);
        subtag.func_74778_a("guiname", this.guiname);
        subtag.func_74774_a("aspect", this.aspect);
        subtag.func_74780_a("Output", this.output);
        nbttagcompound.func_74782_a("solarstats", (NBTBase)subtag);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagCompound subtag = nbttagcompound.func_74775_l("solarstats");
        this.instance = subtag.func_74762_e("instance");
        this.meta = subtag.func_74762_e("meta");
        this.guiname = subtag.func_74779_i("guiname");
        this.aspect = subtag.func_74771_c("aspect");
        this.output = subtag.func_74769_h("Output");
        long capacity = (long)(this.output * 1000.0);
        this.energySource = new DefinitelyNotAIC2Source(this, capacity, this.getTierFromCapacity(capacity));
        this.maxstorage = this.getEUCapacity();
        this.energySource.setEnergyStored(nbttagcompound.func_74763_f("storage"));
        this.storage = this.energySource.getEnergyStored();
        this.mp_storage = this.storage / 1000L;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return this.guiname;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int gaugeEnergyScaled(long i) {
        return (int)(this.mp_storage * 1000L * i / this.maxstorage);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short facing) {
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(EMTBlocks.solars[this.instance], 1, this.meta);
    }

    public void inputintoGTnet() {
        if (!this.side) {
            return;
        }
        if (this.isUniversalEnergyStored(this.getOutputVoltage() * this.getOutputAmperage())) {
            long tEU = IEnergyConnected.Util.emitEnergyToNetwork((long)this.getOutputVoltage(), (long)this.getOutputAmperage(), (IEnergyConnected)this);
            this.drainEnergyUnits(ForgeDirection.DOWN, this.getOutputVoltage(), tEU);
        }
    }

    public byte getColorization() {
        return this.color;
    }

    public byte setColorization(byte aColor) {
        this.color = aColor;
        return this.color;
    }

    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return aEnergyAmount < this.energySource.getEnergyStored();
    }

    public long getUniversalEnergyStored() {
        return this.energySource.getEnergyStored();
    }

    public long getUniversalEnergyCapacity() {
        return (long)this.energySource.getCapacity();
    }

    public long[] calculateMaxVoltAmp() {
        long generating;
        long[] voltAmp = new long[]{this.getOutputVoltage(), (generating = (long)Math.floor(this.output * (double)this.getMaxMulti())) <= GT_Values.V[this.energySource.getSourceTier()] ? 1L : ((double)(generating % GT_Values.V[this.energySource.getSourceTier()]) == 0.0 ? generating / GT_Values.V[this.energySource.getSourceTier()] : 1L + generating / GT_Values.V[this.energySource.getSourceTier()])};
        return voltAmp;
    }

    public long getOutputAmperage() {
        return this.calculateMaxVoltAmp()[1];
    }

    public long getOutputVoltage() {
        return GT_Values.V[this.energySource.getSourceTier()];
    }

    public long getInputAmperage() {
        return 0L;
    }

    public long getInputVoltage() {
        return 0L;
    }

    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.energySource.getEnergyStored() > aEnergy) {
            this.energySource.drawEnergy(aEnergy);
            this.storage = this.energySource.getEnergyStored();
            return true;
        }
        return false;
    }

    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return this.decreaseStoredEnergyUnits(aVoltage * aAmperage, this.energySource.getEnergyStored() > aVoltage * aAmperage);
    }

    public long getAverageElectricInput() {
        return 0L;
    }

    public long getAverageElectricOutput() {
        return 0L;
    }

    public long getStoredEU() {
        return this.energySource.getEnergyStored();
    }

    public long getEUCapacity() {
        return (long)this.energySource.getCapacity();
    }

    public long getStoredSteam() {
        return 0L;
    }

    public long getSteamCapacity() {
        return 0L;
    }

    public boolean increaseStoredSteam(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return 0L;
    }

    public boolean inputEnergyFrom(ForgeDirection side) {
        return false;
    }

    public boolean outputsEnergyTo(ForgeDirection side) {
        return true;
    }

    public boolean energyStateReady() {
        return false;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getXCoord() {
        return this.field_145851_c;
    }

    public short getYCoord() {
        return (short)this.field_145848_d;
    }

    public int getZCoord() {
        return this.field_145849_e;
    }

    public boolean isServerSide() {
        return this.side;
    }

    public boolean isClientSide() {
        return this.side;
    }

    public int getRandomNumber(int aRange) {
        return this.field_145850_b.field_73012_v.nextInt(aRange);
    }

    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    public TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147438_o(aX + this.field_145851_c, aY + this.field_145848_d, aZ + this.field_145849_e);
    }

    public TileEntity getTileEntityAtSide(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return null;
        }
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        return this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
    }

    public TileEntity getTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        if (aDistance == 1) {
            return this.getTileEntityAtSide(side);
        }
        return this.getTileEntity(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public IInventory getIInventory(int aX, int aY, int aZ) {
        return null;
    }

    public IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        return null;
    }

    public IInventory getIInventoryAtSide(ForgeDirection side) {
        return null;
    }

    public IInventory getIInventoryAtSideAndDistance(ForgeDirection side, int aDistance) {
        return null;
    }

    public IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        return null;
    }

    public IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        return null;
    }

    public IFluidHandler getITankContainerAtSide(ForgeDirection side) {
        return null;
    }

    public IFluidHandler getITankContainerAtSideAndDistance(ForgeDirection side, int aDistance) {
        return null;
    }

    public IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    public IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        return this.getIGregTechTileEntity(aX + this.field_145851_c, aY + this.field_145848_d, aZ + this.field_145849_e);
    }

    public IGregTechTileEntity getIGregTechTileEntityAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    public IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return (IGregTechTileEntity)tTileEntity;
        }
        return null;
    }

    public Block getBlock(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    public Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public Block getBlockAtSide(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return null;
        }
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        return this.field_145850_b.func_147439_a(tX, (int)tY, tZ);
    }

    public Block getBlockAtSideAndDistance(ForgeDirection side, int aDistance) {
        if (aDistance == 1) {
            return this.getBlockAtSide(side);
        }
        return this.getBlock(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public byte getMetaID(int aX, int aY, int aZ) {
        return (byte)this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    public byte getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public byte getMetaIDAtSide(ForgeDirection side) {
        int tX = this.getOffsetX(side, 1);
        short tY = this.getOffsetY(side, 1);
        int tZ = this.getOffsetZ(side, 1);
        return (byte)this.field_145850_b.func_72805_g(tX, (int)tY, tZ);
    }

    public byte getMetaIDAtSideAndDistance(ForgeDirection side, int aDistance) {
        if (aDistance == 1) {
            return this.getMetaIDAtSide(side);
        }
        return this.getMetaID(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public byte getLightLevel(int aX, int aY, int aZ) {
        return 0;
    }

    public byte getLightLevelOffset(int aX, int aY, int aZ) {
        return 0;
    }

    public byte getLightLevelAtSide(ForgeDirection side) {
        return 0;
    }

    public byte getLightLevelAtSideAndDistance(ForgeDirection side, int aDistance) {
        return 0;
    }

    public boolean getOpacity(int aX, int aY, int aZ) {
        return false;
    }

    public boolean getOpacityOffset(int aX, int aY, int aZ) {
        return false;
    }

    public boolean getOpacityAtSide(ForgeDirection side) {
        return false;
    }

    public boolean getOpacityAtSideAndDistance(ForgeDirection side, int aDistance) {
        return false;
    }

    public boolean getSky(int aX, int aY, int aZ) {
        boolean sky = true;
        do {
            if (this.field_145850_b.func_147439_a(aX, ++aY, aZ).func_149688_o().equals(Material.field_151579_a)) continue;
            sky = false;
        } while (sky && aY < 256);
        return sky;
    }

    public boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(aX + this.field_145851_c, aY + this.field_145848_d, aZ + this.field_145849_e);
    }

    public boolean getSkyAtSide(ForgeDirection side) {
        return false;
    }

    public boolean getSkyAtSideAndDistance(ForgeDirection side, int aDistance) {
        return false;
    }

    public boolean getAir(int aX, int aY, int aZ) {
        return this.field_145850_b.func_147439_a(aX, aY, aZ).equals(Blocks.field_150350_a);
    }

    public boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public boolean getAirAtSide(ForgeDirection side) {
        return this.getAirAtSideAndDistance(side, 1);
    }

    public boolean getAirAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getAir(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    public BiomeGenBase getBiome() {
        return this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
    }

    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    public int getOffsetX(ForgeDirection side, int aMultiplier) {
        return this.field_145851_c + side.offsetX * aMultiplier;
    }

    public short getOffsetY(ForgeDirection side, int aMultiplier) {
        return (short)(this.field_145848_d + side.offsetY * aMultiplier);
    }

    public int getOffsetZ(ForgeDirection side, int aMultiplier) {
        return this.field_145849_e + side.offsetZ * aMultiplier;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void sendBlockEvent(byte aID, byte aValue) {
        GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, (GT_Packet)new GT_Packet_Block_Event(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, aID, aValue), this.field_145851_c, this.field_145849_e);
    }

    public long getTimer() {
        return this.timer;
    }

    public void setLightValue(byte aLightValue) {
    }

    public boolean isInvalidTileEntity() {
        return this.field_145846_f;
    }

    public boolean outputsEnergyTo(ForgeDirection b, boolean b1) {
        return true;
    }

    public boolean inputEnergyFrom(ForgeDirection b, boolean b1) {
        return false;
    }

    public ModularWindow createWindow(UIBuildContext buildContext) {
        ModularWindow.Builder builder = ModularWindow.builder((int)176, (int)107);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget(new Text(this.func_145825_b()).color(6618118).shadow()).setPos(9, 9))).widget(new ProgressBar().setTexture(EMT_UITextures.PICTURE_GAUGE_EMPTY_25, EMT_UITextures.PICTURE_GAUGE_SOLAR, 25).setProgress(() -> Float.valueOf((float)this.storage / (float)this.maxstorage)).setSynced(false, false).setPos(9, 24).setSize(25, 11))).widget(new ProgressBar().setTexture(EMT_UITextures.PICTURE_GAUGE_EMPTY_11, EMT_UITextures.PICTURE_SOLAR_INDICATOR, 11).setProgress(() -> Float.valueOf(this.generating > 9.0 ? 1.0f : 0.0f)).setSynced(false, false).setPos(9, 43).setSize(11, 11))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"emt.Storage") + " " + numberFormat.formatWithSuffix(this.storage) + "/" + numberFormat.formatWithSuffix(this.maxstorage) + " EU").setDefaultColor(0).setPos(36, 22))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.storage, val -> {
            this.storage = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"emt.Generating") + " " + numberFormat.formatWithSuffix((long)this.generating) + " EU/t").setDefaultColor(0).setPos(36, 35))).widget((Widget)new FakeSyncWidget.DoubleSyncer(() -> this.generating, val -> {
            this.generating = val;
        }));
        return builder.build();
    }
}

