/*
 * Decompiled with CFR 0.152.
 */
package emt.item.armor.boots;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.item.armor.boots.ItemElectricBootsTraveller;
import emt.util.EMTConfigHandler;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

@Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech_nh")
public class ItemNanoBootsTraveller
extends ItemElectricBootsTraveller
implements IHazardProtector {
    public ItemNanoBootsTraveller(ItemArmor.ArmorMaterial material, int par3, int par4) {
        super(material, par3, par4);
        this.maxCharge = 1000000;
        this.speedBonus = (float)EMTConfigHandler.nanoBootsSpeed;
        this.jumpBonus = (float)EMTConfigHandler.nanoBootsJump;
        this.visDiscount = 4;
        this.transferLimit = 1600.0;
        this.energyPerDamage = 5000;
    }

    @Override
    public float getMaxHealthyDropDist() {
        return (float)EMTConfigHandler.nanoBootsMaxDrop;
    }

    @Override
    public float getMinimumDropDist() {
        return (float)EMTConfigHandler.nanoBootsMinDrop;
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("emt:armor/boots_nano");
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "emt:textures/models/nanobootstravel.png";
    }

    @Optional.Method(modid="gregtech_nh")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return true;
    }
}

