/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPoweredTile;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPoweredMachineEntity
extends AbstractMachineEntity
implements IInternalPoweredTile {
    private Capacitors capacitorType = Capacitors.BASIC_CAPACITOR;
    private ICapacitor capacitor;
    private int storedEnergyRF;
    protected float lastSyncPowerStored;
    private static final String CAPACITOR_TAG_STRING = "internalCapacitor";

    protected AbstractPoweredMachineEntity(SlotDefinition slotDefinition) {
        super(slotDefinition);
        this.capacitor = Capacitors.BASIC_CAPACITOR.capacitor;
        this.storedEnergyRF = 0;
        this.lastSyncPowerStored = -1.0f;
        this.setCapacitor(Capacitors.BASIC_CAPACITOR);
    }

    public void init() {
        super.init();
        this.onCapacitorTypeChange();
    }

    @Override
    public void doUpdate() {
        boolean powerChanged;
        super.doUpdate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != (float)this.storedEnergyRF && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.storedEnergyRF;
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return !this.isSideDisabled(from.ordinal());
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        if (this.isSideDisabled(dir.ordinal())) {
            return 0;
        }
        return this.getCapacitor().getMaxEnergyReceived();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.getCapacitor().getMaxEnergyStored();
    }

    @Override
    public void setEnergyStored(int stored) {
        this.storedEnergyRF = MathHelper.func_76125_a((int)stored, (int)0, (int)this.getMaxEnergyStored());
    }

    @Override
    public int getEnergyStored() {
        return this.storedEnergyRF;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public boolean hasPower() {
        return this.storedEnergyRF > 0;
    }

    public Capacitors getCapacitorType() {
        return this.capacitorType;
    }

    public ICapacitor getCapacitor() {
        ItemStack contents;
        if (this.capacitor != null) {
            return this.capacitor;
        }
        if (this.capacitorType == Capacitors.TOTEMIC_CAPACITOR && (contents = this.inventory[this.slotDefinition.minUpgradeSlot]) != null && contents.func_77973_b() == EnderIO.itemBasicCapacitor) {
            return EnderIO.itemBasicCapacitor.getCapacitor(contents);
        }
        return this.capacitorType.capacitor;
    }

    public int getEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp((int)Math.round((float)scale * ((float)this.storedEnergyRF / (float)this.getMaxEnergyStored())), (int)0, (int)scale);
    }

    protected void setCapacitor(ICapacitor capacitor) {
        this.capacitor = capacitor;
        this.setEnergyStored(this.getEnergyStored());
    }

    public void setCapacitor(Capacitors capacitorType) {
        this.capacitorType = capacitorType;
        if (capacitorType == Capacitors.TOTEMIC_CAPACITOR) {
            ItemStack contents = this.inventory[this.slotDefinition.minUpgradeSlot];
            if (contents != null && contents.func_77973_b() == EnderIO.itemBasicCapacitor) {
                this.setCapacitor(EnderIO.itemBasicCapacitor.getCapacitor(contents));
            }
        } else {
            this.capacitor = capacitorType.capacitor;
        }
        this.onCapacitorTypeChange();
        this.setEnergyStored(this.getEnergyStored());
        this.forceClientUpdate = true;
    }

    public void onCapacitorTypeChange() {
    }

    public int getPowerUsePerTick() {
        return this.getCapacitor().getMaxEnergyExtracted();
    }

    @Override
    public void func_70299_a(int slot, ItemStack contents) {
        super.func_70299_a(slot, contents);
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    @Override
    public ItemStack func_70298_a(int fromSlot, int amount) {
        ItemStack res = super.func_70298_a(fromSlot, amount);
        if (this.slotDefinition.isUpgradeSlot(fromSlot)) {
            this.updateCapacitorFromSlot();
        }
        return res;
    }

    private void updateCapacitorFromSlot() {
        if (this.slotDefinition.getNumUpgradeSlots() <= 0) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
            return;
        }
        ItemStack contents = this.inventory[this.slotDefinition.minUpgradeSlot];
        if (contents == null || contents.func_77973_b() != EnderIO.itemBasicCapacitor) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
        } else {
            this.setCapacitor(Capacitors.values()[contents.func_77960_j()]);
        }
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.handleCapacitorLoading(nbtRoot);
        this.handleStoredEnergyLoading(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        nbtRoot.func_74768_a("storedEnergyRF", this.storedEnergyRF);
        nbtRoot.func_74777_a("capacitorType", (short)this.capacitorType.ordinal());
        this.writeCap(nbtRoot);
    }

    private void writeCap(NBTTagCompound nbtRoot) {
        NBTTagCompound cap = new NBTTagCompound();
        cap.func_74768_a("MaxEnergyStored", this.capacitor.getMaxEnergyStored());
        cap.func_74768_a("MaxEnergyExtracted", this.capacitor.getMaxEnergyExtracted());
        cap.func_74768_a("MaxEnergyReceived", this.capacitor.getMaxEnergyReceived());
        cap.func_74768_a("Tier", this.capacitor.getTier());
        nbtRoot.func_74782_a(CAPACITOR_TAG_STRING, (NBTBase)cap);
    }

    private void readCap(NBTTagCompound nbtRoot) {
        NBTTagCompound cap = nbtRoot.func_74775_l(CAPACITOR_TAG_STRING);
        this.setCapacitor(new BasicCapacitor(cap.func_74762_e("Tier"), cap.func_74762_e("MaxEnergyReceived"), cap.func_74762_e("MaxEnergyStored"), cap.func_74762_e("MaxEnergyExtracted")));
    }

    private void handleCapacitorLoading(NBTTagCompound nbtRoot) {
        if (nbtRoot.func_74764_b(CAPACITOR_TAG_STRING)) {
            this.readCap(nbtRoot);
        } else {
            this.setCapacitor(Capacitors.values()[nbtRoot.func_74765_d("capacitorType")]);
        }
    }

    private void handleStoredEnergyLoading(NBTTagCompound nbtRoot) {
        int energy;
        if (nbtRoot.func_74764_b("storedEnergy")) {
            float storedEnergyMJ = nbtRoot.func_74760_g("storedEnergy");
            energy = (int)(storedEnergyMJ * 10.0f);
        } else {
            energy = nbtRoot.func_74762_e("storedEnergyRF");
        }
        this.setEnergyStored(energy);
    }
}

