/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDarkSteelAxe
extends ItemAxe
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem {
    protected int logOreId = -1;
    protected final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();
    protected String name;

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() instanceof ItemDarkSteelAxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        if (!ItemDarkSteelAxe.isEquipped(player)) {
            return 0;
        }
        return EnergyUpgrade.getEnergyStored(player.func_71045_bC());
    }

    public static ItemDarkSteelAxe create() {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected ItemDarkSteelAxe() {
        this("darkSteel", ItemDarkSteelSword.MATERIAL);
    }

    protected ItemDarkSteelAxe(String name, Item.ToolMaterial mat) {
        super(mat);
        this.name = name;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = name + "_axe";
        this.func_77655_b(str);
        this.func_111206_d(EnderIO.DOMAIN + ":" + str);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        par3List.add(is);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        int blockMetadata;
        Block block;
        if (!player.field_70170_p.field_72995_K && player.func_70093_af() && this.isLog(block = player.field_70170_p.func_147439_a(X, Y, Z), blockMetadata = player.field_70170_p.func_72805_g(X, Y, Z))) {
            int powerStored = EnergyUpgrade.getEnergyStored(itemstack);
            TreeHarvestUtil harvester = new TreeHarvestUtil();
            HarvestResult res = new HarvestResult();
            BlockCoord bc = new BlockCoord(X, Y, Z);
            harvester.harvest(player.field_70170_p, bc, res);
            ArrayList<BlockCoord> sortedTargets = new ArrayList<BlockCoord>(res.getHarvestedBlocks());
            this.harvestComparator.refPoint = bc;
            Collections.sort(sortedTargets, this.harvestComparator);
            int maxBlocks = powerStored / Config.darkSteelAxePowerUsePerDamagePointMultiHarvest;
            int numUsedPower = 0;
            for (int i = 0; numUsedPower < maxBlocks && i < sortedTargets.size(); ++i) {
                if (!this.doMultiHarvest(player, player.field_70170_p, (BlockCoord)sortedTargets.get(i), block, blockMetadata % 4)) continue;
                ++numUsedPower;
            }
            return numUsedPower != 0;
        }
        return false;
    }

    private boolean doMultiHarvest(EntityPlayer player, World worldObj, BlockCoord bc, Block refBlock, int refMeta) {
        Block block = worldObj.func_147439_a(bc.x, bc.y, bc.z);
        int meta = worldObj.func_72805_g(bc.x, bc.y, bc.z);
        ItemStack held = player.func_71045_bC();
        ArrayList itemDrops = block.getDrops(worldObj, bc.x, bc.y, bc.z, meta, 0);
        float chance = ForgeEventFactory.fireBlockHarvesting((ArrayList)itemDrops, (World)worldObj, (Block)refBlock, (int)bc.x, (int)bc.y, (int)bc.z, (int)refMeta, (int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held), (float)1.0f, (EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)held) != 0 ? 1 : 0) != 0, (EntityPlayer)player);
        worldObj.func_147468_f(bc.x, bc.y, bc.z);
        boolean usedPower = false;
        if (itemDrops != null) {
            for (ItemStack stack : itemDrops) {
                if (!(worldObj.field_73012_v.nextFloat() <= chance)) continue;
                worldObj.func_72838_d((Entity)new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
                if (TreeHarvestUtil.canDropApples(block, meta)) {
                    if (worldObj.field_73012_v.nextInt(200) != 0) continue;
                    worldObj.func_72838_d((Entity)new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, new ItemStack(Items.field_151034_e)));
                    continue;
                }
                if (block != refBlock) continue;
                this.extractEnergy(held, Config.darkSteelAxePowerUsePerDamagePointMultiHarvest, false);
                usedPower = true;
            }
        }
        return usedPower;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if (evt.entityPlayer.func_70093_af() && ItemDarkSteelAxe.isEquippedAndPowered(evt.entityPlayer, Config.darkSteelAxePowerUsePerDamagePointMultiHarvest) && this.isLog(evt.block, evt.metadata)) {
            evt.newSpeed = evt.originalSpeed / Config.darkSteelAxeSpeedPenaltyMultiHarvest;
        }
        if (ItemDarkSteelAxe.isEquipped(evt.entityPlayer) && evt.block.func_149688_o() == Material.field_151584_j) {
            evt.newSpeed = 6.0f;
        }
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (world.field_72995_K) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, x, y, z, side, par8, par9, par10);
        }
        return false;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelAxePowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelAxeEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.func_77998_b();
        }
        return super.getDigSpeed(stack, block, meta);
    }

    private boolean isLog(Block block, int meta) {
        if (this.logOreId == -1) {
            this.logOreId = OreDictionary.getOreID((String)"logWood");
        }
        int targetOreId = OreDictionary.getOreID((ItemStack)new ItemStack(block, 1, meta));
        int workAroundId = OreDictionary.getOreID((ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
        return targetOreId == this.logOreId || workAroundId == this.logOreId;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnderIO.lang.localize("item." + this.name + "_axe.tooltip.multiHarvest"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelAxeEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item." + this.name + "_pickaxe.tooltip.effPowered"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockCoord> {
        BlockCoord refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockCoord arg0, BlockCoord arg1) {
            int d1 = this.refPoint.getDistSq(arg0);
            int d2 = this.refPoint.getDistSq(arg1);
            return MultiHarvestComparator.compare(d1, d1);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

