/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.Vector2f;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offsets;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;

public class RoundedSegmentRenderer {
    private static final int NUM_VERTICES = 16;
    private static Vertex[][] DIR_COORDS = new Vertex[ForgeDirection.VALID_DIRECTIONS.length][];
    private static Vertex[][] DIR_STUB_COORDS = new Vertex[ForgeDirection.VALID_DIRECTIONS.length][];
    private static Vertex[][] DIR_STUB_CAPS = new Vertex[ForgeDirection.VALID_DIRECTIONS.length][];
    private static final Vector3d REF_TRANS = new Vector3d(0.5, 0.5, 0.5);

    private static void createDirectionSegments(Vertex[][] segments, double circ, double halfLength) {
        Vertex[] refCoords = RoundedSegmentRenderer.createUnitSectionQuads(16, -halfLength, halfLength);
        RoundedSegmentRenderer.createSegmentsForDirections(segments, circ, halfLength, refCoords);
    }

    private static void createCaps(Vertex[][] segments, double circ, double halfLength) {
        Vertex[] refCrossSection = RoundedSegmentRenderer.createUnitCrossSection(0.0, 0.0, halfLength, 16, 0);
        Vertex center = new Vertex(new Vector3d(0.0, 0.0, halfLength), new Vector3f(0.0f, 0.0f, 1.0f), new Vector2f(0.5f, 0.5f));
        Vertex[] refCoords = new Vertex[refCrossSection.length * 4];
        int index = 0;
        for (int i = 0; i < refCrossSection.length; ++i) {
            refCoords[index] = new Vertex(center);
            refCoords[index + 1] = new Vertex(refCrossSection[i]);
            int next = i + 1;
            if (next >= refCrossSection.length - 1) {
                next = 0;
            }
            refCoords[index + 2] = new Vertex(refCrossSection[next]);
            refCoords[index + 3] = new Vertex(center);
            index += 4;
        }
        RoundedSegmentRenderer.createSegmentsForDirections(segments, circ, halfLength, refCoords);
    }

    private static void createSegmentsForDirections(Vertex[][] segments, double circ, double halfLength, Vertex[] refCoords) {
        for (Vertex coord : refCoords) {
            coord.xyz.x *= circ;
            coord.xyz.y *= circ;
        }
        Matrix4d rotMat = new Matrix4d();
        rotMat.setIdentity();
        rotMat.setTranslation(REF_TRANS);
        segments[ForgeDirection.SOUTH.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.SOUTH, (double)halfLength));
        rotMat.makeRotationY(Math.PI);
        rotMat.setTranslation(REF_TRANS);
        segments[ForgeDirection.NORTH.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.NORTH, (double)halfLength));
        rotMat.makeRotationY(1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        segments[ForgeDirection.EAST.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.EAST, (double)halfLength));
        rotMat.makeRotationY(-1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        segments[ForgeDirection.WEST.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.WEST, (double)halfLength));
        rotMat.makeRotationX(-1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        segments[ForgeDirection.UP.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.UP, (double)halfLength));
        rotMat.makeRotationX(1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        segments[ForgeDirection.DOWN.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.DOWN, (double)halfLength));
    }

    private static Vertex[] xformCoords(Vertex[] refCoords, Matrix4d rotMat, Vector3d trans) {
        Vertex[] res = new Vertex[refCoords.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Vertex(refCoords[i]);
            res[i].transform(rotMat);
            res[i].translate(trans);
        }
        return res;
    }

    private static Vertex[] xformCoords(List<Vertex> refCoords, Matrix4d rotMat, Vector3d trans) {
        Vertex[] res = new Vertex[refCoords.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Vertex(refCoords.get(i));
            res[i].transform(rotMat);
            res[i].translate(trans);
        }
        return res;
    }

    public static Vertex[] createUnitCrossSection(double xOffset, double yOffset, double zOffset, int numCoords, int u) {
        Vertex[] crossSection = new Vertex[numCoords];
        double angle = 0.0;
        double inc = Math.PI * 2 / (double)(crossSection.length - 1);
        for (int i = 0; i < crossSection.length; ++i) {
            double x = Math.cos(angle) * 0.5;
            double y = Math.sin(angle) * 0.5;
            angle += inc;
            crossSection[i] = new Vertex();
            crossSection[i].setXYZ(xOffset + x, yOffset + y, zOffset);
            crossSection[i].setNormal(x, y, 0.0);
            crossSection[i].setUV((double)u, y + 0.5);
        }
        return crossSection;
    }

    public static void renderSegment(ForgeDirection dir, BoundingBox bounds, float minU, float maxU, float minV, float maxV, boolean isStub) {
        double v;
        double u;
        float uScale = maxU - minU;
        float vScale = maxV - minV;
        Vector3d offset = RoundedSegmentRenderer.calcOffset(dir, bounds);
        Tessellator tes = Tessellator.field_78398_a;
        Vertex[] coords = isStub ? DIR_STUB_COORDS[dir.ordinal()] : DIR_COORDS[dir.ordinal()];
        for (Vertex coord : coords) {
            u = minU + coord.uv.x * uScale;
            v = minV + coord.uv.y * vScale;
            tes.func_78375_b(coord.normal.x, coord.normal.y, coord.normal.z);
            tes.func_78374_a(offset.x + coord.xyz.x, offset.y + coord.xyz.y, offset.z + coord.xyz.z, u, v);
        }
        if (isStub) {
            for (Vertex coord : coords = DIR_STUB_CAPS[dir.ordinal()]) {
                u = minU + coord.uv.x * uScale;
                v = minV + coord.uv.y * vScale;
                tes.func_78375_b(coord.normal.x, coord.normal.y, coord.normal.z);
                tes.func_78374_a(offset.x + coord.xyz.x, offset.y + coord.xyz.y, offset.z + coord.xyz.z, u, v);
            }
        }
    }

    private static Vector3d calcOffset(ForgeDirection dir, BoundingBox bounds) {
        Vector3d res = new Vector3d();
        Vector3d center = bounds.getCenter();
        Offsets.Axis axis = Offsets.getAxisForDir(dir);
        if (axis == Offsets.Axis.X) {
            res.set(0.0, center.y - RoundedSegmentRenderer.REF_TRANS.y, center.z - RoundedSegmentRenderer.REF_TRANS.z);
        } else if (axis == Offsets.Axis.Y) {
            res.set(center.x - RoundedSegmentRenderer.REF_TRANS.x, 0.0, center.z - RoundedSegmentRenderer.REF_TRANS.z);
        } else if (axis == Offsets.Axis.Z) {
            res.set(center.x - RoundedSegmentRenderer.REF_TRANS.x, center.y - RoundedSegmentRenderer.REF_TRANS.y, 0.0);
        }
        return res;
    }

    public static Vertex[] createUnitSectionQuads(int numCoords, double minZ, double maxZ) {
        Vertex[] z0 = RoundedSegmentRenderer.createUnitCrossSection(0.0, 0.0, minZ, numCoords + 1, 0);
        Vertex[] z1 = RoundedSegmentRenderer.createUnitCrossSection(0.0, 0.0, maxZ, numCoords + 1, 1);
        Vertex[] result = new Vertex[numCoords * 4];
        for (int i = 0; i < numCoords; ++i) {
            int index = i * 4;
            result[index] = new Vertex(z0[i]);
            result[index + 1] = new Vertex(z0[i + 1]);
            result[index + 2] = new Vertex(z1[i + 1]);
            result[index + 3] = new Vertex(z1[i]);
        }
        return result;
    }

    static {
        double circ = (double)ConduitGeometryUtil.WIDTH * 0.7;
        double halfLength = 0.25;
        RoundedSegmentRenderer.createDirectionSegments(DIR_COORDS, circ, halfLength);
        halfLength = ConduitGeometryUtil.STUB_WIDTH / 2.0f + ConduitGeometryUtil.CORE_BOUNDS.sizeX() / 4.0f;
        RoundedSegmentRenderer.createDirectionSegments(DIR_STUB_COORDS, circ, halfLength);
        RoundedSegmentRenderer.createCaps(DIR_STUB_CAPS, circ, halfLength);
    }
}

