/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.util.ClientUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PacketFarmAction
implements IMessage,
IMessageHandler<PacketFarmAction, IMessage> {
    private static Random rand = new Random();
    private List<BlockCoord> coords;

    public PacketFarmAction() {
    }

    public PacketFarmAction(List<BlockCoord> coords) {
        this.coords = coords;
    }

    public PacketFarmAction(BlockCoord bc) {
        this.coords = new ArrayList<BlockCoord>(1);
        this.coords.add(bc);
    }

    public void toBytes(ByteBuf buffer) {
        int size = this.coords.size();
        buffer.writeInt(size);
        for (BlockCoord coord : this.coords) {
            buffer.writeInt(coord.x);
            buffer.writeInt(coord.y);
            buffer.writeInt(coord.z);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int size = buffer.readInt();
        this.coords = new ArrayList<BlockCoord>(size);
        for (int i = 0; i < size; ++i) {
            this.coords.add(new BlockCoord(buffer.readInt(), buffer.readInt(), buffer.readInt()));
        }
    }

    public IMessage onMessage(PacketFarmAction message, MessageContext ctx) {
        for (BlockCoord bc : message.coords) {
            for (int i = 0; i < 15; ++i) {
                ClientUtil.spawnFarmParcticles(rand, bc);
            }
        }
        return null;
    }
}

