/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.stirling;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.generator.stirling.GuiStirlingGenerator;
import crazypants.enderio.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.machine.generator.stirling.StirlingGeneratorContainer;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import crazypants.enderio.network.PacketHandler;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockStirlingGenerator
extends AbstractMachineBlock<TileEntityStirlingGenerator> {
    public static BlockStirlingGenerator create() {
        PacketHandler.INSTANCE.registerMessage(PacketBurnTime.class, PacketBurnTime.class, PacketHandler.nextID(), Side.CLIENT);
        BlockStirlingGenerator gen = new BlockStirlingGenerator();
        gen.init();
        return gen;
    }

    protected BlockStirlingGenerator() {
        super(ModObject.blockStirlingGenerator, TileEntityStirlingGenerator.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new StirlingGeneratorContainer(player.field_71071_by, (TileEntityStirlingGenerator)world.func_147438_o(x, y, z));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiStirlingGenerator(player.field_71071_by, (TileEntityStirlingGenerator)world.func_147438_o(x, y, z));
    }

    @Override
    protected int getGuiId() {
        return 3;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:stirlingGenFrontOn";
        }
        return "enderio:stirlingGenFrontOff";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityStirlingGenerator te = (TileEntityStirlingGenerator)world.func_147438_o(x, y, z);
        if (te != null && te.isActive()) {
            ForgeDirection front = ForgeDirection.values()[te.facing];
            for (int i = 0; i < 2; ++i) {
                double px = (double)x + 0.5 + (double)front.offsetX * 0.6;
                double pz = (double)z + 0.5 + (double)front.offsetZ * 0.6;
                double v = 0.05;
                double vx = 0.0;
                double vz = 0.0;
                if (front == ForgeDirection.NORTH || front == ForgeDirection.SOUTH) {
                    px += (double)world.field_73012_v.nextFloat() * 0.9 - 0.45;
                    vz += front == ForgeDirection.NORTH ? -v : v;
                } else {
                    pz += (double)world.field_73012_v.nextFloat() * 0.9 - 0.45;
                    vx += front == ForgeDirection.WEST ? -v : v;
                }
                world.func_72869_a("smoke", px, (double)y + 0.1, pz, vx, 0.0, vz);
            }
        }
    }
}

