/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.common.util.PlayerUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.util.UserIdent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileTravelAnchor
extends TileEntityEio
implements ITravelAccessable,
IPaintableTileEntity {
    private static final String KEY_SOURCE_BLOCK_ID = "sourceBlock";
    private static final String KEY_SOURCE_BLOCK_META = "sourceBlockMeta";
    private Block sourceBlock;
    private int sourceBlockMetadata;
    private ITravelAccessable.AccessMode accessMode = ITravelAccessable.AccessMode.PUBLIC;
    private ItemStack[] password = new ItemStack[5];
    private ItemStack itemLabel;
    private String label;
    @Nonnull
    private UserIdent owner = UserIdent.nobody;
    private List<UserIdent> authorisedUsers = new ArrayList<UserIdent>();

    @Override
    public boolean canBlockBeAccessed(EntityPlayer playerName) {
        if (this.accessMode == ITravelAccessable.AccessMode.PUBLIC) {
            return true;
        }
        return this.owner.equals(playerName.func_146103_bH()) || this.authorisedUsers.contains(playerName.func_146103_bH());
    }

    @Override
    public void clearAuthorisedUsers() {
        this.authorisedUsers.clear();
    }

    private boolean checkPassword(ItemStack[] pwd) {
        if (pwd == null || pwd.length != this.password.length) {
            return false;
        }
        for (int i = 0; i < pwd.length; ++i) {
            ItemStack pw = this.password[i];
            ItemStack tst = pwd[i];
            if (pw == null && tst != null) {
                return false;
            }
            if (pw == null || tst != null && ItemStack.func_77989_b((ItemStack)pw, (ItemStack)tst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getRequiresPassword(EntityPlayer playerName) {
        return this.getAccessMode() == ITravelAccessable.AccessMode.PROTECTED && !this.canUiBeAccessed(playerName) && !this.authorisedUsers.contains(PlayerUtil.getPlayerUUID((String)playerName.func_146103_bH().getName()));
    }

    @Override
    public boolean authoriseUser(EntityPlayer username, ItemStack[] password) {
        if (this.checkPassword(password)) {
            this.authorisedUsers.add(UserIdent.create(username.func_146103_bH()));
            return true;
        }
        return false;
    }

    @Override
    public boolean canUiBeAccessed(EntityPlayer playerName) {
        return this.owner.equals(playerName.func_146103_bH());
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        if (this.accessMode != ITravelAccessable.AccessMode.PRIVATE) {
            return true;
        }
        return this.owner.equals(playerName.func_146103_bH());
    }

    @Override
    public ITravelAccessable.AccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public void setAccessMode(ITravelAccessable.AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public ItemStack[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(ItemStack[] password) {
        this.password = password;
    }

    @Override
    public ItemStack getItemLabel() {
        return this.itemLabel;
    }

    @Override
    public void setItemLabel(ItemStack lableIcon) {
        this.itemLabel = lableIcon;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    @Deprecated
    public UUID getPlacedBy() {
        return this.owner.getUUID();
    }

    @Override
    @Nonnull
    public UserIdent getOwner() {
        return this.owner;
    }

    @Override
    public void setPlacedBy(EntityPlayer player) {
        this.owner = player != null ? UserIdent.create(player.func_146103_bH()) : UserIdent.nobody;
    }

    public boolean shouldUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return TravelSource.getMaxDistanceSq();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public Block getSourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public void setSourceBlock(Block sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    public int getSourceBlockMetadata() {
        return this.sourceBlockMetadata;
    }

    @Override
    public void setSourceBlockMetadata(int sourceBlockMetadata) {
        this.sourceBlockMetadata = sourceBlockMetadata;
    }

    protected void readCustomNBT(NBTTagCompound root) {
        this.accessMode = root.func_74764_b("accessMode") ? ITravelAccessable.AccessMode.values()[root.func_74765_d("accessMode")] : ITravelAccessable.AccessMode.PUBLIC;
        this.owner = root.func_74764_b("placedBy") ? UserIdent.create(root.func_74779_i("placedBy")) : UserIdent.readfromNbt(root, "owner");
        for (int i = 0; i < this.password.length; ++i) {
            if (root.func_74764_b("password" + i)) {
                NBTTagCompound stackRoot = (NBTTagCompound)root.func_74781_a("password" + i);
                this.password[i] = ItemStack.func_77949_a((NBTTagCompound)stackRoot);
                continue;
            }
            this.password[i] = null;
        }
        this.authorisedUsers.clear();
        if (root.func_74764_b("authorisedUsers")) {
            String userStr = root.func_74779_i("authorisedUsers");
            if (userStr != null && userStr.length() > 0) {
                String[] users;
                for (String user : users = userStr.split(",")) {
                    if (user == null || (user = user.trim()).length() <= 0) continue;
                    this.authorisedUsers.add(UserIdent.create(user));
                }
            }
        } else {
            int userIdx = 0;
            while (UserIdent.existsInNbt(root, "authorisedUser" + userIdx)) {
                UserIdent.readfromNbt(root, "authorisedUser" + userIdx);
                ++userIdx;
            }
        }
        if (root.func_74764_b("itemLabel")) {
            NBTTagCompound stackRoot = (NBTTagCompound)root.func_74781_a("itemLabel");
            this.itemLabel = ItemStack.func_77949_a((NBTTagCompound)stackRoot);
        } else {
            this.itemLabel = null;
        }
        String sourceBlockStr = root.func_74779_i(KEY_SOURCE_BLOCK_ID);
        this.sourceBlock = Block.func_149684_b((String)sourceBlockStr);
        this.sourceBlockMetadata = root.func_74762_e(KEY_SOURCE_BLOCK_META);
        this.label = root.func_74779_i("label");
        if (this.label == null || this.label.trim().length() == 0) {
            this.label = null;
        }
    }

    protected void writeCustomNBT(NBTTagCompound root) {
        root.func_74777_a("accessMode", (short)this.accessMode.ordinal());
        this.owner.saveToNbt(root, "owner");
        for (int i = 0; i < this.password.length; ++i) {
            ItemStack stack = this.password[i];
            if (stack == null) continue;
            NBTTagCompound stackRoot = new NBTTagCompound();
            stack.func_77955_b(stackRoot);
            root.func_74782_a("password" + i, (NBTBase)stackRoot);
        }
        int userIdx = 0;
        for (UserIdent user : this.authorisedUsers) {
            if (user == null) continue;
            user.saveToNbt(root, "authorisedUser" + userIdx);
            ++userIdx;
        }
        if (this.itemLabel != null) {
            NBTTagCompound labelRoot = new NBTTagCompound();
            this.itemLabel.func_77955_b(labelRoot);
            root.func_74782_a("itemLabel", (NBTBase)labelRoot);
        }
        if (this.sourceBlock != null) {
            root.func_74778_a(KEY_SOURCE_BLOCK_ID, Block.field_149771_c.func_148750_c((Object)this.sourceBlock));
        }
        root.func_74768_a(KEY_SOURCE_BLOCK_META, this.sourceBlockMetadata);
        if (this.label != null && this.label.trim().length() > 0) {
            root.func_74778_a("label", this.label);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }
}

