/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.client;

import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.machine.invpanel.client.ItemEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class ItemFilter {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s+");

    public abstract boolean matches(ItemEntry var1);

    public static ItemFilter parse(String filter, Locale locale, IItemFilter filterCard) {
        String[] parts;
        ArrayList<ItemFilter> list = new ArrayList<ItemFilter>();
        if (filterCard != null) {
            list.add(new CardFilter(filterCard));
        }
        for (String part : parts = SPLIT_PATTERN.split(filter)) {
            if (part.startsWith("@")) {
                if ((part = part.substring(1)).isEmpty()) continue;
                list.add(new ModFilter(part, locale));
                continue;
            }
            if (part.isEmpty()) continue;
            list.add(new NameFilter(part, locale));
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (ItemFilter)list.get(0);
        }
        return new AndFilter(list.toArray(new ItemFilter[list.size()]));
    }

    static class CardFilter
    extends ItemFilter {
        final IItemFilter filter;

        CardFilter(IItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(ItemEntry entry) {
            return this.filter.doesItemPassFilter(null, entry.makeItemStack());
        }
    }

    static class NameFilter
    extends ItemFilter {
        final String text;
        final Locale locale;

        NameFilter(String text, Locale locale) {
            this.text = text.toLowerCase(locale);
            this.locale = locale;
        }

        @Override
        public boolean matches(ItemEntry entry) {
            return entry.getLowercaseUnlocName(this.locale).contains(this.text);
        }

        public String toString() {
            return this.text;
        }
    }

    static class ModFilter
    extends ItemFilter {
        final String text;
        final Locale locale;

        ModFilter(String text, Locale locale) {
            this.text = text.toLowerCase(locale);
            this.locale = locale;
        }

        @Override
        public boolean matches(ItemEntry entry) {
            return entry.getModId().toLowerCase(this.locale).contains(this.text);
        }

        public String toString() {
            return "@" + this.text;
        }
    }

    static class AndFilter
    extends ItemFilter {
        final ItemFilter[] list;

        AndFilter(ItemFilter[] list) {
            this.list = list;
        }

        @Override
        public boolean matches(ItemEntry entry) {
            for (ItemFilter f : this.list) {
                if (f.matches(entry)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.deepToString(this.list);
        }
    }
}

