/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.waila;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.block.BlockDarkSteelAnvil;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.waila.IWailaInfoProvider;
import crazypants.enderio.waila.IWailaNBTProvider;
import crazypants.util.IFacade;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class WailaCompat
implements IWailaDataProvider {
    public static final WailaCompat INSTANCE = new WailaCompat();
    private static IWailaDataAccessor _accessor = null;

    public static void load(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, IFacade.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockDarkSteelAnvil.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, BlockEio.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, TileEntityEio.class);
        ConfigHandler.instance().addConfig("Ender IO", "facades.hidden", EnderIO.lang.localize("waila.config.hiddenfacades"));
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition pos = accessor.getPosition();
        if (config.getConfig("facades.hidden")) {
            if (accessor.getBlock() instanceof IFacade) {
                if (accessor.getTileEntity() instanceof IConduitBundle && ConduitUtil.isFacadeHidden((IConduitBundle)accessor.getTileEntity(), accessor.getPlayer())) {
                    return null;
                }
                IFacade bundle = (IFacade)accessor.getBlock();
                Block facade = bundle.getFacade((IBlockAccess)accessor.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, accessor.getSide().ordinal());
                if (facade != accessor.getBlock()) {
                    ItemStack ret = facade.getPickBlock(pos, (World)new WailaWorldWrapper(accessor.getWorld()), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, accessor.getPlayer());
                    return ret;
                }
            }
        } else if (accessor.getBlock() instanceof BlockDarkSteelAnvil) {
            return accessor.getBlock().getPickBlock(accessor.getPosition(), accessor.getWorld(), accessor.getPosition().field_72311_b, accessor.getPosition().field_72312_c, accessor.getPosition().field_72309_d, accessor.getPlayer());
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IInternalPoweredTile power;
        _accessor = accessor;
        EntityPlayer player = accessor.getPlayer();
        MovingObjectPosition pos = accessor.getPosition();
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        World world = accessor.getWorld();
        Block block = world.func_147439_a(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        Item item = Item.func_150898_a((Block)block);
        ((ITaggedList)currenttip).removeEntries((Object)"RFEnergyStorage");
        if (te instanceof IIoConfigurable && block == accessor.getBlock()) {
            IIoConfigurable machine = (IIoConfigurable)te;
            ForgeDirection side = accessor.getSide();
            IoMode mode = machine.getIoMode(side);
            currenttip.add(EnumChatFormatting.YELLOW + EnderIO.lang.localize("gui.machine.side", new Object[]{EnumChatFormatting.WHITE + EnderIO.lang.localize("gui.machine.side." + side.name().toLowerCase(Locale.US))}));
            if (!(te instanceof TileInventoryPanel)) {
                currenttip.add(EnumChatFormatting.YELLOW + EnderIO.lang.localize("gui.machine.ioMode", new Object[]{mode.colorLocalisedName()}));
            }
        }
        if (block instanceof IWailaInfoProvider) {
            IWailaInfoProvider info = (IWailaInfoProvider)block;
            if (block instanceof IAdvancedTooltipProvider) {
                int mask = info.getDefaultDisplayMask(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                boolean basic = (mask & 1) == 1;
                boolean common = (mask & 2) == 2;
                boolean detailed = (mask & 4) == 4;
                IAdvancedTooltipProvider adv = (IAdvancedTooltipProvider)block;
                if (common) {
                    adv.addCommonEntries(itemStack, player, currenttip, false);
                }
                if (SpecialTooltipHandler.showAdvancedTooltips() && detailed) {
                    adv.addDetailedEntries(itemStack, player, currenttip, false);
                } else if (detailed) {
                    SpecialTooltipHandler.addShowDetailsTooltip(currenttip);
                }
                if (!SpecialTooltipHandler.showAdvancedTooltips() && basic) {
                    adv.addBasicEntries(itemStack, player, currenttip, false);
                }
            } else if (block instanceof IResourceTooltipProvider) {
                SpecialTooltipHandler.INSTANCE.addInformation((IResourceTooltipProvider)block, itemStack, player, currenttip);
            }
            if (currenttip.size() > 0) {
                currenttip.add("");
            }
            info.getWailaInfo(currenttip, player, world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        } else if (block instanceof IAdvancedTooltipProvider) {
            SpecialTooltipHandler.INSTANCE.addInformation((IAdvancedTooltipProvider)block, itemStack, player, currenttip, false);
        } else if (item instanceof IAdvancedTooltipProvider) {
            SpecialTooltipHandler.INSTANCE.addInformation((IAdvancedTooltipProvider)item, itemStack, player, currenttip, false);
        } else if (block instanceof IResourceTooltipProvider) {
            SpecialTooltipHandler.INSTANCE.addInformation((IResourceTooltipProvider)block, itemStack, player, currenttip);
        }
        if (te instanceof IConduitBundle) {
            this.getWailaBodyConduitBundle(itemStack, currenttip);
        } else if (te instanceof IInternalPoweredTile && block == accessor.getBlock() && !(te instanceof TileCapBank) && (power = (IInternalPoweredTile)te).displayPower()) {
            if (currenttip.size() > 4) {
                currenttip.add("");
            }
            int stored = accessor.getNBTData().func_74762_e("storedEnergyRF");
            int max = accessor.getNBTData().func_74762_e("maxStoredRF");
            currenttip.add(String.format("%s%s%s / %s%s%s %s", EnumChatFormatting.WHITE, PowerDisplayUtil.formatPower(stored), EnumChatFormatting.RESET, EnumChatFormatting.WHITE, PowerDisplayUtil.formatPower(max), EnumChatFormatting.RESET, PowerDisplayUtil.abrevation()));
        }
        return currenttip;
    }

    private void getWailaBodyConduitBundle(ItemStack itemStack, List<String> currenttip) {
        NBTTagCompound nbtRoot;
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77973_b() == EnderIO.itemPowerConduit || itemStack.func_77973_b() == EnderIO.itemPowerConduitEndergy) {
            NBTTagCompound nbtRoot2 = _accessor.getNBTData();
            if (nbtRoot2.func_74764_b("storedEnergyRF")) {
                int stored = nbtRoot2.func_74762_e("storedEnergyRF");
                int max = nbtRoot2.func_74762_e("maxStoredRF");
                currenttip.add(String.format("%s%s%s / %s%s%s %s", EnumChatFormatting.WHITE, PowerDisplayUtil.formatPower(stored), EnumChatFormatting.RESET, EnumChatFormatting.WHITE, PowerDisplayUtil.formatPower(max), EnumChatFormatting.RESET, PowerDisplayUtil.abrevation()));
            }
        } else if (itemStack.func_77973_b() == EnderIO.itemLiquidConduit) {
            NBTTagCompound nbtRoot3 = _accessor.getNBTData();
            if (nbtRoot3.func_74764_b("fluidLocked") && nbtRoot3.func_74764_b("FluidName")) {
                boolean fluidTypeLocked = nbtRoot3.func_74767_n("fluidLocked");
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot3);
                String lockedStr = fluidTypeLocked ? EnderIO.lang.localize("itemLiquidConduit.lockedWaila") : "";
                String fluidName = fluid.getLocalizedName();
                int fluidAmount = fluid.amount;
                if (fluidAmount > 0) {
                    currenttip.add(String.format("%s%s%s%s %s%s%s %s", lockedStr, EnumChatFormatting.WHITE, fluidName, EnumChatFormatting.RESET, EnumChatFormatting.WHITE, PowerDisplayUtil.formatPower(fluidAmount), EnumChatFormatting.RESET, Fluids.MB()));
                } else if (fluidTypeLocked) {
                    currenttip.add(String.format("%s%s%s%s", lockedStr, EnumChatFormatting.WHITE, fluidName, EnumChatFormatting.RESET));
                }
            }
        } else if (itemStack.func_77973_b() == EnderIO.itemMEConduit && (nbtRoot = _accessor.getNBTData()).func_74764_b("isDense")) {
            boolean isDense = nbtRoot.func_74767_n("isDense");
            int channelsInUse = nbtRoot.func_74762_e("channelsInUse");
            currenttip.add(MessageFormat.format(EnderIO.lang.localize("itemMEConduit.channelsUsed"), channelsInUse, isDense ? 32 : 8));
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof IWailaNBTProvider) {
            ((IWailaNBTProvider)te).getData(tag);
        }
        if (te instanceof IConduitBundle) {
            IMEConduit mec;
            FluidStack fluid;
            AbstractTankConduit atc;
            IConduitBundle icb = (IConduitBundle)te;
            IPowerConduit pc = icb.getConduit(IPowerConduit.class);
            if (pc != null) {
                tag.func_74768_a("storedEnergyRF", pc.getEnergyStored());
                tag.func_74768_a("maxStoredRF", pc.getMaxEnergyStored());
            }
            if ((atc = icb.getConduit(AbstractTankConduit.class)) != null && (fluid = atc.getTank().getFluid()) != null) {
                tag.func_74757_a("fluidLocked", atc.isFluidTypeLocked());
                fluid.writeToNBT(tag);
            }
            if ((mec = icb.getConduit(IMEConduit.class)) != null) {
                tag.func_74768_a("channelsInUse", mec.getChannelsInUse());
                tag.func_74757_a("isDense", mec.isDense());
            }
        } else if (te instanceof IInternalPoweredTile) {
            IInternalPoweredTile ipte = (IInternalPoweredTile)te;
            tag.func_74768_a("storedEnergyRF", ipte.getEnergyStored());
            tag.func_74768_a("maxStoredRF", ipte.getMaxEnergyStored());
        }
        tag.func_74768_a("x", x);
        tag.func_74768_a("y", y);
        tag.func_74768_a("z", z);
        return tag;
    }

    public static NBTTagCompound getNBTData() {
        return _accessor.getNBTData();
    }

    private class WailaWorldWrapper
    extends World {
        private final World wrapped;

        private WailaWorldWrapper(World wrapped) {
            super(wrapped.func_72860_G(), wrapped.func_72912_H().func_76065_j(), wrapped.field_73011_w, new WorldSettings(wrapped.func_72912_H()), wrapped.field_72984_F);
            this.wrapped = wrapped;
            this.field_72995_K = wrapped.field_72995_K;
        }

        public Block func_147439_a(int x, int y, int z) {
            Block block = this.wrapped.func_147439_a(x, y, z);
            if (block instanceof IFacade) {
                return ((IFacade)block).getFacade((IBlockAccess)this.wrapped, x, y, z, -1);
            }
            return block;
        }

        public int func_72805_g(int x, int y, int z) {
            Block block = this.wrapped.func_147439_a(x, y, z);
            if (block instanceof IFacade) {
                return ((IFacade)block).getFacadeMetadata((IBlockAccess)this.wrapped, x, y, z, -1);
            }
            return this.wrapped.func_72805_g(x, y, z);
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            int meta = this.func_72805_g(x, y, z);
            Block block = this.func_147439_a(x, y, z);
            if (block == null || !block.hasTileEntity(meta)) {
                return null;
            }
            TileEntity te = block.createTileEntity((World)this, meta);
            if (te == null) {
                return null;
            }
            te.func_145834_a((World)this);
            te.field_145851_c = x;
            te.field_145848_d = y;
            te.field_145849_e = z;
            return te;
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        protected int func_152379_p() {
            return 0;
        }

        public Entity func_73045_a(int p_73045_1_) {
            return null;
        }
    }
}

