/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import io.netty.buffer.ByteBuf;

public class NetworkState {
    private final long energyStored;
    private final long maxEnergyStored;
    private final int maxIO;
    private final int maxInput;
    private final int maxOutput;
    private final RedstoneControlMode inputMode;
    private final RedstoneControlMode outputMode;
    private final BlockCoord invImplLoc;
    private final float averageInput;
    private final float averageOutput;

    public NetworkState(long energyStored, long maxEnergyStored, int maxIO, int maxInput, int maxOutput, RedstoneControlMode inputMode, RedstoneControlMode outputMode, BlockCoord invImplLoc, float averageInput, float averageOutput) {
        this.energyStored = energyStored;
        this.maxEnergyStored = maxEnergyStored;
        this.maxIO = maxIO;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.inputMode = inputMode;
        this.outputMode = outputMode;
        this.invImplLoc = invImplLoc;
        this.averageInput = averageInput;
        this.averageOutput = averageOutput;
    }

    public NetworkState(ICapBankNetwork network) {
        this.energyStored = network.getEnergyStoredL();
        this.maxEnergyStored = network.getMaxEnergyStoredL();
        this.maxIO = network.getMaxIO();
        this.maxInput = network.getMaxInput();
        this.maxOutput = network.getMaxOutput();
        this.inputMode = network.getInputControlMode();
        this.outputMode = network.getOutputControlMode();
        TileCapBank cb = network.getInventory().getCapBank();
        this.invImplLoc = cb != null ? cb.getLocation() : null;
        this.averageInput = network.getAverageInputPerTick();
        this.averageOutput = network.getAverageOutputPerTick();
    }

    public long getEnergyStored() {
        return this.energyStored;
    }

    public long getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public int getMaxIO() {
        return this.maxIO;
    }

    public RedstoneControlMode getInputMode() {
        return this.inputMode;
    }

    public RedstoneControlMode getOutputMode() {
        return this.outputMode;
    }

    public BlockCoord getInventoryImplLocation() {
        return this.invImplLoc;
    }

    public float getAverageInput() {
        return this.averageInput;
    }

    public float getAverageOutput() {
        return this.averageOutput;
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeLong(this.energyStored);
        buf.writeLong(this.maxEnergyStored);
        buf.writeInt(this.maxIO);
        buf.writeInt(this.maxInput);
        buf.writeInt(this.maxOutput);
        buf.writeShort(this.inputMode.ordinal());
        buf.writeShort(this.outputMode.ordinal());
        buf.writeBoolean(this.invImplLoc != null);
        if (this.invImplLoc != null) {
            this.invImplLoc.writeToBuf(buf);
        }
        buf.writeFloat(this.averageInput);
        buf.writeFloat(this.averageOutput);
    }

    public static NetworkState readFromBuf(ByteBuf buf) {
        return new NetworkState(buf.readLong(), buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt(), RedstoneControlMode.values()[buf.readShort()], RedstoneControlMode.values()[buf.readShort()], buf.readBoolean() ? BlockCoord.readFromBuf((ByteBuf)buf) : null, buf.readFloat(), buf.readFloat());
    }

    public String toString() {
        return "NetworkClientState [energyStored=" + this.energyStored + ", maxEnergyStored=" + this.maxEnergyStored + ", maxIO=" + this.maxIO + ", maxInput=" + this.maxInput + ", maxOutput=" + this.maxOutput + "]";
    }
}

