/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import crazypants.enderio.machine.crusher.CrusherRecipeManager;
import crazypants.enderio.machine.crusher.GrindingBall;
import crazypants.enderio.machine.crusher.GuiCrusher;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import crazypants.enderio.power.PowerDisplayUtil;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class SagMillRecipeHandler
extends TemplateRecipeHandler {
    private RecipeComparator comparator = new RecipeComparator();

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"enderio.nei.sagmill");
    }

    public String getGuiTexture() {
        return "enderio:textures/gui/nei/crusher.png";
    }

    public PositionedStack getResult() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrusher.class;
    }

    public String getOverlayIdentifier() {
        return "EnderIOSagMill";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 21, 17, 22), "EnderIOSagMill", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<Recipe> recipes = CrusherRecipeManager.getInstance().getRecipes();
        ArrayList<MillRecipe> toAdd = new ArrayList<MillRecipe>();
        for (Recipe recipe : recipes) {
            if (!recipe.hasOuput(result)) continue;
            MillRecipe res = new MillRecipe(result, recipe.getEnergyRequired(), recipe.getInputs()[0], recipe.getOutputs());
            toAdd.add(res);
        }
        Collections.sort(toAdd, this.comparator);
        this.arecipes.addAll(toAdd);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("EnderIOSagMill") && ((Object)((Object)this)).getClass() == SagMillRecipeHandler.class) {
            List<Recipe> recipes = CrusherRecipeManager.getInstance().getRecipes();
            for (Recipe recipe : recipes) {
                MillRecipe res = new MillRecipe(recipe.getEnergyRequired(), recipe.getInputs()[0], recipe.getOutputs());
                this.arecipes.add(res);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<Recipe> recipes = CrusherRecipeManager.getInstance().getRecipes();
        for (Recipe recipe : recipes) {
            MillRecipe res = new MillRecipe(recipe.getEnergyRequired(), recipe.getInputs()[0], recipe.getOutputs());
            if (!res.contains(res.input, ingredient)) continue;
            res.setIngredientPermutation(res.input, ingredient);
            this.arecipes.add(res);
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)65);
    }

    public void drawExtras(int recipeIndex) {
        this.drawProgressBar(73, 20, 166, 0, 17, 24, 40, 1);
        this.drawProgressBar(136, 12, 166, 24, 4, 16, 160, 11);
        MillRecipe recipe = (MillRecipe)((Object)this.arecipes.get(recipeIndex));
        String energyString = PowerDisplayUtil.formatPower(recipe.getEnergy()) + " " + PowerDisplayUtil.abrevation();
        GuiDraw.drawString((String)energyString, (int)96, (int)33, (int)0x808080, (boolean)false);
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipeIndex) {
        MillRecipe recipe = (MillRecipe)((Object)this.arecipes.get(recipeIndex));
        float chance = recipe.getChanceForOutput(stack);
        if (chance > 0.0f && chance < 1.0f) {
            int chanceInt = (int)(chance * 100.0f);
            currenttip.add(EnumChatFormatting.GRAY + MessageFormat.format(StatCollector.func_74838_a((String)"enderio.nei.sagmill.outputchance"), chanceInt));
        }
        return currenttip;
    }

    public List<ItemStack> getInputs(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] eq = input.getEquivelentInputs();
        if (eq != null) {
            for (ItemStack st : eq) {
                result.add(st);
            }
        }
        return result;
    }

    private class RecipeComparator
    implements Comparator<MillRecipe> {
        private RecipeComparator() {
        }

        @Override
        public int compare(MillRecipe o1, MillRecipe o2) {
            float c2;
            float c1 = o1.outputChance[o1.indexOfTargetOutput];
            if (c1 != (c2 = o2.outputChance[o2.indexOfTargetOutput])) {
                return -Float.compare(c1, c2);
            }
            int num1 = o1.numTargetOuput;
            int num2 = o2.numTargetOuput;
            return -this.compare(num1, num2);
        }

        @Override
        public int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }

    public class MillRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        protected int numTargetOuput;
        protected int indexOfTargetOutput;
        private List<PositionedStack> input;
        private PositionedStack output;
        private ArrayList<PositionedStack> otherOutputs;
        private float[] outputChance;
        private int energy;

        public int getEnergy() {
            return this.energy;
        }

        public float getChanceForOutput(ItemStack stack) {
            if (stack == null) {
                return -1.0f;
            }
            if (this.output.item.equals(stack)) {
                return this.outputChance[0];
            }
            for (int i = 0; i < this.otherOutputs.size(); ++i) {
                PositionedStack oo = this.otherOutputs.get(i);
                if (oo == null || !oo.item.equals(stack) || i + 1 >= this.outputChance.length) continue;
                return this.outputChance[i + 1];
            }
            return -1.0f;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SagMillRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherOutputs;
        }

        public MillRecipe(int energy, RecipeInput ingredient, RecipeOutput[] outputs) {
            this(null, energy, ingredient, outputs);
        }

        public MillRecipe(ItemStack targetedResult, int energy, RecipeInput ingredient, RecipeOutput[] outputs) {
            super((TemplateRecipeHandler)SagMillRecipeHandler.this);
            this.energy = energy;
            this.input = new ArrayList<PositionedStack>(2);
            this.input.add(new PositionedStack(SagMillRecipeHandler.this.getInputs(ingredient), 74, 2));
            this.input.add(new PositionedStack(this.getBalls(), 116, 12));
            this.output = new PositionedStack((Object)outputs[0].getOutput(), 43, 46);
            this.otherOutputs = new ArrayList();
            if (outputs.length > 1) {
                this.otherOutputs.add(new PositionedStack((Object)outputs[1].getOutput(), 64, 46));
            }
            if (outputs.length > 2) {
                this.otherOutputs.add(new PositionedStack((Object)outputs[2].getOutput(), 85, 46));
            }
            if (outputs.length > 3) {
                this.otherOutputs.add(new PositionedStack((Object)outputs[3].getOutput(), 106, 46));
            }
            this.outputChance = new float[outputs.length];
            this.indexOfTargetOutput = 0;
            this.numTargetOuput = 1;
            for (int i = 0; i < this.outputChance.length; ++i) {
                this.outputChance[i] = outputs[i].getChance();
                if (targetedResult == null || !outputs[i].getOutput().func_77969_a(targetedResult)) continue;
                this.indexOfTargetOutput = i;
                this.numTargetOuput = outputs[i].getOutput().field_77994_a;
            }
        }

        private List<ItemStack> getBalls() {
            List<GrindingBall> daBalls = CrusherRecipeManager.getInstance().getBalls();
            ArrayList<ItemStack> res = new ArrayList<ItemStack>();
            for (GrindingBall ball : daBalls) {
                res.add(ball.getInput());
            }
            return res;
        }
    }
}

