/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.ai.EntityAIAttackOnCollideAggressive;
import crazypants.enderzoo.entity.ai.EntityAINearestAttackableTargetBounded;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityDireWolf
extends EntityMob
implements IEnderZooMob {
    public static final String NAME = "enderzoo.DireWolf";
    public static final int EGG_BG_COL = 0x606060;
    public static final int EGG_FG_COL = 0xA0A0A0;
    private static final String SND_HURT = "enderzoo:direwolf.hurt";
    private static final String SND_HOWL = "enderzoo:direwolf.howl";
    private static final String SND_GROWL = "enderzoo:direwolf.growl";
    private static final String SND_DEATH = "enderzoo:direwolf.death";
    private static final int ANGRY_INDEX = 12;
    private EntityLivingBase previsousAttackTarget;
    private static int packHowl = 0;
    private static long lastHowl = 0L;
    public static ArrayList<String> collarNames = new ArrayList();

    public EntityDireWolf(World world) {
        super(world);
        for (int count = Integer.parseInt(StatCollector.func_74838_a((String)"entity.enderzoo.DireWolf.tags.count")); count > 0; --count) {
            collarNames.add(new String(StatCollector.func_74838_a((String)("entity.enderzoo.DireWolf.tags." + Integer.toString(count)))));
        }
        this.func_70105_a(0.8f, 1.2f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollideAggressive((EntityCreature)this, 1.1, true).setAttackFrequency(20));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (Config.direWolfAggresiveRange > 0.0) {
            EntityAINearestAttackableTargetBounded nearTarg = new EntityAINearestAttackableTargetBounded((EntityCreature)this, EntityPlayer.class, 0, true);
            nearTarg.setMaxDistanceToTarget(Config.direWolfAggresiveRange);
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)nearTarg);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.updateAngry();
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public float func_70783_a(int x, int y, int z) {
        return this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150349_c ? 10.0f : this.field_70170_p.func_72801_o(x, y, z) - 0.5f;
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        return (this.field_70170_p.func_147439_a(i, (j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150433_aE || this.field_70170_p.func_147439_a(i, j, k) == Blocks.field_150431_aC) && this.field_70170_p.func_72883_k(i, j, k) > 8 && super.func_70601_bi();
    }

    public boolean isAngry() {
        return this.func_70096_w().func_75683_a(12) == 1;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return 6;
    }

    private void updateAngry() {
        this.func_70096_w().func_75692_b(12, (Object)(this.func_70638_az() != null ? (byte)1 : 0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        MobInfo.DIRE_WOLF.applyAttributes((EntityLivingBase)this);
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.func_85030_a("mob.wolf.step", 0.15f, 1.0f);
    }

    protected String func_70639_aQ() {
        boolean isFullMoon;
        if (this.isAngry()) {
            return SND_GROWL;
        }
        if (EntityUtil.isPlayerWithinRange((Entity)this, 18.0)) {
            return SND_GROWL;
        }
        boolean howl = false;
        boolean isNight = this.field_70170_p.func_72820_D() > 15000L && this.field_70170_p.func_72820_D() < 21000L;
        boolean bl = isFullMoon = (double)this.field_70170_p.func_130001_d() == 1.0 || (double)this.field_70170_p.func_130001_d() == 0.75;
        if (packHowl > 0 && this.field_70170_p.func_82737_E() > lastHowl + 10L) {
            howl = true;
        } else if (this.field_70170_p.func_82737_E() > (long)Config.direWolfHowlDelay + lastHowl) {
            double d = this.field_70146_Z.nextFloat();
            int n = isNight ? (isFullMoon ? 4 : 2) : 1;
            if (d <= Config.direWolfHowlChance * (double)n) {
                howl = true;
            }
        }
        if (howl) {
            if (packHowl <= 0) {
                double d = this.field_70146_Z.nextFloat();
                int n = isNight ? (isFullMoon ? 4 : 1) : 1;
                if (d <= Config.direWolfPackHowlChance * (double)n) {
                    packHowl = this.field_70146_Z.nextInt(Config.direWolfPackHowlAmount * (isFullMoon ? 2 : 1) + 1);
                }
            }
            lastHowl = this.field_70170_p.func_82737_E();
            packHowl = Math.max(packHowl - 1, 0);
            return SND_HOWL;
        }
        return SND_GROWL;
    }

    public void func_85030_a(String name, float volume, float pitch) {
        if (SND_HOWL.equals(name)) {
            volume *= (float)Config.direWolfHowlVolumeMult;
            pitch *= 0.8f;
        }
        this.field_70170_p.func_72956_a((Entity)this, name, volume, pitch);
    }

    protected String func_70621_aR() {
        return SND_HURT;
    }

    protected String func_70673_aS() {
        return SND_DEATH;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151103_aS;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (recentlyHit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            int i = this.field_70146_Z.nextInt(3 + looting);
            while (i-- > 0) {
                this.func_145779_a(Items.field_151103_aS, 1);
            }
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack collar = new ItemStack(Items.field_151057_cb, 1);
        int messageId = this.field_70146_Z.nextInt(collarNames.size());
        collar.func_151001_c(collarNames.get(messageId));
        this.func_70099_a(collar, 1.0f);
    }

    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5707964f;
        }
        return 0.7853982f;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double hw = this.field_70130_N / 2.0f;
        double hd = hw * 2.25;
        float f1 = this.field_70131_O;
        this.field_70121_D.func_72324_b(x - hw, y - (double)this.field_70129_M + (double)this.field_70139_V, z - hd, x + hw, y - (double)this.field_70129_M + (double)this.field_70139_V + (double)f1, z + hd);
    }

    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase curTarget = this.func_70638_az();
        if (curTarget != this.previsousAttackTarget) {
            if (curTarget != null) {
                this.doGroupArgo(curTarget);
            }
            this.previsousAttackTarget = this.func_70638_az();
            this.updateAngry();
        }
    }

    private void doGroupArgo(EntityLivingBase curTarget) {
        if (!Config.direWolfPackAttackEnabled) {
            return;
        }
        int range = 16;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)range), (double)(this.field_70163_u - (double)range), (double)(this.field_70161_v - (double)range), (double)(this.field_70165_t + (double)range), (double)(this.field_70163_u + (double)range), (double)(this.field_70161_v + (double)range));
        List pack = this.field_70170_p.func_72872_a(EntityDireWolf.class, bb);
        if (pack != null && !pack.isEmpty()) {
            for (EntityDireWolf wolf : pack) {
                if (wolf.func_70638_az() != null) continue;
                EntityUtil.cancelCurrentTasks((EntityLiving)wolf);
                wolf.func_70624_b(curTarget);
            }
        }
    }
}

