/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.enhancedlootbags.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.enhancedlootbags.EnhancedLootBags;
import eu.usrv.enhancedlootbags.core.items.ItemLootBag;
import eu.usrv.enhancedlootbags.core.serializer.LootGroups;
import eu.usrv.enhancedlootbags.core.serializer.LootGroupsFactory;
import eu.usrv.enhancedlootbags.net.msg.LootBagClientSyncMessage;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.auxiliary.TextFormatHelper;
import eu.usrv.yamcore.persisteddata.PersistedDataBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class LootGroupsHandler {
    private LogHelper _mLogger = EnhancedLootBags.Logger;
    private String _mConfigFileName;
    private LootGroupsFactory _mLGF = new LootGroupsFactory();
    private LootGroups _mLootGroups = null;
    private LootGroups _mClientSideLootGroups = null;
    private PersistedDataBase _mPersistedDB = null;
    private boolean _mInitialized = false;
    private HashMap<String, LootGroups.LootGroup> _mBufferedLootGroups = new HashMap();
    private static Item mLootBagItem = null;
    private static String NBT_COMPOUND_LOOTBAGINFO = "LootBagDrop";
    private static String NBT_S_DROP_ID = "LBDID";
    private static String NBT_S_DROP_ITGROUP = "LBDGroup";
    private static String NBT_I_DROP_AMOUNT = "LBDAmount";
    private static String NBT_I_DROP_LIMIT = "LBDLimit";
    private static String NBT_I_DROP_WEIGHT = "LBDWeight";
    private static String NBT_B_DROP_ISRND = "LBDRnd";
    private static String NBT_B_MERGETRASH = "LBDTrash";
    private static String NBT_D_DROPCHANCE_F0 = "LBDCF0";
    private static String NBT_D_DROPCHANCE_F1 = "LBDCF1";
    private static String NBT_D_DROPCHANCE_F2 = "LBDCF2";
    private static String NBT_D_DROPCHANCE_F3 = "LBDCF3";

    public LootGroups getLootGroups() {
        return this._mLootGroups;
    }

    public LootGroups getLootGroupsClient() {
        return this._mClientSideLootGroups;
    }

    public String getUniqueLootIdentifier(EntityPlayer pPlayer, LootGroups.LootGroup pGroup, LootGroups.LootGroup.Drop pDrop) {
        return String.format("%s_%s_%s", pPlayer.func_110124_au().toString(), pGroup.getGroupID(), pDrop.getIdentifier());
    }

    public boolean isDropAllowedForPlayer(EntityPlayer pPlayer, LootGroups.LootGroup pGroup, LootGroups.LootGroup.Drop pDrop, boolean pUpdateDropCount) {
        this.InitStorage();
        String pDropUID = this.getUniqueLootIdentifier(pPlayer, pGroup, pDrop);
        if (pDrop.getLimitedDropCount() > 0) {
            int tReceivedAmount = this.getDropCount(pPlayer, pGroup, pDrop);
            if (tReceivedAmount >= pDrop.getLimitedDropCount()) {
                return false;
            }
            if (pUpdateDropCount) {
                this._mPersistedDB.setValue(pDropUID, tReceivedAmount + 1);
            }
            return true;
        }
        return true;
    }

    public int getDropCount(EntityPlayer pPlayer, LootGroups.LootGroup pGroup, LootGroups.LootGroup.Drop pDrop) {
        this.InitStorage();
        if (pDrop.getLimitedDropCount() <= 0) {
            return 0;
        }
        return this._mPersistedDB.getValueAsInt(this.getUniqueLootIdentifier(pPlayer, pGroup, pDrop), 0);
    }

    private void InitStorage() {
        if (this._mPersistedDB == null) {
            this._mPersistedDB = new PersistedDataBase(DimensionManager.getCurrentSaveRootDirectory(), "LootBags.dat", "LootBagStorage");
            this._mPersistedDB.Load();
        }
    }

    public void updateDropCount(EntityPlayer pPlayer, LootGroups.LootGroup pGroup, LootGroups.LootGroup.Drop pDrop) {
        this.InitStorage();
        boolean tResult = true;
        String pDropUID = this.getUniqueLootIdentifier(pPlayer, pGroup, pDrop);
        if (pDrop.getLimitedDropCount() > 0) {
            this._mPersistedDB.setValue(pDropUID, this._mPersistedDB.getValueAsInt(pDropUID, 0) + 1);
        } else {
            this._mLogger.warn("Unable to update DropCount for LootID %s. Limit is 0!", (Object)pDrop.getIdentifier());
        }
    }

    public LootGroupsHandler(File pConfigBaseDir) {
        File tConfDir = new File(pConfigBaseDir, "EnhancedLootBags");
        if (!tConfDir.exists()) {
            tConfDir.mkdirs();
        }
        this._mConfigFileName = new File(tConfDir, "LootBags.xml").toString();
    }

    public void InitSampleConfig() {
        LootGroups.LootGroup.Drop pigDiamondLimitedDrop = this._mLGF.createDrop("minecraft:diamond", "sample_Loot_DiamondDrop", "{display:{Lore:[\"Oh, shiny\"]}}", 1, false, 100, 5, "");
        LootGroups.LootGroup.Drop pigCakeUnlimitedDrop = this._mLGF.createDrop("minecraft:cake", "sample_Loot_CakeDrop", 1, false, 100, 0);
        LootGroups.LootGroup.Drop pigRandomCharcoalDrop = this._mLGF.createDrop("minecraft:coal:1", "sample_Loot_CharcoalDrop", 5, true, 100, 0);
        LootGroups.LootGroup tTrashGroup = this._mLGF.createLootGroup(0, "Generic trash group", EnumRarity.common, 1, 1, false);
        LootGroups.LootGroup tSampleGroup = this._mLGF.createLootGroup(1, "Sample Item group", EnumRarity.common, 1, 1, true);
        tSampleGroup.getDrops().add(pigDiamondLimitedDrop);
        tSampleGroup.getDrops().add(pigCakeUnlimitedDrop);
        tTrashGroup.getDrops().add(pigRandomCharcoalDrop);
        this._mLootGroups = new LootGroups();
        this._mLootGroups.getLootTable().add(tSampleGroup);
        this._mLootGroups.getLootTable().add(tTrashGroup);
    }

    public LootGroups.LootGroup getMergedGroupFromID(int pGroupID, int pFortuneLevel) {
        LootGroups.LootGroup tReturnGroup = null;
        LootGroups.LootGroup tTargetGroup = this.getGroupByID(pGroupID);
        String tMergedGroupID = this.getFormattedGroupID(pGroupID, pFortuneLevel);
        if (tTargetGroup != null) {
            if (!tTargetGroup.getCombineWithTrash() || EnhancedLootBags.ELBCfg.AllowFortuneBags && pFortuneLevel == 3) {
                tReturnGroup = tTargetGroup;
            } else {
                tReturnGroup = this._mBufferedLootGroups.get(tMergedGroupID);
                if (tReturnGroup == null) {
                    LootGroups.LootGroup tTrashGroup = this.getGroupByID(0);
                    if (tTrashGroup != null) {
                        LootGroups.LootGroup tMerged = this._mLGF.copyLootGroup(tTargetGroup);
                        for (LootGroups.LootGroup.Drop tDr : tTrashGroup.getDrops()) {
                            tMerged.getDrops().add(this._mLGF.copyDrop(tDr, pFortuneLevel));
                        }
                        tMerged.updateMaxWeight();
                        this._mBufferedLootGroups.put(tMergedGroupID, tMerged);
                        tReturnGroup = tMerged;
                    } else {
                        tReturnGroup = tTargetGroup;
                    }
                }
            }
        } else {
            this._mLogger.error((Object)String.format("TargetGroup for ID returned null, this shouldn't happen. ID: %d", pGroupID));
        }
        tReturnGroup.shuffleLoot();
        return tReturnGroup;
    }

    private String getFormattedGroupID(int pGroupID, int pFortuneLevel) {
        return String.format("%d-%d", pGroupID, pFortuneLevel);
    }

    public LootGroups.LootGroup getGroupByIDClient(int pGroupID) {
        for (LootGroups.LootGroup tGrp : this._mClientSideLootGroups.getLootTable()) {
            if (tGrp.getGroupID() != pGroupID) continue;
            return tGrp;
        }
        return null;
    }

    public LootGroups.LootGroup getGroupByID(int pGroupID) {
        for (LootGroups.LootGroup tGrp : this._mLootGroups.getLootTable()) {
            if (tGrp.getGroupID() != pGroupID) continue;
            return tGrp;
        }
        return null;
    }

    public boolean SaveLootGroups() {
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{LootGroups.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mLootGroups, (OutputStream)new FileOutputStream(this._mConfigFileName, false));
            return true;
        }
        catch (Exception e) {
            this._mLogger.error((Object)"[LootBags] Unable to create new LootBags.xml. Is the config directory write protected?");
            e.printStackTrace();
            return false;
        }
    }

    public void LoadConfig() {
        if (this._mInitialized) {
            this._mLogger.error((Object)"[LootBags] Something just called LoadConfig AFTER it has been initialized!");
            return;
        }
        File tConfigFile = new File(this._mConfigFileName);
        if (!tConfigFile.exists()) {
            this.InitSampleConfig();
            this.SaveLootGroups();
        }
        if (!this.ReloadLootGroups("")) {
            this._mLogger.warn((Object)"[LootBags] Configuration File seems to be damaged, nothing will be loaded!");
            EnhancedLootBags.AdminLogonErrors.AddErrorLogOnAdminJoin("[LootBags] Config file not loaded due errors");
            this.InitSampleConfig();
        }
        this._mInitialized = true;
    }

    public boolean reload() {
        boolean tState = this.ReloadLootGroups("");
        if (this._mInitialized) {
            if (tState) {
                this.sendClientUpdate();
            } else {
                this._mLogger.error((Object)"[LootBags] Reload of LootBag file failed. Not sending client update");
            }
        }
        return tState;
    }

    public static Item getLootBagItem() {
        return mLootBagItem;
    }

    public void registerBagItem() {
        mLootBagItem = new ItemLootBag(this);
        GameRegistry.registerItem((Item)mLootBagItem, (String)"lootbag");
    }

    private String getClientSideXMLStream() {
        try {
            StringWriter tSW = new StringWriter();
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{LootGroups.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            LootGroups tReducedGroup = this._mLGF.copy(this._mLootGroups, false);
            jaxMarsh.marshal((Object)tReducedGroup, (Writer)tSW);
            return tSW.toString();
        }
        catch (Exception e) {
            this._mLogger.error((Object)"[LootBags] Unable to serialize object");
            e.printStackTrace();
            return "";
        }
    }

    private String getXMLStream() {
        try {
            StringWriter tSW = new StringWriter();
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{LootGroups.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mLootGroups, (Writer)tSW);
            return tSW.toString();
        }
        catch (Exception e) {
            this._mLogger.error((Object)"[LootBags] Unable to serialize object");
            e.printStackTrace();
            return "";
        }
    }

    private boolean VerifyConfig(LootGroups pLootGroupsToCheck, boolean pIsLocalConfig) {
        boolean tSuccess = true;
        ArrayList<Integer> tIDlist = new ArrayList<Integer>();
        ArrayList<String> tNameList = new ArrayList<String>();
        for (LootGroups.LootGroup X : pLootGroupsToCheck.getLootTable()) {
            if (tIDlist.contains(X.getGroupID())) {
                this._mLogger.error((Object)String.format("[LootBags] LootGroup ID %d already exists!", X.getGroupID()));
                tSuccess = false;
                break;
            }
            tIDlist.add(X.getGroupID());
            if (tNameList.contains(X.getGroupName())) {
                this._mLogger.error((Object)String.format("[LootBags] LootGroup with the Name %s already exists!", X.getGroupName()));
                tSuccess = false;
                break;
            }
            tNameList.add(X.getGroupName());
            if (!pIsLocalConfig) continue;
            if (X.getDrops().size() == 0) {
                this._mLogger.error((Object)String.format("[LootBags] LootGroup ID %d is empty. Adding dummy item", X.getGroupID()));
                String tNothingDrop = ItemDescriptor.fromItem((Item)Items.field_151106_aX).toString();
                X.getDrops().add(this._mLGF.createDrop(tNothingDrop, "cookiedropbecauseempty", 1, false, 100, 0));
                break;
            }
            for (LootGroups.LootGroup.Drop Y : X.getDrops()) {
                if (ItemDescriptor.fromString((String)Y.getItemName()) == null) {
                    this._mLogger.error((Object)String.format("[LootBags] In ItemDropID: [%s], can't find item [%s]", Y.getIdentifier(), Y.getItemName()));
                    tSuccess = false;
                }
                if (Y.getNBTTag() == null || Y.getNBTTag().isEmpty()) continue;
                try {
                    NBTTagCompound tNBT = (NBTTagCompound)JsonToNBT.func_150315_a((String)Y.getNBTTag());
                    if (tNBT != null) continue;
                    tSuccess = false;
                }
                catch (Exception e) {
                    this._mLogger.error((Object)String.format("[LootBags] In ItemDropID: [%s], NBTTag is invalid", Y.getIdentifier()));
                    tSuccess = false;
                }
            }
        }
        return tSuccess;
    }

    private boolean ReloadLootGroups(String pXMLContent) {
        boolean tResult = false;
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{LootGroups.class});
            Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
            LootGroups tNewItemCollection = null;
            boolean tLocalConfig = pXMLContent.isEmpty();
            if (tLocalConfig) {
                File tConfigFile = new File(this._mConfigFileName);
                tNewItemCollection = (LootGroups)jaxUnmarsh.unmarshal(tConfigFile);
            } else {
                StringReader reader = new StringReader(pXMLContent);
                tNewItemCollection = (LootGroups)jaxUnmarsh.unmarshal((Reader)reader);
            }
            if (!this.VerifyConfig(tNewItemCollection, tLocalConfig)) {
                this._mLogger.error((Object)"[LootBags] New config will NOT be activated. Please check your error-log and try again");
                tResult = false;
            } else {
                if (tLocalConfig) {
                    this._mLootGroups = tNewItemCollection;
                    this._mBufferedLootGroups.clear();
                }
                this._mClientSideLootGroups = tNewItemCollection;
                tResult = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tResult;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent pEvent) {
        if (pEvent.player instanceof EntityPlayerMP) {
            this.sendClientUpdate((EntityPlayerMP)pEvent.player);
        }
    }

    private void sendClientUpdate() {
        this.sendClientUpdate(null);
    }

    private void sendClientUpdate(EntityPlayerMP pPlayer) {
        String tPayload = this.getClientSideXMLStream();
        if (!tPayload.isEmpty()) {
            if (pPlayer != null && pPlayer instanceof EntityPlayerMP) {
                EnhancedLootBags.NW.sendTo(new LootBagClientSyncMessage(tPayload), pPlayer);
            } else if (pPlayer == null) {
                EnhancedLootBags.NW.sendToAll(new LootBagClientSyncMessage(tPayload));
            } else {
                this._mLogger.error((Object)"[LootBags.sendClientUpdate] Target is no EntityPlayer and not null");
            }
        } else {
            this._mLogger.error((Object)"[LootBags] Unable to send update to clients; Received empty serialized object");
        }
    }

    public void processServerConfig(String pPayload) {
        if (this.ReloadLootGroups(pPayload)) {
            this._mLogger.info((Object)"[LootBags] Received and activated configuration from server");
        } else {
            this._mLogger.warn((Object)"[LootBags] Received invalid configuration from server; Not activated!");
        }
    }

    public List<LootGroups.LootGroup.Drop> getItemGroupDrops(LootGroups.LootGroup pGrp, LootGroups.LootGroup.Drop pSelectedDrop) {
        ArrayList<LootGroups.LootGroup.Drop> tGrp = new ArrayList<LootGroups.LootGroup.Drop>();
        if (pSelectedDrop.getItemDropGroup().isEmpty()) {
            tGrp.add(pSelectedDrop);
        } else {
            for (LootGroups.LootGroup.Drop tDr : pGrp.getDrops()) {
                if (!tDr.getItemDropGroup().equalsIgnoreCase(pSelectedDrop.getItemDropGroup())) continue;
                tGrp.add(tDr);
            }
            if (tGrp.isEmpty()) {
                tGrp.add(pSelectedDrop);
            }
        }
        return tGrp;
    }

    public ItemStack[] createFakeInventoryFromID(int pLootGroupID, int pSlotCount) {
        ItemStack[] tList;
        block6: {
            tList = new ItemStack[pSlotCount];
            int i = 0;
            try {
                LootGroups.LootGroup lg = this.getGroupByID(pLootGroupID);
                if (lg != null) {
                    for (LootGroups.LootGroup.Drop dr : lg.getDrops()) {
                        if (i < pSlotCount) {
                            ItemStack tPendingStack = dr.getItemStack();
                            if (tPendingStack == null) {
                                this._mLogger.error((Object)String.format("Unable to generate ItemStack for drop ID %s (%s)", dr.getIdentifier(), dr.getItemName()));
                                continue;
                            }
                            this.addDropInformationNBT(tPendingStack, dr, pLootGroupID);
                            tList[i] = tPendingStack;
                            ++i;
                            continue;
                        }
                        this._mLogger.warn((Object)String.format("Warning: LootBagID %d contains more items than the GUI can currently display! (%d) The result will be truncated", pLootGroupID, pSlotCount));
                        break block6;
                    }
                    break block6;
                }
                this._mLogger.error("LootGroup for ID %d returned null", (Object)pLootGroupID);
            }
            catch (Exception e) {
                this._mLogger.error((Object)"Unable to build Itemlist for Lootbag GUI");
                e.printStackTrace();
            }
        }
        return tList;
    }

    public static int recalcWeightByFortune(int pOldWeight, int pFortuneLevel) {
        if (pFortuneLevel > 0) {
            if (pFortuneLevel < 3) {
                return pOldWeight - (int)Math.floor((double)pOldWeight * (0.33 * (double)pFortuneLevel));
            }
            return 0;
        }
        return pOldWeight;
    }

    private void addDropInformationNBT(ItemStack pStack, LootGroups.LootGroup.Drop pDrop, int pBagID) {
        NBTTagCompound tTag = pStack.func_77978_p();
        if (tTag == null) {
            tTag = new NBTTagCompound();
        }
        LootGroups.LootGroup tItemGroup = this.getGroupByID(pBagID);
        NBTTagCompound tLootTag = tTag.func_74775_l(NBT_COMPOUND_LOOTBAGINFO);
        tLootTag.func_74778_a(NBT_S_DROP_ID, pDrop.getIdentifier());
        tLootTag.func_74778_a(NBT_S_DROP_ITGROUP, pDrop.getItemDropGroup().isEmpty() ? "- no group -" : pDrop.getItemDropGroup());
        tLootTag.func_74768_a(NBT_I_DROP_AMOUNT, pDrop.getAmount());
        tLootTag.func_74768_a(NBT_I_DROP_LIMIT, pDrop.getLimitedDropCount());
        tLootTag.func_74768_a(NBT_I_DROP_WEIGHT, pDrop.getChance());
        tLootTag.func_74757_a(NBT_B_DROP_ISRND, pDrop.getIsRandomAmount());
        tLootTag.func_74757_a(NBT_B_MERGETRASH, tItemGroup.getCombineWithTrash());
        tLootTag.func_74780_a(NBT_D_DROPCHANCE_F0, this.calcPercentageFromWeight(pDrop, tItemGroup, FortuneLevel.LV0));
        tLootTag.func_74780_a(NBT_D_DROPCHANCE_F1, this.calcPercentageFromWeight(pDrop, tItemGroup, FortuneLevel.LV1));
        tLootTag.func_74780_a(NBT_D_DROPCHANCE_F2, this.calcPercentageFromWeight(pDrop, tItemGroup, FortuneLevel.LV2));
        tLootTag.func_74780_a(NBT_D_DROPCHANCE_F3, this.calcPercentageFromWeight(pDrop, tItemGroup, FortuneLevel.LV3));
        tTag.func_74782_a(NBT_COMPOUND_LOOTBAGINFO, (NBTBase)tLootTag);
        pStack.func_77982_d(tTag);
    }

    public double calcPercentageFromWeight(LootGroups.LootGroup.Drop drop, LootGroups.LootGroup lootGroup, FortuneLevel fortuneLevel) {
        return LootGroupsHandler.calcPercentageFromWeight(drop.getChance(), lootGroup.getMaxWeight() + this.getTrashWeight(lootGroup, fortuneLevel));
    }

    private int getTrashWeight(LootGroups.LootGroup lootGroup, FortuneLevel fortuneLevel) {
        if (lootGroup.getGroupID() == 0 || !lootGroup.getCombineWithTrash()) {
            return 0;
        }
        LootGroups.LootGroup trashGroup = this.getGroupByID(0);
        int trashWeight = trashGroup.getMaxWeight();
        return LootGroupsHandler.recalcWeightByFortune(trashWeight, fortuneLevel.level);
    }

    private static double calcPercentageFromWeight(double pItemWeight, double pTotalWeight) {
        double tRet = 0.0;
        tRet = 100.0 / pTotalWeight * pItemWeight;
        tRet = (double)Math.round(tRet * 100.0) / 100.0;
        return tRet;
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent pEvent) {
        NBTTagCompound tDropInfo;
        NBTTagCompound tComp;
        ItemStack tStack = pEvent.itemStack;
        if (tStack != null && (tComp = tStack.func_77978_p()) != null && !(tDropInfo = tComp.func_74775_l(NBT_COMPOUND_LOOTBAGINFO)).func_82582_d()) {
            ArrayList<String> tToolTipInfo = new ArrayList<String>();
            tToolTipInfo.add(" ");
            tToolTipInfo.add(this.getFrmStr("__b__6 == Drop Information == __r"));
            tToolTipInfo.add(this.getFrmStr(String.format("__lDropID :__r %s", tDropInfo.func_74779_i(NBT_S_DROP_ID))));
            tToolTipInfo.add(this.getFrmStr(String.format("__lAmount :__r %d", tDropInfo.func_74762_e(NBT_I_DROP_AMOUNT))));
            tToolTipInfo.add(this.getFrmStr(String.format("__lRandom :__r %b", tDropInfo.func_74767_n(NBT_B_DROP_ISRND))));
            tToolTipInfo.add(this.getFrmStr(String.format("__lLimit  :__r %d", tDropInfo.func_74762_e(NBT_I_DROP_LIMIT))));
            tToolTipInfo.add(this.getFrmStr(String.format("__lWeight :__r %d", tDropInfo.func_74762_e(NBT_I_DROP_WEIGHT))));
            tToolTipInfo.add(this.getFrmStr(String.format("__lIGroup :__r %s", tDropInfo.func_74779_i(NBT_S_DROP_ITGROUP))));
            tToolTipInfo.add(this.getFrmStr("__b__6 == Trash/Fortune Behavior == __r"));
            tToolTipInfo.add(this.getFrmStr(String.format("__lMerges w Trash   :__r %b", tDropInfo.func_74767_n(NBT_B_MERGETRASH))));
            tToolTipInfo.add(this.getFrmStr(String.format("__lDrop %% (F0/1/2/3):__r %.2f | %.2f | %.2f | %.2f", tDropInfo.func_74769_h(NBT_D_DROPCHANCE_F0), tDropInfo.func_74769_h(NBT_D_DROPCHANCE_F1), tDropInfo.func_74769_h(NBT_D_DROPCHANCE_F2), tDropInfo.func_74769_h(NBT_D_DROPCHANCE_F3))));
            pEvent.toolTip.addAll(tToolTipInfo);
        }
    }

    private String getFrmStr(String pSource) {
        return TextFormatHelper.DecodeStringCodes((String)pSource);
    }

    public static enum FortuneLevel {
        LV0(0),
        LV1(1),
        LV2(2),
        LV3(3);

        public final int level;

        private FortuneLevel(int level) {
            this.level = level;
        }
    }
}

