/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.opencomputers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import extracells.part.PartGasImport;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.util.GasUtil;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.driver.SidedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import li.cil.oc.server.network.Component;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DriverGasImportBus
implements SidedBlock {
    public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
        return DriverGasImportBus.getImportBus(world, x, y, z, side) != null;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof IPartHost)) {
            return null;
        }
        return new Environment((IPartHost)tile);
    }

    private static PartGasImport getImportBus(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof IPartHost)) {
            return null;
        }
        IPartHost host = (IPartHost)tile;
        if (dir == null || dir == ForgeDirection.UNKNOWN) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IPart part = host.getPart(side);
                if (part == null || !(part instanceof PartGasImport)) continue;
                return (PartGasImport)part;
            }
            return null;
        }
        IPart part = host.getPart(dir);
        return part == null ? null : (PartGasImport)part;
    }

    static class Provider
    implements EnvironmentProvider {
        Provider() {
        }

        public Class<? extends li.cil.oc.api.network.Environment> getEnvironment(ItemStack stack) {
            if (stack == null) {
                return null;
            }
            if (stack.func_77973_b() == ItemEnum.PARTITEM.getItem() && stack.func_77960_j() == PartEnum.FLUIDEXPORT.ordinal()) {
                return Environment.class;
            }
            return null;
        }
    }

    public class Environment
    extends ManagedEnvironment
    implements NamedBlock {
        protected final TileEntity tile;
        protected final IPartHost host;

        Environment(IPartHost host) {
            this.tile = (TileEntity)host;
            this.host = host;
            this.setNode(Network.newNode((li.cil.oc.api.network.Environment)this, (Visibility)Visibility.Network).withComponent("me_importbus").create());
        }

        @Callback(doc="function(side:number, [ slot:number]):table -- Get the configuration of the gas import bus pointing in the specified direction.")
        public Object[] getGasImportConfiguration(Context context, Arguments args) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)args.checkInteger(0));
            if (dir == null || dir == ForgeDirection.UNKNOWN) {
                return new Object[]{null, "unknown side"};
            }
            PartGasImport part = DriverGasImportBus.getImportBus(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, dir);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            int slot = args.optInteger(1, 4);
            try {
                Fluid fluid = part.filterFluids[slot];
                if (fluid == null) {
                    return new Object[]{null};
                }
                return new Object[]{GasUtil.getGasStack(new FluidStack(fluid, 1000))};
            }
            catch (Throwable e) {
                return new Object[]{null, "Invalid slot"};
            }
        }

        @Callback(doc="function(side:number[, slot:number][, database:address, entry:number]):boolean -- Configure the gas import bus pointing in the specified direction to export gas stacks matching the specified descriptor.")
        public Object[] setFluidImportConfiguration(Context context, Arguments args) {
            int slot;
            int entry;
            String address;
            ForgeDirection dir = ForgeDirection.getOrientation((int)args.checkInteger(0));
            if (dir == null || dir == ForgeDirection.UNKNOWN) {
                return new Object[]{null, "unknown side"};
            }
            PartGasImport part = DriverGasImportBus.getImportBus(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, dir);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            if (args.count() == 3) {
                address = args.checkString(1);
                entry = args.checkInteger(2);
                slot = 4;
            } else {
                if (args.count() < 3) {
                    int slot2 = args.optInteger(1, 4);
                    try {
                        part.filterFluids[slot2] = null;
                        part.onInventoryChanged();
                        context.pause(0.5);
                        return new Object[]{true};
                    }
                    catch (Throwable e) {
                        return new Object[]{false, "invalid slot"};
                    }
                }
                slot = args.optInteger(1, 4);
                address = args.checkString(2);
                entry = args.checkInteger(3);
            }
            Node node = this.node().network().node(address);
            if (node == null) {
                throw new IllegalArgumentException("no such component");
            }
            if (!(node instanceof Component)) {
                throw new IllegalArgumentException("no such component");
            }
            Component component = (Component)node;
            li.cil.oc.api.network.Environment env = node.host();
            if (!(env instanceof Database)) {
                throw new IllegalArgumentException("not a database");
            }
            Database database = (Database)env;
            try {
                ItemStack data = database.getStackInSlot(entry - 1);
                if (data == null) {
                    part.filterFluids[slot] = null;
                } else {
                    GasStack fluid = GasUtil.getGasFromContainer(data);
                    if (fluid == null || fluid.getGas() == null) {
                        return new Object[]{false, "not a fluid container"};
                    }
                    part.filterFluids[slot] = GasUtil.getFluidStack(fluid).getFluid();
                }
                part.onInventoryChanged();
                context.pause(0.5);
                return new Object[]{true};
            }
            catch (Throwable e) {
                return new Object[]{false, "invalid slot"};
            }
        }

        public String preferredName() {
            return "me_importbus";
        }

        public int priority() {
            return 1;
        }
    }
}

