/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.opencomputers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import extracells.part.PartOreDictExporter;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.driver.SidedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DriverOreDictExportBus
implements SidedBlock {
    public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
        return DriverOreDictExportBus.getExportBus(world, x, y, z, side) != null;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof IPartHost)) {
            return null;
        }
        return new Environment((IPartHost)tile);
    }

    private static PartOreDictExporter getExportBus(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof IPartHost)) {
            return null;
        }
        IPartHost host = (IPartHost)tile;
        if (dir == null || dir == ForgeDirection.UNKNOWN) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IPart part = host.getPart(side);
                if (part == null || !(part instanceof PartOreDictExporter)) continue;
                return (PartOreDictExporter)part;
            }
            return null;
        }
        IPart part = host.getPart(dir);
        return part == null ? null : (PartOreDictExporter)part;
    }

    static class Provider
    implements EnvironmentProvider {
        Provider() {
        }

        public Class<? extends li.cil.oc.api.network.Environment> getEnvironment(ItemStack stack) {
            if (stack.func_77973_b() == ItemEnum.PARTITEM.getItem() && stack.func_77960_j() == PartEnum.OREDICTEXPORTBUS.ordinal()) {
                return Environment.class;
            }
            return null;
        }
    }

    public class Environment
    extends ManagedEnvironment
    implements NamedBlock {
        protected final TileEntity tile;
        protected final IPartHost host;

        Environment(IPartHost host) {
            this.tile = (TileEntity)host;
            this.host = host;
            this.setNode(Network.newNode((li.cil.oc.api.network.Environment)this, (Visibility)Visibility.Network).withComponent("me_exportbus").create());
        }

        @Callback(doc="function(side:number):string -- Get the configuration of the ore dict export bus pointing in the specified direction.")
        public Object[] getOreConfiguration(Context context, Arguments args) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)args.checkInteger(0));
            if (dir == null || dir == ForgeDirection.UNKNOWN) {
                return new Object[]{null, "unknown side"};
            }
            PartOreDictExporter part = DriverOreDictExportBus.getExportBus(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, dir);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            return new Object[]{part.filter};
        }

        @Callback(doc="function(side:number[, filter:string]):boolean -- Set the configuration of the ore dict export bus pointing in the specified direction.")
        public Object[] setOreConfiguration(Context context, Arguments args) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)args.checkInteger(0));
            if (dir == null || dir == ForgeDirection.UNKNOWN) {
                return new Object[]{false, "unknown side"};
            }
            PartOreDictExporter part = DriverOreDictExportBus.getExportBus(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, dir);
            if (part == null) {
                return new Object[]{false, "no export bus"};
            }
            part.filter = args.optString(1, "");
            context.pause(0.5);
            return new Object[]{true};
        }

        public String preferredName() {
            return "me_exportbus";
        }

        public int priority() {
            return 0;
        }
    }
}

