/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerFluidTerminal;
import extracells.container.ContainerGasTerminal;
import extracells.gridblock.ECBaseGridBlock;
import extracells.gui.GuiFluidTerminal;
import extracells.network.packet.part.PacketFluidTerminal;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class PartFluidTerminal
extends PartECBase
implements IGridTickable,
IInventoryUpdateReceiver {
    protected Fluid currentFluid;
    private List<Object> containers = new ArrayList<Object>();
    protected ECPrivateInventory inventory = new ECPrivateInventory("extracells.part.fluid.terminal", 2, 64, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return PartFluidTerminal.this.isItemValidForInputSlot(i, itemStack);
        }
    };
    protected MachineSource machineSource = new MachineSource((IActionHost)this);

    protected boolean isItemValidForInputSlot(int i, ItemStack itemStack) {
        return FluidUtil.isFluidContainer(itemStack);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.inventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public int getLightLevel() {
        return this.isPowered() ? 9 : 0;
    }

    public void addContainer(ContainerFluidTerminal containerTerminalFluid) {
        this.containers.add(containerTerminalFluid);
        this.sendCurrentFluid();
    }

    public void addContainer(ContainerGasTerminal containerTerminalGas) {
        this.containers.add(containerTerminalGas);
        this.sendCurrentFluid();
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    public void decreaseFirstSlot() {
        ItemStack slot = this.inventory.func_70301_a(0);
        --slot.field_77994_a;
        if (slot.field_77994_a <= 0) {
            this.inventory.func_70299_a(0, null);
        }
    }

    public void doWork() {
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot != null && secondSlot.field_77994_a >= secondSlot.func_77976_d()) {
            return;
        }
        ItemStack container = this.inventory.func_70301_a(0);
        if (!FluidUtil.isFluidContainer(container)) {
            return;
        }
        container = container.func_77946_l();
        container.field_77994_a = 1;
        ECBaseGridBlock gridBlock = this.getGridBlock();
        if (gridBlock == null) {
            return;
        }
        IMEMonitor<IAEFluidStack> monitor = gridBlock.getFluidMonitor();
        if (monitor == null) {
            return;
        }
        if (FluidUtil.isEmpty(container)) {
            int proposedAmount;
            if (this.currentFluid == null) {
                return;
            }
            int capacity = FluidUtil.getCapacity(container);
            IAEFluidStack result = (IAEFluidStack)monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.currentFluid, (long)capacity), Actionable.SIMULATE, (BaseActionSource)this.machineSource);
            int n = proposedAmount = result == null ? 0 : (int)Math.min((long)capacity, result.getStackSize());
            if (proposedAmount == 0) {
                return;
            }
            MutablePair<Integer, ItemStack> filledContainer = FluidUtil.fillStack(container, new FluidStack(this.currentFluid, proposedAmount));
            if ((Integer)filledContainer.getLeft() > proposedAmount) {
                return;
            }
            if (this.fillSecondSlot((ItemStack)filledContainer.getRight())) {
                monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.currentFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (BaseActionSource)this.machineSource);
                this.decreaseFirstSlot();
            }
        } else {
            FluidStack containerFluid = FluidUtil.getFluidFromContainer(container);
            IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)FluidUtil.createAEFluidStack(containerFluid), Actionable.SIMULATE, (BaseActionSource)this.machineSource);
            if (notInjected != null) {
                return;
            }
            MutablePair<Integer, ItemStack> drainedContainer = FluidUtil.drainStack(container, containerFluid);
            ItemStack emptyContainer = (ItemStack)drainedContainer.getRight();
            if (emptyContainer == null || this.fillSecondSlot(emptyContainer)) {
                monitor.injectItems((IAEStack)FluidUtil.createAEFluidStack(containerFluid), Actionable.MODULATE, (BaseActionSource)this.machineSource);
                this.decreaseFirstSlot();
            }
        }
    }

    public boolean fillSecondSlot(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot == null) {
            this.inventory.func_70299_a(1, itemStack);
            return true;
        }
        if (!secondSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)secondSlot)) {
            return false;
        }
        this.inventory.incrStackSize(1, itemStack.field_77994_a);
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidTerminal(this, player);
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 0.5;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFluidTerminal(this, player);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (this.isActive() && (PermissionUtil.hasPermission(player, SecurityPermissions.INJECT, this) || PermissionUtil.hasPermission(player, SecurityPermissions.EXTRACT, this))) {
            return super.onActivate(player, pos);
        }
        return false;
    }

    @Override
    public void onInventoryChanged() {
        this.saveData();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
    }

    public void removeContainer(ContainerFluidTerminal containerTerminalFluid) {
        this.containers.remove(containerTerminalFluid);
    }

    public void removeContainer(ContainerGasTerminal containerTerminalGas) {
        this.containers.remove(containerTerminalGas);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        rh.setInvColor(0xFFFFFF);
        rh.renderInventoryFace(TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.setInvColor(AEColor.Transparent.blackVariant);
        rh.renderInventoryFace(TextureManager.TERMINAL_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.mediumVariant);
        rh.renderInventoryFace(TextureManager.TERMINAL_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.whiteVariant);
        rh.renderInventoryFace(TextureManager.TERMINAL_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        ts.func_78378_d(0xFFFFFF);
        rh.renderFace(x, y, z, TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        IPartHost host = this.getHost();
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(host.getColor().blackVariant);
        rh.renderFace(x, y, z, TextureManager.TERMINAL_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().mediumVariant);
        rh.renderFace(x, y, z, TextureManager.TERMINAL_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().whiteVariant);
        rh.renderFace(x, y, z, TextureManager.TERMINAL_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    public void sendCurrentFluid() {
        for (Object containerFluidTerminal : this.containers) {
            this.sendCurrentFluid(containerFluidTerminal);
        }
    }

    public void sendCurrentFluid(Object container) {
        if (container instanceof ContainerFluidTerminal) {
            ContainerFluidTerminal containerFluidTerminal = (ContainerFluidTerminal)container;
            new PacketFluidTerminal(containerFluidTerminal.getPlayer(), this.currentFluid).sendPacketToPlayer(containerFluidTerminal.getPlayer());
        } else if (container instanceof ContainerGasTerminal) {
            ContainerGasTerminal containerGasTerminal = (ContainerGasTerminal)container;
            new PacketFluidTerminal(containerGasTerminal.getPlayer(), this.currentFluid).sendPacketToPlayer(containerGasTerminal.getPlayer());
        }
    }

    public void setCurrentFluid(Fluid _currentFluid) {
        this.currentFluid = _currentFluid;
        this.sendCurrentFluid();
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.doWork();
        return TickRateModulation.FASTER;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }
}

