/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.part.PartFluidStorage;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class HandlerPartStorageFluid
implements IMEInventoryHandler<IAEFluidStack>,
IMEMonitorHandlerReceiver<IAEFluidStack> {
    protected PartFluidStorage node;
    protected IFluidHandler tank;
    protected AccessRestriction access = AccessRestriction.READ_WRITE;
    protected List<Fluid> prioritizedFluids = new ArrayList<Fluid>();
    protected boolean inverted;
    private IExternalStorageHandler externalHandler = null;
    protected TileEntity tile = null;
    public ITileStorageMonitorable externalSystem;

    public HandlerPartStorageFluid(PartFluidStorage _node) {
        this.node = _node;
    }

    public boolean canAccept(IAEFluidStack input) {
        if (!this.node.isActive()) {
            return false;
        }
        if (this.tank == null && this.externalSystem == null && this.externalHandler == null || this.access != AccessRestriction.WRITE && this.access != AccessRestriction.READ_WRITE || input == null) {
            return false;
        }
        if (this.externalSystem != null) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (monitor == null) {
                return false;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            return fluidInventory != null && fluidInventory.canAccept((IAEStack)input);
        }
        if (this.externalHandler != null) {
            IMEInventory inventory = this.externalHandler.getInventory(this.tile, this.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)this.node));
            return inventory != null;
        }
        FluidTankInfo[] infoArray = this.tank.getTankInfo(this.node.getSide().getOpposite());
        if (infoArray != null && infoArray.length > 0) {
            for (FluidTankInfo tank : infoArray) {
                if (tank.fluid == null) {
                    return this.isPrioritized(input);
                }
                if (tank.fluid.getFluidID() != input.getFluidStack().getFluidID()) continue;
                if (!this.isPrioritized(input)) {
                    return false;
                }
                if (tank.fluid.amount >= tank.capacity) continue;
                return true;
            }
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (!this.node.isActive() || this.access != AccessRestriction.READ && this.access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if (this.externalSystem != null && request != null) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), src);
            if (monitor == null) {
                return null;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            if (fluidInventory == null) {
                return null;
            }
            return (IAEFluidStack)fluidInventory.extractItems((IAEStack)request, mode, src);
        }
        if (this.externalHandler != null && request != null) {
            IMEInventory inventory = this.externalHandler.getInventory(this.tile, this.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (inventory == null) {
                return null;
            }
            return (IAEFluidStack)inventory.extractItems((IAEStack)request, mode, (BaseActionSource)new MachineSource((IActionHost)this.node));
        }
        if (this.tank == null || request == null || this.access == AccessRestriction.WRITE || this.access == AccessRestriction.NO_ACCESS) {
            return null;
        }
        FluidStack toDrain = request.getFluidStack();
        if (!this.tank.canDrain(this.node.getSide().getOpposite(), toDrain.getFluid())) {
            return null;
        }
        FluidStack drain = this.tank.drain(this.node.getSide().getOpposite(), new FluidStack(toDrain.getFluid(), toDrain.amount), mode == Actionable.MODULATE);
        if (drain == null) {
            return null;
        }
        if (drain.amount == 0) {
            return null;
        }
        if (drain.amount == toDrain.amount) {
            return request;
        }
        return FluidUtil.createAEFluidStack(toDrain.getFluidID(), (long)drain.amount);
    }

    public AccessRestriction getAccess() {
        return this.access;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        block8: {
            FluidTankInfo[] infoArray;
            block9: {
                block7: {
                    if (!this.node.isActive() || this.access != AccessRestriction.READ && this.access != AccessRestriction.READ_WRITE) {
                        return out;
                    }
                    if (this.externalSystem == null) break block7;
                    IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node));
                    if (monitor == null) {
                        return out;
                    }
                    IMEMonitor fluidInventory = monitor.getFluidInventory();
                    if (fluidInventory == null) {
                        return out;
                    }
                    IItemList list = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node)).getFluidInventory().getStorageList();
                    for (IAEFluidStack stack : list) {
                        out.add((IAEStack)stack);
                    }
                    break block8;
                }
                if (this.externalHandler == null) break block9;
                IMEInventory inventory = this.externalHandler.getInventory(this.tile, this.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)this.node));
                if (inventory == null) {
                    return out;
                }
                IItemList list = inventory.getAvailableItems(AEApi.instance().storage().createFluidList());
                for (IAEFluidStack stack : list) {
                    out.add((IAEStack)stack);
                }
                break block8;
            }
            if (this.tank == null || (infoArray = this.tank.getTankInfo(this.node.getSide().getOpposite())) == null || infoArray.length <= 0) break block8;
            for (FluidTankInfo info : infoArray) {
                if (info.fluid == null) continue;
                out.add((IAEStack)AEApi.instance().storage().createFluidStack(info.fluid));
            }
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public int getPriority() {
        return this.node.getPriority();
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (this.access != AccessRestriction.WRITE && this.access != AccessRestriction.READ_WRITE) {
            return null;
        }
        if (this.externalSystem != null && input != null) {
            IStorageMonitorable monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), src);
            if (monitor == null) {
                return input;
            }
            IMEMonitor fluidInventory = monitor.getFluidInventory();
            if (fluidInventory == null) {
                return input;
            }
            return (IAEFluidStack)fluidInventory.injectItems((IAEStack)input, mode, src);
        }
        if (this.externalHandler != null && input != null) {
            IMEInventory inventory = this.externalHandler.getInventory(this.tile, this.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (inventory == null) {
                return input;
            }
            return (IAEFluidStack)inventory.injectItems((IAEStack)input, mode, (BaseActionSource)new MachineSource((IActionHost)this.node));
        }
        if (this.tank == null || input == null || !this.canAccept(input)) {
            return input;
        }
        FluidStack toFill = input.getFluidStack();
        int filled = 0;
        int filled2 = 0;
        while ((filled2 = this.tank.fill(this.node.getSide().getOpposite(), new FluidStack(toFill.getFluid(), toFill.amount - filled), mode == Actionable.MODULATE)) != 0 && (filled += filled2) != toFill.amount) {
        }
        if (filled == toFill.amount) {
            return null;
        }
        return FluidUtil.createAEFluidStack(toFill.getFluidID(), (long)(toFill.amount - filled));
    }

    public boolean isPrioritized(IAEFluidStack input) {
        if (input == null) {
            return false;
        }
        if (this.prioritizedFluids.isEmpty()) {
            return true;
        }
        for (Fluid fluid : this.prioritizedFluids) {
            if (fluid != input.getFluid()) continue;
            return !this.inverted;
        }
        return this.inverted;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onListUpdate() {
    }

    public void onNeighborChange() {
        TileEntity tileEntity;
        IMEMonitor fluidInventory;
        IStorageMonitorable monitor;
        if (this.externalSystem != null && (monitor = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node))) != null && (fluidInventory = monitor.getFluidInventory()) != null) {
            fluidInventory.removeListener((IMEMonitorHandlerReceiver)this);
        }
        this.tank = null;
        ForgeDirection orientation = this.node.getSide();
        TileEntity hostTile = this.node.getHostTile();
        if (hostTile == null) {
            return;
        }
        if (hostTile.func_145831_w() == null) {
            return;
        }
        this.tile = tileEntity = hostTile.func_145831_w().func_147438_o(hostTile.field_145851_c + orientation.offsetX, hostTile.field_145848_d + orientation.offsetY, hostTile.field_145849_e + orientation.offsetZ);
        this.tank = null;
        this.externalSystem = null;
        if (tileEntity == null) {
            this.externalHandler = null;
            return;
        }
        this.externalHandler = AEApi.instance().registries().externalStorage().getHandler(tileEntity, this.node.getSide().getOpposite(), StorageChannel.FLUIDS, (BaseActionSource)new MachineSource((IActionHost)this.node));
        if (tileEntity instanceof ITileStorageMonitorable) {
            this.externalSystem = (ITileStorageMonitorable)tileEntity;
            IStorageMonitorable monitor2 = this.externalSystem.getMonitorable(this.node.getSide().getOpposite(), (BaseActionSource)new MachineSource((IActionHost)this.node));
            if (monitor2 == null) {
                return;
            }
            IMEMonitor fluidInventory2 = monitor2.getFluidInventory();
            if (fluidInventory2 == null) {
                return;
            }
            fluidInventory2.addListener((IMEMonitorHandlerReceiver)this, null);
        } else if (this.externalHandler == null && tileEntity instanceof IFluidHandler) {
            this.tank = (IFluidHandler)tileEntity;
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        IGridNode gridNode = this.node.getGridNode();
        if (gridNode != null) {
            IGrid grid = gridNode.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.node.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
            }
            this.node.getHost().markForUpdate();
        }
    }

    public void setAccessRestriction(AccessRestriction access) {
        this.access = access;
    }

    public void setInverted(boolean _inverted) {
        this.inverted = _inverted;
    }

    public void setPrioritizedFluids(Fluid[] _fluids) {
        this.prioritizedFluids.clear();
        for (Fluid fluid : _fluids) {
            if (fluid == null) continue;
            this.prioritizedFluids.add(fluid);
        }
    }

    public boolean validForPass(int i) {
        return true;
    }
}

