/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.gridblock.ECBaseGridBlock;
import extracells.integration.Integration;
import extracells.network.GuiHandler;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import mekanism.api.gas.IGasHandler;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class PartECBase
implements IPart,
IGridHost,
IActionHost,
IPowerChannelState {
    private IGridNode node;
    private ForgeDirection side;
    private IPartHost host;
    protected TileEntity tile;
    private ECBaseGridBlock gridBlock;
    private double powerUsage;
    private TileEntity hostTile;
    private IFluidHandler facingTank;
    private Object facingGasTank;
    private boolean redstonePowered;
    private boolean isActive;
    private boolean isPowerd = false;
    private EntityPlayer owner;
    private ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));

    public void addToWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.gridBlock = new ECBaseGridBlock(this);
        this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        if (this.node != null) {
            if (this.owner != null) {
                this.node.setPlayerID(AEApi.instance().registries().players().getID(this.owner));
            }
            this.node.updateState();
        }
        this.setPower(null);
        this.onNeighborChanged();
    }

    public abstract int cableConnectionRenderTo();

    public boolean canBePlacedOn(BusSupport what) {
        return what != BusSupport.DENSE_CABLE;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    protected final IAEFluidStack extractFluid(IAEFluidStack toExtract, Actionable action) {
        if (this.gridBlock == null || this.facingTank == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return null;
        }
        return (IAEFluidStack)monitor.extractItems((IAEStack)toExtract, action, (BaseActionSource)new MachineSource((IActionHost)this));
    }

    protected final IAEFluidStack extractGasFluid(IAEFluidStack toExtract, Actionable action) {
        if (this.gridBlock == null || this.facingGasTank == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return null;
        }
        return (IAEFluidStack)monitor.extractItems((IAEStack)toExtract, action, (BaseActionSource)new MachineSource((IActionHost)this));
    }

    protected final IAEFluidStack extractGas(IAEFluidStack toExtract, Actionable action) {
        if (this.gridBlock == null || this.facingGasTank == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return null;
        }
        return (IAEFluidStack)monitor.extractItems((IAEStack)toExtract, action, (BaseActionSource)new MachineSource((IActionHost)this));
    }

    public final IGridNode getActionableNode() {
        return this.node;
    }

    public abstract void getBoxes(IPartCollisionHelper var1);

    public IIcon getBreakingTexture() {
        return TextureManager.BUS_SIDE.getTexture();
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.GLASS;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    public final IGridNode getExternalFacingNode() {
        return null;
    }

    public IFluidHandler getFacingTank() {
        return this.facingTank;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public IGasHandler getFacingGasTank() {
        return (IGasHandler)this.facingGasTank;
    }

    public ECBaseGridBlock getGridBlock() {
        return this.gridBlock;
    }

    public IGridNode getGridNode() {
        return this.node;
    }

    public final IGridNode getGridNode(ForgeDirection dir) {
        return this.node;
    }

    public IPartHost getHost() {
        return this.host;
    }

    public TileEntity getHostTile() {
        return this.hostTile;
    }

    public ItemStack getItemStack(PartItemStack type) {
        return this.is;
    }

    public int getLightLevel() {
        return 0;
    }

    public final DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
    }

    public double getPowerUsage() {
        return this.powerUsage;
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    public ForgeDirection getSide() {
        return this.side;
    }

    public List<String> getWailaBodey(NBTTagCompound tag, List<String> oldList) {
        return oldList;
    }

    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        return tag;
    }

    public void initializePart(ItemStack partStack) {
        if (partStack.func_77942_o()) {
            this.readFromNBT(partStack.func_77978_p());
        }
    }

    protected final IAEFluidStack injectFluid(IAEFluidStack toInject, Actionable action) {
        if (this.gridBlock == null || this.facingTank == null) {
            return toInject;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return toInject;
        }
        return (IAEFluidStack)monitor.injectItems((IAEStack)toInject, action, (BaseActionSource)new MachineSource((IActionHost)this));
    }

    protected final IAEFluidStack injectGas(IAEFluidStack toInject, Actionable action) {
        if (this.gridBlock == null || this.facingGasTank == null) {
            return toInject;
        }
        IMEMonitor<IAEFluidStack> monitor = this.gridBlock.getFluidMonitor();
        if (monitor == null) {
            return toInject;
        }
        return (IAEFluidStack)monitor.injectItems((IAEStack)toInject, action, (BaseActionSource)new MachineSource((IActionHost)this));
    }

    public boolean isActive() {
        return this.node != null ? this.node.isActive() : this.isActive;
    }

    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    public boolean isPowered() {
        return this.isPowerd;
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    protected boolean isRedstonePowered() {
        return this.redstonePowered;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (player != null && player instanceof EntityPlayerMP) {
            GuiHandler.launchGui(GuiHandler.getGuiId(this), player, this.hostTile.func_145831_w(), this.hostTile.field_145851_c, this.hostTile.field_145848_d, this.hostTile.field_145849_e);
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
    }

    public boolean isValid() {
        if (this.hostTile != null && this.hostTile.func_145830_o()) {
            DimensionalCoord loc = this.getLocation();
            TileEntity host = this.hostTile.func_145831_w().func_147438_o(loc.x, loc.y, loc.z);
            if (host instanceof IPartHost) {
                return ((IPartHost)host).getPart(this.side) == this;
            }
            return false;
        }
        return false;
    }

    public void onNeighborChanged() {
        if (this.hostTile == null) {
            return;
        }
        World world = this.hostTile.func_145831_w();
        int x = this.hostTile.field_145851_c;
        int y = this.hostTile.field_145848_d;
        int z = this.hostTile.field_145849_e;
        TileEntity tileEntity = world.func_147438_o(x + this.side.offsetX, y + this.side.offsetY, z + this.side.offsetZ);
        this.facingTank = null;
        if (tileEntity instanceof IFluidHandler) {
            this.facingTank = (IFluidHandler)tileEntity;
        }
        if (Integration.Mods.MEKANISMGAS.isEnabled()) {
            this.updateCheckGasTank(tileEntity);
        }
        this.redstonePowered = world.func_72864_z(x, y, z) || world.func_72864_z(x, y + 1, z);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private void updateCheckGasTank(TileEntity tile) {
        this.facingGasTank = null;
        if (tile != null && tile instanceof IGasHandler) {
            this.facingGasTank = tile;
        }
    }

    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        this.owner = player;
    }

    public boolean onShiftActivate(EntityPlayer player, Vec3 pos) {
        return false;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("node") && this.node != null) {
            this.node.loadFromNBT("node0", data.func_74775_l("node"));
            this.node.updateState();
        }
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        this.isActive = data.readBoolean();
        this.isPowerd = data.readBoolean();
        return true;
    }

    public void removeFromWorld() {
        if (this.node != null) {
            this.node.destroy();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderInventory(IPartRenderHelper var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryBusLights(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        rh.setInvColor(0xFFFFFF);
        IIcon otherIcon = TextureManager.BUS_COLOR.getTextures()[0];
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(otherIcon, otherIcon, side, side, otherIcon, otherIcon);
        rh.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        rh.setInvColor(AEColor.Transparent.blackVariant);
        rh.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.UP, renderer);
        rh.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.DOWN, renderer);
        rh.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.NORTH, renderer);
        rh.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.EAST, renderer);
        rh.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.WEST, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(int var1, int var2, int var3, IPartRenderHelper var4, RenderBlocks var5);

    @SideOnly(value=Side.CLIENT)
    public void renderStaticBusLights(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon otherIcon = TextureManager.BUS_COLOR.getTextures()[0];
        IIcon side = TextureManager.BUS_SIDE.getTexture();
        rh.setTexture(otherIcon, otherIcon, side, side, otherIcon, otherIcon);
        rh.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            ts.func_78380_c(0xD000D0);
            ts.func_78378_d(this.host.getColor().blackVariant);
        } else {
            ts.func_78378_d(0);
        }
        rh.renderFace(x, y, z, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.UP, renderer);
        rh.renderFace(x, y, z, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.DOWN, renderer);
        rh.renderFace(x, y, z, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.NORTH, renderer);
        rh.renderFace(x, y, z, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.EAST, renderer);
        rh.renderFace(x, y, z, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.renderFace(x, y, z, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.WEST, renderer);
    }

    public boolean requireDynamicRender() {
        return false;
    }

    protected final void saveData() {
        if (this.host != null) {
            this.host.markForSave();
        }
    }

    public void securityBreak() {
        this.getHost().removePart(this.side, false);
    }

    protected void setActive(boolean _active) {
        this.isActive = _active;
    }

    public void setPartHostInfo(ForgeDirection _side, IPartHost _host, TileEntity _tile) {
        this.side = _side;
        this.host = _host;
        this.tile = _tile;
        this.hostTile = _tile;
        this.setPower(null);
    }

    @MENetworkEventSubscribe
    public void setPower(MENetworkPowerStatusChange notUsed) {
        if (this.node != null) {
            IEnergyGrid energy;
            this.isActive = this.node.isActive();
            IGrid grid = this.node.getGrid();
            if (grid != null && (energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class)) != null) {
                this.isPowerd = energy.isNetworkPowered();
            }
            this.host.markForUpdate();
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        if (this.node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            this.node.saveToNBT("node0", nodeTag);
            data.func_74782_a("node", (NBTBase)nodeTag);
        }
    }

    public void writeToStream(ByteBuf data) throws IOException {
        data.writeBoolean(this.node != null && this.node.isActive());
        data.writeBoolean(this.isPowerd);
    }
}

