/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.events.MENetworkChannelChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.gridblock.ECBaseGridBlock;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import extracells.util.PermissionUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class PartFluidPlaneAnnihilation
extends PartECBase {
    @Override
    public int cableConnectionRenderTo() {
        return 2;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelChanged e) {
        if (e.node == this.getGridNode()) {
            this.onNeighborChanged();
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, pos);
        }
        return false;
    }

    @Override
    public void onNeighborChanged() {
        TileEntity hostTile = this.getHostTile();
        ECBaseGridBlock gridBlock = this.getGridBlock();
        if (hostTile == null || gridBlock == null) {
            return;
        }
        IMEMonitor<IAEFluidStack> monitor = gridBlock.getFluidMonitor();
        if (monitor == null) {
            return;
        }
        World world = hostTile.func_145831_w();
        int x = hostTile.field_145851_c;
        int y = hostTile.field_145848_d;
        int z = hostTile.field_145849_e;
        ForgeDirection side = this.getSide();
        Block fluidBlock = world.func_147439_a(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
        int meta = world.func_72805_g(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
        if (fluidBlock instanceof IFluidBlock) {
            IFluidBlock block = (IFluidBlock)fluidBlock;
            FluidStack drained = block.drain(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, false);
            if (drained == null) {
                return;
            }
            IAEFluidStack toInject = FluidUtil.createAEFluidStack(drained);
            IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)toInject, Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            if (notInjected != null) {
                return;
            }
            monitor.injectItems((IAEStack)toInject, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
            block.drain(world, x + side.offsetX, y + side.offsetY, z + side.offsetZ, true);
        } else if (meta == 0) {
            if (fluidBlock == Blocks.field_150358_i) {
                IAEFluidStack toInject = FluidUtil.createAEFluidStack(FluidRegistry.WATER);
                IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)toInject, Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (notInjected != null) {
                    return;
                }
                monitor.injectItems((IAEStack)toInject, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                world.func_147468_f(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
            } else if (fluidBlock == Blocks.field_150356_k) {
                IAEFluidStack toInject = FluidUtil.createAEFluidStack(FluidRegistry.LAVA);
                IAEFluidStack notInjected = (IAEFluidStack)monitor.injectItems((IAEStack)toInject, Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                if (notInjected != null) {
                    return;
                }
                monitor.injectItems((IAEStack)toInject, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                world.func_147468_f(x + side.offsetX, y + side.offsetY, z + side.offsetZ);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon side = TextureManager.PANE_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(3.0f, 3.0f, 14.0f, 13.0f, 13.0f, 16.0f);
        rh.setInvColor(AEColor.Cyan.blackVariant);
        rh.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderer);
        Tessellator.field_78398_a.func_78380_c(0xD000D0);
        rh.setInvColor(AEColor.Cyan.mediumVariant);
        rh.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Cyan.whiteVariant);
        rh.renderInventoryFace(TextureManager.PANE_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.PANE_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(3.0f, 3.0f, 14.0f, 13.0f, 13.0f, 16.0f);
        IPartHost host = this.getHost();
        if (host != null) {
            ts.func_78378_d(host.getColor().blackVariant);
            rh.renderFace(x, y, z, TextureManager.PANE_FRONT.getTextures()[0], ForgeDirection.SOUTH, renderer);
            if (this.isActive()) {
                ts.func_78380_c(0xD000D0);
            }
            ts.func_78378_d(host.getColor().mediumVariant);
            rh.renderFace(x, y, z, TextureManager.PANE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
            ts.func_78378_d(host.getColor().whiteVariant);
            rh.renderFace(x, y, z, TextureManager.PANE_FRONT.getTextures()[2], ForgeDirection.SOUTH, renderer);
        }
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    @MENetworkEventSubscribe
    public void setPower(MENetworkPowerStatusChange notUsed) {
        super.setPower(notUsed);
        this.onNeighborChanged();
    }
}

