/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class WidgetFluidTank
extends Gui {
    IFluidTank tank;
    public int posX;
    public int posY;
    ForgeDirection direction;

    public WidgetFluidTank(IFluidTank tank, int posX, int posY) {
        this(tank, posX, posY, ForgeDirection.UNKNOWN);
    }

    public WidgetFluidTank(IFluidTank tank, int posX, int posY, ForgeDirection direction) {
        this.tank = tank;
        this.posX = posX;
        this.posY = posY;
        this.direction = direction;
    }

    public void draw(int guiX, int guiY, int mouseX, int mouseY) {
        if (this.tank == null) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("extracells", "textures/gui/fluidtank.png"));
        this.func_73729_b(this.posX, this.posY, 0, 0, 18, 73);
        int iconHeightRemainder = 5;
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null && fluid.amount > 0) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            IIcon fluidIcon = fluid.getFluid().getStillIcon();
            GL11.glColor3f((float)((float)(fluid.getFluid().getColor() >> 16 & 0xFF) / 255.0f), (float)((float)(fluid.getFluid().getColor() >> 8 & 0xFF) / 255.0f), (float)((float)(fluid.getFluid().getColor() & 0xFF) / 255.0f));
            if (iconHeightRemainder > 0) {
                this.func_94065_a(this.posX + 1, this.posY + 2, fluidIcon, 16, iconHeightRemainder);
            }
            for (int i = 0; i < 4; ++i) {
                this.func_94065_a(this.posX + 1, this.posY + 2 + i * 16 + iconHeightRemainder, fluidIcon, 16, 16);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("extracells", "textures/gui/fluidtank.png"));
            this.func_73729_b(this.posX + 2, this.posY + 1, 1, 1, 15, 72 - (int)(73.0f * ((float)fluid.amount / (float)this.tank.getCapacity())));
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("extracells", "textures/gui/fluidtank.png"));
        this.func_73729_b(this.posX + 1, this.posY + 1, 19, 1, 16, 73);
        GL11.glEnable((int)2896);
    }

    protected void drawHoveringText(List list, int x, int y, FontRenderer fontrenderer) {
        if (!list.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : list) {
                int l = fontrenderer.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (list.size() > 1) {
                k1 += 2 + (list.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                String s1 = (String)list.get(k2);
                fontrenderer.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public void drawDirectionTooltip(int x, int y) {
        ArrayList<String> description = new ArrayList<String>();
        description.add(StatCollector.func_74838_a((String)("extracells.tooltip.direction." + this.direction.ordinal())));
        if (this.tank == null || this.tank.getFluid() == null) {
            description.add(StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
        } else if (this.tank.getFluid().amount > 0 && this.tank.getFluid().getFluid() != null) {
            String amountToText = this.tank.getFluid().amount + "mB";
            description.add(this.tank.getFluid().getFluid().getLocalizedName(this.tank.getFluid()));
            description.add(amountToText);
        }
        this.drawHoveringText(description, x, y, Minecraft.func_71410_x().field_71466_p);
    }

    public void drawTooltip(int x, int y) {
        ArrayList<String> description = new ArrayList<String>();
        if (this.tank == null || this.tank.getFluid() == null) {
            description.add(StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
        } else if (this.tank.getFluid().amount > 0 && this.tank.getFluid().getFluid() != null) {
            String amountToText = this.tank.getFluid().amount + "mB";
            description.add(this.tank.getFluid().getFluid().getLocalizedName(this.tank.getFluid()));
            description.add(amountToText);
        }
        this.drawHoveringText(description, x, y, Minecraft.func_71410_x().field_71466_p);
    }
}

