/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.api.IStorageCellVoid;
import extracells.inventory.VoidCellInventoryHandler;
import extracells.item.ItemAdvancedStorageCell;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public final class ItemVoidStorageCell
extends AEBaseItem
implements IStorageCellVoid,
IItemGroup {
    private final int totalBytes;
    private final int totalTypes;
    private final int perType;
    private final double idleDrain;
    private final String suffix;
    private IIcon icon;

    public ItemVoidStorageCell() {
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = 1024;
        this.totalTypes = 63;
        this.perType = 8;
        this.idleDrain = 0.0;
        this.suffix = "void";
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventoryHandler handler;
        ICellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (inventory instanceof VoidCellInventoryHandler && (cellInventory = (handler = (ICellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add("Deletes \u00a74everything\u00a77 stored on it ");
            lines.add(cellInventory.getUsedBytes() + " " + GuiText.Of.getLocal() + " \u00a7k9999\u00a77 " + GuiText.BytesUsed.getLocal());
            ItemAdvancedStorageCell.format(lines, handler, cellInventory);
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return this.totalTypes;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.storage.physical.void";
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("extracells:storage.physical.void");
    }

    public IIcon func_77617_a(int dmg) {
        return this.icon;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public String getOreFilter(ItemStack is) {
        return Platform.openNbtData((ItemStack)is).func_74779_i("OreFilter");
    }

    public void setOreFilter(ItemStack is, String filter) {
        Platform.openNbtData((ItemStack)is).func_74778_a("OreFilter", filter);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        Iterator iterator = AEApi.instance().definitions().materials().emptyStorageCell().maybeStack(1).asSet().iterator();
        if (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            return stack;
        }
        throw new MissingDefinition("Tried to use empty storage cells while basic storage cells are defined.");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return AEConfig.instance.isFeatureEnabled(AEFeature.EnableDisassemblyCrafting);
    }
}

