/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.part.PartFluidStorageMonitor;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class PartFluidConversionMonitor
extends PartFluidStorageMonitor {
    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (super.onActivate(player, pos)) {
            return true;
        }
        if (player == null || player.field_70170_p == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack heldItem = player.func_71045_bC();
        IMEMonitor<IAEFluidStack> mon = this.getFluidStorage();
        if (this.locked && heldItem != null && mon != null) {
            ItemStack container = heldItem.func_77946_l();
            container.field_77994_a = 1;
            MachineSource src = new MachineSource((IActionHost)this);
            ItemStack result = null;
            if (FluidUtil.isFilled(container)) {
                FluidStack f = FluidUtil.getFluidFromContainer(container);
                if (f == null) {
                    return true;
                }
                ItemStack simulation = FluidUtil.drainItemIntoAe(container, mon, Actionable.SIMULATE, (BaseActionSource)src);
                if (simulation == null) {
                    return true;
                }
                result = FluidUtil.drainItemIntoAe(container, mon, Actionable.MODULATE, (BaseActionSource)src);
            } else if (FluidUtil.isEmpty(container)) {
                if (this.fluid == null) {
                    return true;
                }
                MutablePair<ItemStack, FluidStack> simulation = FluidUtil.fillItemFromAe(container, new FluidStack(this.fluid, Integer.MAX_VALUE), mon, Actionable.SIMULATE, (BaseActionSource)src);
                if (simulation == null || simulation.getLeft() == null) {
                    return true;
                }
                result = (ItemStack)FluidUtil.fillItemFromAe(container, new FluidStack(this.fluid, Integer.MAX_VALUE), mon, Actionable.MODULATE, (BaseActionSource)src).getLeft();
            }
            if (result == null) {
                return true;
            }
            TileEntity tile = this.getHost().getTile();
            ForgeDirection side = this.getSide();
            this.dropItems(tile.func_145831_w(), tile.field_145851_c + side.offsetX, tile.field_145848_d + side.offsetY, tile.field_145849_e + side.offsetZ, result);
            ItemStack newHeldItem = heldItem.func_77946_l();
            --newHeldItem.field_77994_a;
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newHeldItem.field_77994_a <= 0 ? null : newHeldItem);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        rh.setInvColor(0xFFFFFF);
        rh.renderInventoryFace(TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.setInvColor(AEColor.Transparent.blackVariant);
        rh.renderInventoryFace(TextureManager.CONVERSION_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.mediumVariant);
        rh.renderInventoryFace(TextureManager.CONVERSION_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.whiteVariant);
        rh.renderInventoryFace(TextureManager.CONVERSION_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        ts.func_78378_d(0xFFFFFF);
        rh.renderFace(x, y, z, TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        IPartHost host = this.getHost();
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(host.getColor().mediumVariant);
        rh.renderFace(x, y, z, TextureManager.CONVERSION_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().whiteVariant);
        rh.renderFace(x, y, z, TextureManager.CONVERSION_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().blackVariant);
        rh.renderFace(x, y, z, TextureManager.CONVERSION_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }
}

